/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.AbstractCompilerStep;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfiguration;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfigurations;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;

public class QVTcCompilerChain
extends AbstractCompilerChain {
    protected final @NonNull Xtext2QVTcCompilerStep xtext2qvtcCompilerStep = this.createXtext2QVTcCompilerStep();

    public QVTcCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull CompilerOptions options) {
        super(environmentFactory, txURI, intermediateFileNamePrefixURI, options);
    }

    @Override
    public @NonNull ImperativeTransformation compile(@NonNull TypedModelsConfigurations typedModelsConfigurations) throws IOException {
        Resource cResource = this.xtext2qvtcCompilerStep.execute(this.txURI);
        TypedModelsConfiguration typedModelsConfiguration = typedModelsConfigurations.iterator().next();
        Resource pResource = this.qvtc2qvtm(cResource, typedModelsConfiguration);
        return this.qvtm2qvti(pResource, typedModelsConfiguration);
    }

    protected @NonNull Xtext2QVTcCompilerStep createXtext2QVTcCompilerStep() {
        return new Xtext2QVTcCompilerStep(this);
    }

    public static class Xtext2QVTcCompilerStep
    extends AbstractCompilerStep {
        public Xtext2QVTcCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "QVTc");
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull Resource execute(@NonNull URI txURI) throws IOException {
            ASResource cResource = QVTcoreUtil.loadTransformations((QVTbaseEnvironmentFactory)this.environmentFactory, (URI)txURI, (boolean)false);
            cResource.setURI(this.getURI());
            @NonNull List missingOperationCallSources = QVTbaseUtil.rewriteMissingOperationCallSources((EnvironmentFactory)this.environmentFactory, (Resource)cResource);
            if (missingOperationCallSources != null) {
                QVTruntimeUtil.errPrintln((String)("Missing OperationCallExp sources were fixed up for '" + txURI + "'"));
            }
            QVTcCompilerChain.checkForProxyURIs((Resource)cResource);
            this.saveResource((Resource)cResource);
            return cResource;
        }
    }
}

