/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtrelation.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.ocl.xtext.base.serializer.DeclarativeFormatter;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelation;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.eclipse.qvtd.xtext.qvtrelation.QVTrelationStandaloneSetup;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class QVTrFormatTests
extends LoadTestCase {
    protected @NonNull OCLInternal createOCL() {
        return QVTrelation.newInstance((ProjectManager)this.getTestProjectManager(), null);
    }

    public void setUp() throws Exception {
        XtextCompilerUtil.doQVTrelationSetup();
        super.setUp();
    }

    protected @NonNull ResourceSet doReformatInit(@NonNull OCL ocl) {
        ResourceSet resourceSet = ocl.getResourceSet();
        ProjectManager.CLASS_PATH.initializeResourceSet(resourceSet);
        return resourceSet;
    }

    private @NonNull EObject doReformatLoad(@NonNull ResourceSet resourceSet, @NonNull URI inputURI) {
        String extension = inputURI.fileExtension();
        String stem = inputURI.trimFileExtension().lastSegment();
        String outputName = String.valueOf(stem) + "." + extension + ".xmi";
        String output2Name = String.valueOf(stem) + ".saved." + extension;
        URI outputURI = this.getTestFileURI(outputName);
        URI output2URI = this.getTestFileURI(output2Name);
        Resource xtextResource = resourceSet.getResource(inputURI, true);
        QVTrFormatTests.assertNoResourceErrors((String)"Load failed", (Resource)xtextResource);
        QVTrFormatTests.assertNoUnresolvedProxies((String)"Unresolved proxies", (Resource)xtextResource);
        QVTrFormatTests.assertNoValidationErrors((String)"Validation errors", (EObject)((EObject)xtextResource.getContents().get(0)));
        xtextResource.setURI(output2URI);
        EObject rootEObject = (EObject)xtextResource.getContents().get(0);
        return rootEObject;
    }

    protected @NonNull String doReformatReference(@NonNull ResourceSet resourceSet, @NonNull URI referenceURI) throws IOException {
        InputStream referenceStream = resourceSet.getURIConverter().createInputStream(referenceURI, null);
        String referenceText = this.readFile(referenceStream);
        return referenceText;
    }

    protected void doReformatText(@NonNull DeclarativeFormatter declarativeFormatter, @NonNull ICompositeNode rootNode, int selectOffset, int selectLength, String referenceText) throws IOException {
        Resource xtextResource = rootNode.getSemanticElement().eResource();
        URI xmiURI = xtextResource.getURI().trimFileExtension().trimFileExtension().appendFileExtension("xmi");
        XMLResource xmiResource = (XMLResource)xtextResource.getResourceSet().createResource(xmiURI);
        xmiResource.getContents().addAll((Collection)xtextResource.getContents());
        xmiResource.save(XMIUtil.createSaveOptions((XMLResource)xmiResource));
        xtextResource.getContents().addAll((Collection)xmiResource.getContents());
        String text = rootNode.getText();
        int selectEnd = selectOffset + selectLength;
        String unformattedText = text.substring(selectOffset, selectEnd);
        INodeModelFormatter.IFormattedRegion region = declarativeFormatter.format(rootNode, selectOffset, selectLength);
        String formattedText = String.valueOf(text.substring(0, selectOffset)) + region.getFormattedText() + text.substring(selectEnd);
        QVTrFormatTests.assertEquals((String)referenceText, (String)formattedText);
    }

    public @NonNull String readFile(@NonNull InputStream inputStream) throws IOException {
        int len;
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringBuilder s = new StringBuilder();
        char[] buf = new char[16384];
        while ((len = reader.read(buf)) >= 0) {
            s.append(buf, 0, len);
        }
        ((Reader)reader).close();
        return s.toString();
    }

    protected @NonNull String replace(@NonNull LazyLinkingResource xtextResource, @NonNull ICompositeNode rootNode, @NonNull String oldString, @NonNull String newString) {
        String xtextContent = rootNode.getText();
        int index = xtextContent.indexOf(oldString);
        assert (index >= 0);
        xtextResource.update(index, oldString.length(), newString);
        return rootNode.getText();
    }

    public void testQVTrFormat_HierarchicalStateMachine2FlatStateMachine() throws IOException, InterruptedException {
        DeclarativeFormatter declarativeFormatter = (DeclarativeFormatter)new QVTrelationStandaloneSetup().createInjector().getInstance(DeclarativeFormatter.class);
        OCLInternal ocl = this.createOCL();
        URI inputURI = this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr");
        URI referenceURI = this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr");
        ResourceSet resourceSet = this.doReformatInit((OCL)ocl);
        String referenceText = this.doReformatReference(resourceSet, referenceURI);
        EObject rootEObject = this.doReformatLoad(resourceSet, inputURI);
        ICompositeNode rootNode = NodeModelUtils.getNode((EObject)rootEObject);
        assert (rootNode != null);
        int rootOffset = rootNode.getOffset();
        int rootLength = rootNode.getLength();
        int totalOffset = rootNode.getTotalOffset();
        int totalLength = rootNode.getTotalLength();
        int selectOffset = 0;
        int selectLength = rootLength;
        this.doReformatText(declarativeFormatter, rootNode, selectOffset, selectLength, referenceText);
        ocl.dispose();
    }
}

