/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.tests.qvt.oml.ui.editor;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.tests.qvt.oml.ui.editor.AbstractTestQvtEditorSupport;
import org.eclipse.m2m.tests.qvt.oml.util.ProblemSourceAnnotationHelper;
import org.eclipse.m2m.tests.qvt.oml.util.SourceAnnotationReader;
import org.eclipse.ui.texteditor.ITextEditor;

public class TestQvtProblemAnnotations
extends AbstractTestQvtEditorSupport {
    private List<QvtMessage> fProblems;

    public TestQvtProblemAnnotations(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.fProblems = TestQvtProblemAnnotations.getQVTDocumentProvider((ITextEditor)this.fEditor).getCompiledModule().getProblems();
    }

    public void testProblemAnnotations() throws Exception {
        List<SourceAnnotationReader.AnnotationData> sourceAnnotations = this.readSourceAnnotations((ITextEditor)this.fEditor);
        TestQvtProblemAnnotations.assertFalse((boolean)sourceAnnotations.isEmpty());
        ProblemSourceAnnotationHelper problemHelper = new ProblemSourceAnnotationHelper(sourceAnnotations);
        IAnnotationHover hover = this.fEditor.getQvtConfiguration().getAnnotationHover(this.fEditor.getEditorSourceViewer());
        for (QvtMessage problemMessage : this.fProblems) {
            SourceAnnotationReader.AnnotationData expectedAnnotation = problemHelper.findAnnotationByPosition(problemMessage);
            TestQvtProblemAnnotations.assertNotNull((Object)expectedAnnotation);
            Annotation foundEditorAnnotation = this.findAnnotation(expectedAnnotation.getAnnotatedRegion());
            TestQvtProblemAnnotations.assertNotNull((Object)foundEditorAnnotation);
            TestQvtProblemAnnotations.assertTrue((boolean)ProblemSourceAnnotationHelper.isTheSameSeverity((SourceAnnotationReader.AnnotationData)expectedAnnotation, (QvtMessage)problemMessage));
            if (ProblemSourceAnnotationHelper.isError((SourceAnnotationReader.AnnotationData)expectedAnnotation)) {
                TestQvtProblemAnnotations.assertEquals((String)"org.eclipse.m2m.qvt.oml.error", (String)foundEditorAnnotation.getType());
            } else if (ProblemSourceAnnotationHelper.isWarning((SourceAnnotationReader.AnnotationData)expectedAnnotation)) {
                TestQvtProblemAnnotations.assertEquals((String)"org.eclipse.m2m.qvt.oml.warning", (String)foundEditorAnnotation.getType());
            } else {
                TestQvtProblemAnnotations.fail((String)"Unexpected problem severity");
            }
            TestQvtProblemAnnotations.assertTrue((String)"Problem message must be used", (boolean)problemMessage.getMessage().contains(foundEditorAnnotation.getText()));
            int line = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput()).getLineOfOffset(problemMessage.getOffset());
            String hoverText = hover.getHoverInfo(this.fEditor.getEditorSourceViewer(), line);
            TestQvtProblemAnnotations.assertTrue((String)"Hover text should include problem message", (hoverText != null && hoverText.contains(problemMessage.getMessage()) ? 1 : 0) != 0);
        }
    }

    private Annotation findAnnotation(SourceAnnotationReader.RegionInfo region) {
        Iterator it = this.fEditor.getAnnotationModel().getAnnotationIterator();
        while (it.hasNext()) {
            Annotation nextAnnotation = (Annotation)it.next();
            Position pos = this.fEditor.getAnnotationModel().getPosition(nextAnnotation);
            if (region.getOffset() != pos.offset || region.getLength() != pos.length) continue;
            return nextAnnotation;
        }
        return null;
    }
}

