/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.debug.core;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.m2m.atl.adt.debug.AtlDebugMessages;
import org.eclipse.m2m.atl.adt.debug.AtlDebugPlugin;
import org.eclipse.m2m.atl.adt.debug.core.AtlBreakpoint;
import org.eclipse.m2m.atl.adt.debug.core.AtlDebugElement;
import org.eclipse.m2m.atl.adt.debug.core.AtlDebugModelConstants;
import org.eclipse.m2m.atl.adt.debug.core.AtlStackFrame;
import org.eclipse.m2m.atl.adt.debug.core.AtlThread;
import org.eclipse.m2m.atl.engine.AtlNbCharFile;
import org.eclipse.m2m.atl.engine.vm.adwp.ADWPCommand;
import org.eclipse.m2m.atl.engine.vm.adwp.ADWPDebugger;
import org.eclipse.m2m.atl.engine.vm.adwp.IntegerValue;
import org.eclipse.m2m.atl.engine.vm.adwp.ObjectReference;
import org.eclipse.m2m.atl.engine.vm.adwp.StringValue;

public class AtlDebugTarget
extends AtlDebugElement
implements IDebugTarget {
    private int state;
    public static final int stateTerminated = 0;
    public static final int stateRunning = 1;
    public static final int stateSuspended = 2;
    public static final int stateDisconnected = 3;
    static final int TERMINATE = 0;
    static final int SUSPEND = 1;
    static final int STEP_RETURN = 2;
    static final int STEP_OVER = 3;
    static final int STEP_INTO = 4;
    static final int SUSPEND_STEP = 5;
    static final int RESUME = 6;
    static final int CREATE = 7;
    private ADWPDebugger debugger;
    private ILaunch launch;
    private boolean disassemblyMode = false;
    private String prevLocation = null;
    private String processName = AtlDebugModelConstants.DEBUGTARGETNAME;
    private String port = "<null>";
    private String host = "<null>";
    private Socket socket = null;
    private String messageFromDebuggee = "";
    private AtlThread[] threads;
    private AtlNbCharFile structFile;
    private Pattern moduleName = Pattern.compile("^.*/(.*)\\.a(tl|sm)$");

    public AtlDebugTarget(ILaunch launch) {
        super(null);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        try {
            this.disassemblyMode = launch.getLaunchConfiguration().getAttribute("Mode Debug", false);
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        this.state = 3;
        this.launch = launch;
    }

    public void start() {
        logger.info(AtlDebugMessages.getString("AtlDebugTarget.CONNECTIONDEBUGEE"));
        try {
            do {
                try {
                    try {
                        this.port = this.launch.getLaunchConfiguration().getAttribute("Port", "6060");
                        this.host = this.launch.getLaunchConfiguration().getAttribute("Host", "localhost");
                        if (this.port.equals("")) {
                            this.port = "6060";
                        }
                        if (this.host.equals("")) {
                            this.host = "localhost";
                        }
                        this.socket = new Socket(this.host, Integer.parseInt(this.port));
                    }
                    catch (CoreException e1) {
                        logger.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
                    }
                }
                catch (ConnectException connectException) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } while (this.socket == null);
            this.debugger = new ADWPDebugger(this.socket.getInputStream(), this.socket.getOutputStream());
            logger.info(AtlDebugMessages.getString("AtlDebugTarget.CONNECTED"));
            this.state = 2;
            this.threads = new AtlThread[1];
            this.threads[0] = new AtlThread(AtlDebugModelConstants.THREADNAME, this);
            IBreakpoint[] bpArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
            int i = 0;
            while (i < bpArray.length) {
                this.breakpointAdded(bpArray[i]);
                ++i;
            }
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        new Thread(){

            public void run() {
                ADWPCommand msg;
                AtlDebugTarget.this.prevLocation = null;
                AtlDebugTarget.this.generateDebugEvent(7, AtlDebugTarget.this);
                while ((msg = AtlDebugTarget.this.debugger.readMessage()).getCode() != 103) {
                    AtlDebugTarget.this.messageFromDebuggee = ((StringValue)msg.getArgs().get(0)).getValue();
                    ObjectReference currentFrame = (ObjectReference)msg.getArgs().get(1);
                    String sourceLocation = ((StringValue)msg.getArgs().get(4)).getValue();
                    if (sourceLocation.equals("<null>") && !AtlDebugTarget.this.disassemblyMode) {
                        AtlDebugTarget.this.debugger.sendCommand(1, Arrays.asList(new Object[0]));
                        continue;
                    }
                    if (sourceLocation.equals(AtlDebugTarget.this.prevLocation) && !AtlDebugTarget.this.disassemblyMode) {
                        AtlDebugTarget.this.debugger.sendCommand(1, Arrays.asList(new Object[0]));
                        continue;
                    }
                    ObjectReference stack = (ObjectReference)currentFrame.call("getStack", new ArrayList());
                    int n = ((IntegerValue)stack.call("size", new ArrayList())).getValue();
                    AtlStackFrame[] frames = new AtlStackFrame[n];
                    int i = 1;
                    while (i <= n) {
                        ObjectReference stackFrame = (ObjectReference)stack.call("at", Arrays.asList(IntegerValue.valueOf((int)i)));
                        try {
                            String fileName = AtlDebugTarget.this.getPathFrom(stackFrame);
                            IWorkspace wks = ResourcesPlugin.getWorkspace();
                            IWorkspaceRoot wksroot = wks.getRoot();
                            IFile file = wksroot.getFile((IPath)new Path(fileName));
                            file.refreshLocal(0, null);
                            AtlDebugTarget.this.structFile = new AtlNbCharFile(file.getContents());
                            frames[n - i] = new AtlStackFrame(AtlDebugTarget.this.threads[0], stackFrame, AtlDebugTarget.this.structFile, file);
                        }
                        catch (CoreException e1) {
                            logger.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
                        }
                        ++i;
                    }
                    AtlDebugTarget.this.threads[0].setStackFrames(frames);
                    AtlDebugTarget.this.setState(2);
                    AtlDebugTarget.this.generateDebugEvent(5, AtlDebugTarget.this);
                    AtlDebugTarget.this.prevLocation = sourceLocation;
                }
                AtlDebugTarget.this.setState(2);
                try {
                    AtlDebugTarget.this.terminate();
                }
                catch (DebugException e) {
                    logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        }.start();
    }

    private String getPathFrom(ObjectReference stackFrame) throws CoreException {
        String path2 = null;
        ObjectReference operation = (ObjectReference)stackFrame.call("getOperation", Collections.EMPTY_LIST);
        Assert.isNotNull((Object)operation);
        ObjectReference asm = (ObjectReference)operation.call("getASM", Collections.EMPTY_LIST);
        Assert.isNotNull((Object)asm);
        String asmName = ((StringValue)asm.call("getName", Collections.EMPTY_LIST)).getValue();
        Assert.isNotNull((Object)asmName);
        ILaunchConfiguration configuration = this.launch.getLaunchConfiguration();
        List superimpose = configuration.getAttribute("Superimpose", new ArrayList());
        for (String path2 : superimpose) {
            if (!asmName.equals(this.getAsmNameFrom(path2))) continue;
            return String.valueOf(path2.substring(0, path2.length() - 3)) + "atl";
        }
        Map libraries = configuration.getAttribute("Libs", new HashMap());
        for (String lib : libraries.keySet()) {
            path2 = (String)libraries.get(lib);
            if (!asmName.equals(lib) && !asmName.equals(this.getAsmNameFrom(path2))) continue;
            return String.valueOf(path2.substring(0, path2.length() - 3)) + "atl";
        }
        path2 = configuration.getAttribute("ATL File Name", "<null>");
        return path2;
    }

    private String getAsmNameFrom(String path) {
        String asmName = null;
        Matcher m = this.moduleName.matcher(path);
        if (m.find()) {
            asmName = m.group(1);
        }
        return asmName;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        AtlBreakpoint ab = (AtlBreakpoint)breakpoint;
        String location = "";
        Boolean enabled = new Boolean(false);
        try {
            location = (String)ab.getMarker().getAttribute("location");
            enabled = (Boolean)ab.getMarker().getAttribute("org.eclipse.debug.core.enabled");
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return;
        }
        if (enabled.booleanValue()) {
            ArrayList<StringValue> parameter = new ArrayList<StringValue>();
            parameter.add(StringValue.valueOf((String)location));
            this.debugger.sendCommand(13, parameter);
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        AtlBreakpoint ab = (AtlBreakpoint)breakpoint;
        String location = "";
        Boolean enabled = new Boolean(false);
        try {
            location = (String)ab.getMarker().getAttribute("location");
            enabled = (Boolean)ab.getMarker().getAttribute("org.eclipse.debug.core.enabled");
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return;
        }
        ArrayList<StringValue> parameter = new ArrayList<StringValue>();
        parameter.add(StringValue.valueOf((String)location));
        if (enabled.booleanValue()) {
            this.debugger.sendCommand(13, parameter);
        } else {
            this.debugger.sendCommand(14, parameter);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        AtlBreakpoint ab = (AtlBreakpoint)breakpoint;
        String location = "";
        try {
            location = (String)ab.getMarker().getAttribute("location");
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return;
        }
        ArrayList<String> parameter = new ArrayList<String>();
        parameter.add(location);
        this.debugger.sendCommand(14, parameter);
    }

    public boolean canDisconnect() {
        return !this.isDisconnected();
    }

    public boolean canResume() {
        return this.state != 3 && this.state != 1;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public void disconnect() throws DebugException {
        this.setState(3);
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public String getModelIdentifier() {
        return AtlDebugPlugin.getUniqueIdentifier();
    }

    public String getName() throws DebugException {
        return this.processName;
    }

    public IProcess getProcess() {
        return null;
    }

    public IThread[] getThreads() throws DebugException {
        return this.threads;
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreads() != null && this.getThreads().length > 0;
    }

    public boolean isDisconnected() {
        return this.state == 3;
    }

    public boolean isSuspended() {
        return this.state == 2;
    }

    public boolean isTerminated() {
        return this.state == 0;
    }

    public void resume() throws DebugException {
        if (!this.isSuspended()) {
            return;
        }
        this.prevLocation = null;
        this.setState(1);
        this.generateDebugEvent(6, this);
        this.debugger.sendCommand(0, Arrays.asList(new Object[0]));
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof AtlBreakpoint;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public void suspend() throws DebugException {
        if (this.isSuspended()) {
            return;
        }
        this.setState(2);
        this.generateDebugEvent(1, this);
    }

    public void terminate() throws DebugException {
        if (!this.isSuspended()) {
            return;
        }
        this.setState(0);
        this.debugger.sendCommand(3, Arrays.asList(new Object[0]));
        this.generateDebugEvent(0, this);
    }

    public ADWPDebugger getDebugger() {
        return this.debugger;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    void generateDebugEvent(int command, IDebugElement contextObject) {
        DebugEvent event = null;
        try {
            switch (command) {
                case 7: {
                    event = new DebugEvent((Object)this.getDebugTarget().getThreads()[0], 4);
                    break;
                }
                case 4: {
                    event = new DebugEvent((Object)this.getDebugTarget().getThreads()[0], 1, 1);
                    break;
                }
                case 3: {
                    event = new DebugEvent((Object)this.getDebugTarget().getThreads()[0], 1, 2);
                    break;
                }
                case 2: {
                    event = new DebugEvent((Object)this.getDebugTarget().getThreads()[0], 1, 4);
                    break;
                }
                case 6: {
                    event = new DebugEvent((Object)this.getDebugTarget().getThreads()[0], 1);
                    break;
                }
                case 1: {
                    event = new DebugEvent((Object)this.getDebugTarget().getThreads()[0], 2, 32);
                    break;
                }
                case 0: {
                    event = new DebugEvent((Object)this.getDebugTarget(), 8);
                    break;
                }
                case 5: {
                    event = new DebugEvent((Object)this.getDebugTarget().getThreads()[0], 2, 16);
                    break;
                }
                default: {
                    return;
                }
            }
            DebugEvent[] debugEvents = new DebugEvent[]{event};
            DebugPlugin.getDefault().fireDebugEventSet(debugEvents);
        }
        catch (DebugException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            if (events[i].getDetail() == 2) {
                this.setState(2);
            }
            ++i;
        }
    }

    public boolean isDisassemblyMode() {
        return this.disassemblyMode;
    }

    public void setDisassemblyMode(boolean disassemblyMode) {
        this.disassemblyMode = disassemblyMode;
    }

    public void setPrevLocation(String prevLocation) {
        this.prevLocation = prevLocation;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getMessageFromDebuggee() {
        return this.messageFromDebuggee;
    }
}

