/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.launch;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;

public class WriterMonitor
extends Writer
implements IStreamMonitor {
    private List<IStreamListener> myListeners;
    private final StringBuffer myContents = new StringBuffer();

    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        String newText = new String(cbuf, off, len);
        this.myContents.append(newText);
        this.notifyListeners(newText);
    }

    public String getContents() {
        return this.myContents.toString();
    }

    private void notifyListeners(String newText) {
        IStreamListener[] listeners;
        if (this.myListeners == null) {
            return;
        }
        IStreamListener[] iStreamListenerArray = listeners = this.myListeners.toArray(new IStreamListener[this.myListeners.size()]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IStreamListener listener = iStreamListenerArray[n2];
            listener.streamAppended(newText, (IStreamMonitor)this);
            ++n2;
        }
    }

    public void addListener(IStreamListener listener) {
        if (this.myListeners == null) {
            this.myListeners = new ArrayList<IStreamListener>(1);
        }
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removeListener(IStreamListener listener) {
        if (this.myListeners == null) {
            return;
        }
        this.myListeners.remove(listener);
    }
}

