/*
 * Decompiled with CFR 0.152.
 */
package rdb.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import rdb.provider.ElementItemProvider;
import rdb.provider.ModelItemProvider;
import rdb.provider.SchemaItemProvider;
import rdb.provider.TableColumnItemProvider;
import rdb.provider.TableItemProvider;
import rdb.util.RdbAdapterFactory;

public class RdbItemProviderAdapterFactory
extends RdbAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection supportedTypes = new ArrayList();
    protected ElementItemProvider elementItemProvider;
    protected ModelItemProvider modelItemProvider;
    protected SchemaItemProvider schemaItemProvider;
    protected TableItemProvider tableItemProvider;
    protected TableColumnItemProvider tableColumnItemProvider;

    public RdbItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createElementAdapter() {
        if (this.elementItemProvider == null) {
            this.elementItemProvider = new ElementItemProvider((AdapterFactory)this);
        }
        return this.elementItemProvider;
    }

    public Adapter createModelAdapter() {
        if (this.modelItemProvider == null) {
            this.modelItemProvider = new ModelItemProvider((AdapterFactory)this);
        }
        return this.modelItemProvider;
    }

    public Adapter createSchemaAdapter() {
        if (this.schemaItemProvider == null) {
            this.schemaItemProvider = new SchemaItemProvider((AdapterFactory)this);
        }
        return this.schemaItemProvider;
    }

    public Adapter createTableAdapter() {
        if (this.tableItemProvider == null) {
            this.tableItemProvider = new TableItemProvider((AdapterFactory)this);
        }
        return this.tableItemProvider;
    }

    public Adapter createTableColumnAdapter() {
        if (this.tableColumnItemProvider == null) {
            this.tableColumnItemProvider = new TableColumnItemProvider((AdapterFactory)this);
        }
        return this.tableColumnItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }
}

