/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEnvironmentBase;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictionaryType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeOCLFactory;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeOCLPackage;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.Typedef;
import org.eclipse.ocl.AbstractTypeResolver;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BasicTypeResolverImpl
extends AbstractTypeResolver<EPackage, EClassifier, EOperation, EStructuralFeature, EParameter> {
    BasicTypeResolverImpl(QvtEnvironmentBase env) {
        super((Environment)env);
    }

    BasicTypeResolverImpl(QvtEnvironmentBase env, Resource resource) {
        super((Environment)env, resource);
    }

    public EClassifier resolve(EClassifier type) {
        if (type instanceof ListType) {
            return this.resolveListType((EClassifier)((ListType)type).getElementType());
        }
        if (type instanceof DictionaryType) {
            DictionaryType dictType = (DictionaryType)type;
            return this.resolveDictionaryType(dictType.getKeyType(), (EClassifier)dictType.getElementType());
        }
        return (EClassifier)super.resolve((Object)type);
    }

    public ListType resolveListType(EClassifier elementType) {
        ListType listType = this.findListType(elementType);
        if (listType == null) {
            ListType newList = QvtOperationalStdLibrary.INSTANCE.getStdlibFactory().createList(elementType);
            ((EPackage)this.getCollectionPackage()).getEClassifiers().add((Object)newList);
            return newList;
        }
        return listType;
    }

    public DictionaryType resolveDictionaryType(EClassifier keyType, EClassifier elementType) {
        DictionaryType dictionaryType = this.findDictionaryType(keyType, elementType);
        if (dictionaryType == null) {
            DictionaryType newDictionary = QvtOperationalStdLibrary.INSTANCE.getStdlibFactory().createDictionary(keyType, elementType);
            ((EPackage)this.getCollectionPackage()).getEClassifiers().add((Object)newDictionary);
            return newDictionary;
        }
        return dictionaryType;
    }

    private ListType findListType(EClassifier elementType) {
        for (EClassifier next : this.getEnvironment().getUMLReflection().getClassifiers((Object)((EPackage)this.getCollectionPackage()))) {
            if (!(next instanceof ListType)) continue;
            ListType type = (ListType)next;
            if (TypeUtil.getRelationship((Environment)this.getEnvironment(), (Object)((EClassifier)type.getElementType()), (Object)elementType) != 1) continue;
            return type;
        }
        return null;
    }

    private DictionaryType findDictionaryType(EClassifier keyType, EClassifier valueType) {
        for (EClassifier next : this.getEnvironment().getUMLReflection().getClassifiers((Object)((EPackage)this.getCollectionPackage()))) {
            boolean isKeyMatch;
            if (!(next instanceof DictionaryType)) continue;
            DictionaryType type = (DictionaryType)next;
            boolean bl = isKeyMatch = TypeUtil.getRelationship((Environment)this.getEnvironment(), (Object)type.getKeyType(), (Object)keyType) == 1;
            if (!isKeyMatch || TypeUtil.getRelationship((Environment)this.getEnvironment(), (Object)((EClassifier)type.getElementType()), (Object)valueType) != 1) continue;
            return type;
        }
        return null;
    }

    protected org.eclipse.ocl.types.CollectionType<EClassifier, EOperation> findCollectionType(CollectionKind kind, EClassifier elementType) {
        for (EClassifier next : this.getEnvironment().getUMLReflection().getClassifiers((Object)((EPackage)this.getCollectionPackage()))) {
            org.eclipse.ocl.types.CollectionType type;
            if (!(next instanceof org.eclipse.ocl.types.CollectionType) || next.eClass() == ImperativeOCLPackage.eINSTANCE.getDictionaryType() || next.eClass() == ImperativeOCLPackage.eINSTANCE.getListType() || (type = (org.eclipse.ocl.types.CollectionType)next).getKind() != kind || TypeUtil.getRelationship((Environment)this.getEnvironment(), (Object)((EClassifier)type.getElementType()), (Object)elementType) != 1) continue;
            return type;
        }
        return null;
    }

    protected Resource createResource() {
        return new EcoreResourceFactoryImpl().createResource(URI.createURI((String)"ocl:///qvto.env.ecore"));
    }

    protected EPackage createTuplePackage() {
        EPackage result = (EPackage)super.createTuplePackage();
        return result;
    }

    protected EPackage createPackage(String name) {
        QvtEnvironmentBase env = (QvtEnvironmentBase)this.getEnvironment();
        Module module = env.getModuleContextType();
        if (module != null) {
            return module;
        }
        EPackage result = EcoreFactory.eINSTANCE.createEPackage();
        result.setName(name);
        this.getResource().getContents().add((Object)result);
        return result;
    }

    protected EPackage findPackage(String name) {
        EPackage result = null;
        for (EObject o : this.getResource().getContents()) {
            EPackage epkg;
            if (!(o instanceof EPackage) || !name.equals((epkg = (EPackage)o).getName()) || epkg instanceof Module) continue;
            result = epkg;
            break;
        }
        return result;
    }

    protected void addClassifier(EPackage pkg, EClassifier classifier) {
        pkg.getEClassifiers().add((Object)classifier);
    }

    protected void addOperation(EClassifier owner, EOperation operation) {
        ((EClass)owner).getEOperations().add((Object)operation);
    }

    protected void addProperty(EClassifier owner, EStructuralFeature property) {
        ((EClass)owner).getEStructuralFeatures().add((Object)property);
    }

    List<EOperation> getAllCompatibleAdditionalOperations(CollectionType type) {
        EPackage pkg;
        ArrayList result = null;
        if (this.hasAdditionalFeatures() && (pkg = (EPackage)this.getAdditionalFeaturesPackage()) != null) {
            UMLReflection uml = this.getEnvironment().getUMLReflection();
            List shadowOwners = uml.getClassifiers((Object)pkg);
            for (EClassifier next : shadowOwners) {
                EClassifier shadowedType = this.getShadowedClassifier(next);
                if (!(shadowedType instanceof CollectionType) || !TypeUtil.compatibleTypeMatch((Environment)this.getEnvironment(), (Object)type, (Object)shadowedType)) continue;
                if (result == null) {
                    result = new ArrayList();
                }
                result.addAll(uml.getOperations((Object)next));
            }
        }
        return result != null ? Collections.unmodifiableList(result) : ECollections.emptyEList();
    }

    protected EClass createShadowClass(EClassifier type) {
        Typedef typeDef = ImperativeOCLFactory.eINSTANCE.createTypedef();
        typeDef.setName(type.getName());
        typeDef.setBase(type);
        return typeDef;
    }

    protected EClassifier getShadowedClassifier(EClassifier shadow) {
        if (shadow instanceof Typedef) {
            Typedef typedef = (Typedef)shadow;
            return typedef.getBase();
        }
        return null;
    }

    protected EClassifier findShadowClass(EClassifier type) {
        EPackage pkg;
        EPackage ePackage = pkg = this.hasAdditionalFeatures() ? (EPackage)this.getAdditionalFeaturesPackage() : null;
        if (pkg != null) {
            for (EClassifier next : this.getEnvironment().getUMLReflection().getClassifiers((Object)pkg)) {
                EClassifier shadowedClassifier = this.getShadowedClassifier(next);
                if (shadowedClassifier == type) {
                    return next;
                }
                if (!(type instanceof TupleType) || !TypeUtil.exactTypeMatch((Environment)this.getEnvironment(), (Object)type, (Object)shadowedClassifier)) continue;
                return next;
            }
        }
        return null;
    }
}

