/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.nature;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2m.internal.qvt.oml.builder.QvtBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.common.nature.TransformationNature;
import org.eclipse.m2m.internal.qvt.oml.project.QVTProjectPlugin;
import org.eclipse.m2m.internal.qvt.oml.project.nature.NatureConfigParticipantManager;
import org.eclipse.m2m.internal.qvt.oml.project.nature.TransformationNatureConfigParticipant;

public class TransformationNatureImpl
implements TransformationNature {
    public static final String DEFAULT_SOURCE_FOLDER_PATH = "transformations";
    private IProject myProject;

    public void configure() throws CoreException {
        IProject project = this.getProject();
        if (project != null) {
            IProjectDescription description = project.getDescription();
            TransformationNatureConfigParticipant[] configParticipants = NatureConfigParticipantManager.getParticipants();
            int i = 0;
            while (i < configParticipants.length) {
                TransformationNatureConfigParticipant participant = configParticipants[i];
                participant.configure(description);
                ++i;
            }
            project.setDescription(description, null);
            this.setupDefaultSourceContainer();
        }
    }

    private void setupDefaultSourceContainer() {
        assert (this.getProject() != null);
        IContainer container = null;
        IProject project = this.getProject();
        if (project != null) {
            try {
                QvtBuilderConfig config = QvtBuilderConfig.getConfig((IProject)this.getProject());
                container = config.getRawSourceContainer();
                if (container == null) {
                    IFolder folder = this.getProject().getFolder((IPath)new Path(DEFAULT_SOURCE_FOLDER_PATH));
                    container = folder;
                    if (!folder.exists()) {
                        folder.create(true, true, null);
                    }
                    config.setSourceContainer(container);
                }
            }
            catch (CoreException e) {
                QVTProjectPlugin.log(e.getStatus());
            }
        }
    }

    public void deconfigure() throws CoreException {
        IProject project = this.getProject();
        if (project != null) {
            IProjectDescription description = project.getDescription();
            TransformationNatureConfigParticipant[] configParticipants = NatureConfigParticipantManager.getParticipants();
            int i = 0;
            while (i < configParticipants.length) {
                TransformationNatureConfigParticipant participant = configParticipants[i];
                participant.deconfigure(description);
                ++i;
            }
            project.setDescription(description, null);
        }
    }

    public IProject getProject() {
        return this.myProject;
    }

    public void setProject(IProject project) {
        this.myProject = project;
    }
}

