/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.service;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.service.CoreService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LauncherService {
    public static final String REFINING_TRACE_METAMODEL = "RefiningTrace";
    public static final String REFINING_TRACE_MODEL = "refiningTrace";

    private LauncherService() {
    }

    public static Object launch(String mode, IProgressMonitor monitor, ILauncher launcher, Map<String, String> inModels, Map<String, String> inoutModels, Map<String, String> outModels, Map<String, String> paths, Map<String, Object> options, Map<String, InputStream> libraries, InputStream ... modules) throws ATLCoreException {
        IModel model;
        String referenceModelName;
        launcher.initialize(options);
        Map modelHandlers = (Map)options.get("modelHandlers");
        boolean isRefiningTraceMode = "true".equals(options.get("isRefiningTraceMode"));
        ModelFactory defaultFactory = null;
        IExtractor extractor = null;
        IInjector injector = null;
        defaultFactory = CoreService.createModelFactory(launcher.getDefaultModelFactoryName());
        extractor = CoreService.getExtractor(defaultFactory.getDefaultExtractorName());
        injector = CoreService.getInjector(defaultFactory.getDefaultInjectorName());
        if (isRefiningTraceMode) {
            IReferenceModel refiningTraceMetamodel = defaultFactory.getBuiltInResource("RefiningTrace.ecore");
            HashMap<String, Object> modelOptions = new HashMap<String, Object>();
            modelOptions.put("path", "temp");
            modelOptions.put("modelName", REFINING_TRACE_MODEL);
            modelOptions.put("newModel", true);
            IModel refiningTraceModel = defaultFactory.newModel(refiningTraceMetamodel, modelOptions);
            launcher.addOutModel(refiningTraceModel, REFINING_TRACE_MODEL, REFINING_TRACE_METAMODEL);
        }
        for (String modelName : inModels.keySet()) {
            referenceModelName = inModels.get(modelName);
            model = LauncherService.getModel(modelName, referenceModelName, false, launcher, defaultFactory, paths, injector, modelHandlers);
            launcher.addInModel(model, modelName, referenceModelName);
        }
        for (String modelName : inoutModels.keySet()) {
            referenceModelName = inoutModels.get(modelName);
            model = LauncherService.getModel(modelName, referenceModelName, false, launcher, defaultFactory, paths, injector, modelHandlers);
            launcher.addInOutModel(model, modelName, referenceModelName);
        }
        for (String modelName : outModels.keySet()) {
            referenceModelName = outModels.get(modelName);
            model = LauncherService.getModel(modelName, referenceModelName, true, launcher, defaultFactory, paths, injector, modelHandlers);
            launcher.addOutModel(model, modelName, referenceModelName);
        }
        for (Map.Entry<String, InputStream> library : libraries.entrySet()) {
            launcher.addLibrary(library.getKey(), library.getValue());
        }
        Object transformationResult = launcher.launch(mode, monitor, options, modules);
        for (String modelName : outModels.keySet()) {
            extractor.extract(launcher.getModel(modelName), paths.get(modelName));
        }
        for (String modelName : inoutModels.keySet()) {
            String path = paths.get(LauncherService.getRefinedModelName(modelName));
            if (path == null) continue;
            extractor.extract(launcher.getModel(modelName), path);
        }
        return transformationResult;
    }

    public static Object launch(String mode, IProgressMonitor monitor, ILauncher launcher, Map<String, ModelFactory> modelFactories, Map<String, IExtractor> extractors, Map<String, IInjector> injectors, Map<String, String> inModels, Map<String, String> inoutModels, Map<String, String> outModels, Map<String, String> paths, Map<String, Object> options, Map<String, InputStream> libraries, InputStream ... modules) throws ATLCoreException {
        IModel model;
        String referenceModelName;
        launcher.initialize(options);
        Map modelHandlers = (Map)options.get("modelHandlers");
        boolean isRefiningTraceMode = "true".equals(options.get("isRefiningTraceMode"));
        if (isRefiningTraceMode) {
            ModelFactory factory = modelFactories.get(REFINING_TRACE_METAMODEL);
            IReferenceModel refiningTraceMetamodel = factory.getBuiltInResource("RefiningTrace.ecore");
            HashMap<String, Object> modelOptions = new HashMap<String, Object>();
            modelOptions.put("path", "temp");
            modelOptions.put("modelName", REFINING_TRACE_MODEL);
            modelOptions.put("newModel", true);
            IModel refiningTraceModel = factory.newModel(refiningTraceMetamodel, modelOptions);
            launcher.addOutModel(refiningTraceModel, REFINING_TRACE_MODEL, REFINING_TRACE_METAMODEL);
        }
        for (String modelName : inModels.keySet()) {
            referenceModelName = inModels.get(modelName);
            model = LauncherService.getModel(modelName, referenceModelName, false, launcher, modelFactories.get(referenceModelName), paths, injectors.get(modelName), modelHandlers);
            launcher.addInModel(model, modelName, referenceModelName);
        }
        for (String modelName : inoutModels.keySet()) {
            referenceModelName = inoutModels.get(modelName);
            model = LauncherService.getModel(modelName, referenceModelName, false, launcher, modelFactories.get(referenceModelName), paths, injectors.get(modelName), modelHandlers);
            launcher.addInOutModel(model, modelName, referenceModelName);
        }
        for (String modelName : outModels.keySet()) {
            referenceModelName = outModels.get(modelName);
            model = LauncherService.getModel(modelName, referenceModelName, true, launcher, modelFactories.get(referenceModelName), paths, injectors.get(modelName), modelHandlers);
            launcher.addOutModel(model, modelName, referenceModelName);
        }
        for (Map.Entry<String, InputStream> library : libraries.entrySet()) {
            launcher.addLibrary(library.getKey(), library.getValue());
        }
        Object transformationResult = launcher.launch(mode, monitor, options, modules);
        for (String modelName : outModels.keySet()) {
            extractors.get(modelName).extract(launcher.getModel(modelName), paths.get(modelName));
        }
        for (String modelName : inoutModels.keySet()) {
            extractors.get(modelName).extract(launcher.getModel(modelName), paths.get(LauncherService.getRefinedModelName(modelName)));
        }
        return transformationResult;
    }

    private static IModel getModel(String modelName, String referenceModelName, boolean newModel, ILauncher launcher, ModelFactory modelFactory, Map<String, String> paths, IInjector injector, Map<String, String> modelHandlers) throws ATLCoreException {
        String modelPath;
        IReferenceModel referenceModel = (IReferenceModel)launcher.getModel(referenceModelName);
        if (referenceModel == null) {
            String referenceModelPath = paths.get(referenceModelName);
            if (referenceModelPath == null) {
                throw new ATLCoreException("You must specify a path for " + referenceModelName);
            }
            if (referenceModelPath.startsWith("#")) {
                referenceModel = modelFactory.getMetametamodel();
            } else {
                HashMap<String, Object> referenceModelOptions = new HashMap<String, Object>();
                if (modelHandlers != null) {
                    referenceModelOptions.put("modelHandlerName", modelHandlers.get(referenceModelName));
                }
                referenceModelOptions.put("modelName", referenceModelName);
                referenceModelOptions.put("path", referenceModelPath);
                referenceModel = modelFactory.newReferenceModel(referenceModelOptions);
                injector.inject(referenceModel, referenceModelPath);
            }
        }
        if ((modelPath = paths.get(modelName)) == null) {
            throw new ATLCoreException("You must specify a path for " + modelName);
        }
        if (modelPath.startsWith("#")) {
            return modelFactory.getMetametamodel();
        }
        HashMap<String, Object> modelOptions = new HashMap<String, Object>();
        modelOptions.put("modelName", modelName);
        modelOptions.put("path", modelPath);
        modelOptions.put("newModel", newModel);
        IModel model = modelFactory.newModel(referenceModel, modelOptions);
        if (!newModel) {
            injector.inject(model, modelPath);
        }
        return model;
    }

    public static String getRefinedModelName(String modelName) {
        return "REFINED#" + modelName;
    }
}

