/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;

public class NatureUtils {
    private NatureUtils() {
    }

    public static boolean hasNature(IProjectDescription description, String id) throws CoreException {
        String[] natureIds = description.getNatureIds();
        int i = 0;
        while (i < natureIds.length) {
            if (id.equals(natureIds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void addNature(IProject project, String id) throws CoreException {
        IProjectDescription description = project.getDescription();
        if (NatureUtils.addNature(description, id)) {
            project.setDescription(description, null);
        }
    }

    public static boolean addNature(IProjectDescription description, String id) throws CoreException {
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (id.equals(natures[i])) {
                return false;
            }
            ++i;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 1, natures.length);
        newNatures[0] = id;
        description.setNatureIds(newNatures);
        return true;
    }

    public static void removeNature(IProjectDescription description, String id) throws CoreException {
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (id.equals(natures[i])) {
                String[] newNatures = new String[natures.length - 1];
                System.arraycopy(natures, 0, newNatures, 0, i);
                System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                description.setNatureIds(newNatures);
                return;
            }
            ++i;
        }
    }

    public static boolean addBuilders(IProjectDescription pd, String[] builderIds, String[] insertBefore) {
        ICommand[] commands = pd.getBuildSpec();
        ArrayList<ICommand> newCommandsList = new ArrayList<ICommand>((Collection)Arrays.asList(commands));
        int index = newCommandsList.size() - 1;
        if (index == -1) {
            index = 0;
        }
        int i = 0;
        while (i < insertBefore.length) {
            int temp;
            ICommand command = NatureUtils.findCommand(commands, insertBefore[i]);
            if (command != null && (temp = newCommandsList.indexOf(command)) != -1) {
                index = Math.min(temp, index);
            }
            ++i;
        }
        i = 0;
        while (i < builderIds.length) {
            ICommand builderCommand = NatureUtils.findCommand(commands, builderIds[i]);
            if (builderCommand == null) {
                builderCommand = pd.newCommand();
                builderCommand.setBuilderName(builderIds[i]);
                newCommandsList.add(index, builderCommand);
                ++index;
            }
            ++i;
        }
        if (newCommandsList.size() != commands.length) {
            ICommand[] newCommands = newCommandsList.toArray(new ICommand[newCommandsList.size()]);
            pd.setBuildSpec(newCommands);
            return true;
        }
        return false;
    }

    public static boolean isBuilderEnabled(IProject project, String builderId) throws CoreException {
        if (project == null) {
            return false;
        }
        return NatureUtils.findCommand(project.getDescription().getBuildSpec(), builderId) != null;
    }

    public static ICommand findCommand(IProject project, String builderId) throws CoreException {
        return NatureUtils.findCommand(project.getDescription().getBuildSpec(), builderId);
    }

    public static ICommand findCommand(ICommand[] commands, String builderId) {
        int i = 0;
        while (i < commands.length) {
            if (builderId.equals(commands[i].getBuilderName())) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    public static void updateCommand(IProject project, ICommand command) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        boolean updated = false;
        int i = 0;
        while (i < commands.length) {
            if (command.getBuilderName().equals(commands[i].getBuilderName())) {
                commands[i] = command;
                updated = true;
            }
            ++i;
        }
        if (updated) {
            desc.setBuildSpec(commands);
            project.setDescription(desc, null);
        }
    }

    public static boolean removeBuilders(IProjectDescription pd, String[] builderIds) {
        ICommand[] commands = pd.getBuildSpec();
        ArrayList newCommandsList = new ArrayList(Arrays.asList(commands));
        int i = 0;
        while (i < builderIds.length) {
            ICommand builderCommand = NatureUtils.findCommand(commands, builderIds[i]);
            if (builderCommand != null) {
                newCommandsList.remove(builderCommand);
            }
            ++i;
        }
        if (newCommandsList.size() != commands.length) {
            ICommand[] newCommands = newCommandsList.toArray(new ICommand[newCommandsList.size()]);
            pd.setBuildSpec(newCommands);
            return true;
        }
        return false;
    }
}

