/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelExtentContents;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEvaluationResult;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.modelparam.ResourceEObject;
import org.eclipse.m2m.internal.qvt.oml.evaluator.IntermediatePropertyModelAdapter;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtChangeRecorder;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.internal.qvt.oml.library.IContext;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.QVTUMLReflection;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.types.AnyType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalEvaluationEnv
extends EcoreEvaluationEnvironment {
    private EOperation myOperation;
    private int myCurrentASTOffset = -1;
    private final Stack<Object> myObjectExpOwnerStack;
    private final List<Object> myOperationArgs;
    private Object myOperationSelf;
    private final IContext myContext;
    private final Map<String, Object> myBindings;
    private final List<QvtChangeRecorder> myChangeRecorders = new ArrayList<QvtChangeRecorder>(2);
    private Map<ModelParameter, ModelParameterExtent> myModelExtents;
    private Map<ModelParameter, ModelParameter> myMapImportedExtents;
    private static final ModelParameter UNBOUND_MODEL_EXTENT = null;

    protected QvtOperationalEvaluationEnv(IContext context, EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
        super(parent);
        this.myBindings = new HashMap<String, Object>();
        this.myObjectExpOwnerStack = new Stack();
        this.myOperationArgs = new ArrayList<Object>();
        this.myContext = context;
        if (parent instanceof QvtOperationalEvaluationEnv) {
            this.setModelParameterExtents(((QvtOperationalEvaluationEnv)parent).myModelExtents, ((QvtOperationalEvaluationEnv)parent).myMapImportedExtents);
        } else {
            this.myModelExtents = Collections.emptyMap();
            this.myMapImportedExtents = Collections.emptyMap();
        }
    }

    public Object getInvalid() {
        return this.getInvalidResult();
    }

    public Map<EClass, Set<EObject>> createExtentMap(Object object) {
        return new HashMap<EClass, Set<EObject>>(){
            private static final long serialVersionUID = -4634238504663823715L;

            @Override
            public Set<EObject> get(Object key) {
                if (key instanceof EClass) {
                    return this.collectInstances((EClass)key);
                }
                return Collections.emptySet();
            }

            Set<EObject> collectInstances(EClass context) {
                HashSet<EObject> result = new HashSet<EObject>();
                Map modelExtents = QvtOperationalEvaluationEnv.this.myModelExtents;
                if (modelExtents == null) {
                    return result;
                }
                Collection extents = modelExtents.values();
                for (ModelParameterExtent nextExtent : extents) {
                    for (Object nextObj : nextExtent.getAllObjects()) {
                        if (!(nextObj instanceof EObject) || !QvtOperationalEvaluationEnv.this.isKindOf(nextObj, (EClassifier)context)) continue;
                        result.add((EObject)nextObj);
                    }
                }
                return result;
            }
        };
    }

    public void popObjectExpOwner() {
        this.myObjectExpOwnerStack.pop();
    }

    public Object peekObjectExpOwner() {
        return this.myObjectExpOwnerStack.peek();
    }

    public void pushObjectExpOwner(Object owner) {
        this.myObjectExpOwnerStack.push(owner);
    }

    public List<Object> getOperationArgs() {
        return this.myOperationArgs;
    }

    public void setOperationSelf(Object source) {
        this.myOperationSelf = source;
    }

    public Object getOperationSelf() {
        return this.myOperationSelf;
    }

    public IContext getContext() {
        return this.myContext;
    }

    public String getConfigurationProperty(String name) {
        return this.myContext.getConfiguration().getProperty(name);
    }

    public boolean overrides(EOperation operation, int opcode) {
        if (CallHandler.Access.hasHandler(operation)) {
            return true;
        }
        return super.overrides((Object)operation, opcode);
    }

    public Object callOperation(EOperation operation, int opcode, Object source, Object[] args) throws IllegalArgumentException {
        CallHandler callHandler = CallHandler.Access.getHandler(operation);
        if (callHandler != null) {
            if (source == null || source == this.getInvalidResult()) {
                return this.getInvalidResult();
            }
            return callHandler.invoke(source, args, this, this.getContext());
        }
        return super.callOperation(operation, opcode, source, args);
    }

    public Object navigateProperty(EStructuralFeature property, List<?> qualifiers, Object target) throws IllegalArgumentException {
        EObject eTarget;
        EStructuralFeature resolvedProperty = property;
        if (property instanceof ContextualProperty) {
            IntermediatePropertyModelAdapter.ShadowEntry shadow = IntermediatePropertyModelAdapter.getPropertyHolder((EObject)property.getEContainingClass(), (ContextualProperty)property, target);
            target = shadow.getPropertyRuntimeOwner(target);
            resolvedProperty = shadow.getProperty();
        }
        if (target instanceof Tuple && target instanceof EObject) {
            EObject etarget = (EObject)target;
            resolvedProperty = etarget.eClass().getEStructuralFeature(property.getName());
            if (resolvedProperty == null) {
                return null;
            }
        } else if (property.getEType() instanceof CollectionType && target instanceof EObject && (eTarget = (EObject)target).eClass().getEAllStructuralFeatures().contains((Object)property)) {
            return eTarget.eGet(property, true);
        }
        return super.navigateProperty(resolvedProperty, qualifiers, target);
    }

    public QvtOperationalEvaluationEnv getParent() {
        return (QvtOperationalEvaluationEnv)super.getParent();
    }

    public Object getValueOf(String name) {
        Object result = this.myBindings.get(name);
        if (result == null && name != null && !this.myBindings.containsKey(name) && this.getParent() != null && name.endsWith(".this")) {
            return this.getParent().getValueOf(name);
        }
        if (result instanceof TypedBinding) {
            return ((TypedBinding)result).value;
        }
        return result;
    }

    public EClassifier getTypeOf(String name) {
        Object result = this.myBindings.get(name);
        if (result instanceof TypedBinding) {
            return ((TypedBinding)result).type;
        }
        return null;
    }

    public boolean isOclInvalid(Object value) {
        return this.getInvalidResult() == value;
    }

    public void copyVariableValueFrom(QvtOperationalEvaluationEnv fromEnv, String varName, String targetVarName) {
        Object sourceValue = fromEnv.getValueOf(varName);
        this.replace(targetVarName, sourceValue);
    }

    public void replace(String name, Object value) {
        this.myBindings.put(name, value);
    }

    public void replace(String name, Object value, EClassifier declaredType) {
        if (declaredType != null) {
            this.replace(name, new TypedBinding(value, declaredType));
        } else {
            this.replace(name, value);
        }
    }

    public void add(String name, Object value) {
        if (this.myBindings.containsKey(name)) {
            String message = OCLMessages.bind((String)OCLMessages.BindingExist_ERROR_, (Object)name, (Object)this.myBindings.get(name));
            throw new IllegalArgumentException(message);
        }
        this.myBindings.put(name, value);
    }

    public void add(String name, Object value, EClassifier declaredType) {
        if (declaredType != null) {
            this.add(name, new TypedBinding(value, declaredType));
        } else {
            this.add(name, value);
        }
    }

    public Object remove(String name) {
        Object result = this.myBindings.remove(name);
        if (result instanceof TypedBinding) {
            return ((TypedBinding)result).value;
        }
        return result;
    }

    public void clear() {
        this.myBindings.clear();
    }

    public String toString() {
        return this.myBindings.toString();
    }

    public Set<String> getKeys() {
        return this.myBindings.keySet();
    }

    public boolean isKindOf(Object object, EClassifier classifier) {
        if (classifier instanceof AnyType) {
            return !(object instanceof Collection);
        }
        if (classifier == QvtOperationalStdLibrary.INSTANCE.getElementType() && object instanceof EObject) {
            return QVTUMLReflection.isUserModelElement((EClassifier)((EObject)object).eClass());
        }
        return super.isKindOf(object, classifier);
    }

    public void dispose() {
        for (QvtChangeRecorder qvtChangeRecorder : this.myChangeRecorders) {
            qvtChangeRecorder.dispose();
        }
        this.myChangeRecorders.clear();
    }

    public void createModuleParameterExtents(Module module) {
        LinkedHashMap<ModelParameter, ModelParameterExtent> modelExtents = new LinkedHashMap<ModelParameter, ModelParameterExtent>(module.getModelParameter().size());
        modelExtents.put(UNBOUND_MODEL_EXTENT, new ModelParameterExtent());
        int argIndex = 0;
        for (ModelParameter modelParam : module.getModelParameter()) {
            if (modelParam.getKind() == DirectionKind.OUT) {
                ModelParameterExtent outExtent = new ModelParameterExtent();
                outExtent.setModelParameter(modelParam);
                modelExtents.put(modelParam, outExtent);
                continue;
            }
            if (argIndex >= this.getOperationArgs().size() || !(this.getOperationArgs().get(argIndex) instanceof EObject)) {
                throw new IllegalArgumentException("Missed argument for model parameter: " + modelParam.getName());
            }
            Object argument = this.getOperationArgs().get(argIndex);
            Object argValues = argument instanceof ResourceEObject ? ((ResourceEObject)argument).getChildren() : Collections.singletonList((EObject)argument);
            ModelParameterExtent inOrInoutExtent = new ModelParameterExtent((List<EObject>)argValues);
            inOrInoutExtent.setModelParameter(modelParam);
            modelExtents.put(modelParam, inOrInoutExtent);
            if (modelParam.getKind() == DirectionKind.IN) {
                QvtChangeRecorder qvtChangeRecorder = new QvtChangeRecorder(modelParam);
                qvtChangeRecorder.beginRecording((Collection)argValues);
                this.myChangeRecorders.add(qvtChangeRecorder);
            }
            ++argIndex;
        }
        Map<ModelParameter, ModelParameter> mapImportedExtents = this.createImportedExtentMap(module, module);
        this.setModelParameterExtents(modelExtents, mapImportedExtents);
    }

    private Map<ModelParameter, ModelParameter> createImportedExtentMap(Module rootModule, Module importedModule) {
        HashMap<ModelParameter, ModelParameter> mapImportedExtents = new HashMap<ModelParameter, ModelParameter>();
        for (ModuleImport moduleImport : importedModule.getModuleImport()) {
            if (moduleImport.getModule() == null) continue;
            Module nextModule = moduleImport.getImportedModule();
            mapImportedExtents.putAll(this.getExtentMap(rootModule, nextModule));
            mapImportedExtents.putAll(this.createImportedExtentMap(rootModule, nextModule));
        }
        return mapImportedExtents;
    }

    private Map<ModelParameter, ModelParameter> getExtentMap(Module rootModule, Module importedModule) {
        HashMap<ModelParameter, ModelParameter> mapImportedModelParams = new HashMap<ModelParameter, ModelParameter>();
        HashSet<ModelParameter> consideredParams = new HashSet<ModelParameter>();
        block0: for (ModelParameter importedParam : importedModule.getModelParameter()) {
            for (ModelParameter param : rootModule.getModelParameter()) {
                if (consideredParams.contains(param) || !QvtOperationalUtil.isModelParamEqual(param, importedParam, true)) continue;
                consideredParams.add(param);
                mapImportedModelParams.put(importedParam, param);
                continue block0;
            }
        }
        block2: for (ModelParameter importedParam : importedModule.getModelParameter()) {
            if (mapImportedModelParams.containsKey(importedParam)) continue;
            for (ModelParameter param : rootModule.getModelParameter()) {
                if (consideredParams.contains(param) || !QvtOperationalUtil.isModelParamEqual(param, importedParam, false)) continue;
                consideredParams.add(param);
                mapImportedModelParams.put(importedParam, param);
                continue block2;
            }
        }
        return mapImportedModelParams;
    }

    private void setModelParameterExtents(Map<ModelParameter, ModelParameterExtent> modelExtents, Map<ModelParameter, ModelParameter> mapImportedExtents) {
        this.myModelExtents = modelExtents;
        this.myMapImportedExtents = mapImportedExtents;
        for (Map.Entry<ModelParameter, ModelParameterExtent> entry : modelExtents.entrySet()) {
            if (entry.getKey() == UNBOUND_MODEL_EXTENT || entry.getKey().getName().length() <= 0) continue;
            this.add(entry.getKey().getName(), entry.getValue(), entry.getKey().getEType());
        }
    }

    public QvtEvaluationResult createEvaluationResult(ImperativeOperation entryPoint) {
        ArrayList<ModelExtentContents> extents = new ArrayList<ModelExtentContents>();
        for (Map.Entry<ModelParameter, ModelParameterExtent> entry : this.myModelExtents.entrySet()) {
            if (entry.getKey() == UNBOUND_MODEL_EXTENT || entry.getKey().getKind() == DirectionKind.IN) continue;
            extents.add(entry.getValue().getContents());
        }
        List<Object> outParamValues = this.makeOutParamValues(entryPoint);
        return new QvtEvaluationResult(extents, this.myModelExtents.get(UNBOUND_MODEL_EXTENT).getRootObjects(), outParamValues);
    }

    private List<Object> makeOutParamValues(ImperativeOperation entryPoint) {
        Object valueOf;
        MappingParameter mappingParam;
        ArrayList<Object> outParamValues = new ArrayList<Object>();
        for (EParameter param : entryPoint.getEParameters()) {
            mappingParam = (MappingParameter)param;
            if (mappingParam.getKind() == DirectionKind.IN || (valueOf = this.getValueOf(mappingParam.getName())) == null) continue;
            outParamValues.add(valueOf);
        }
        for (EParameter param : entryPoint.getResult()) {
            mappingParam = (MappingParameter)param;
            if (mappingParam.getKind() == DirectionKind.IN || (valueOf = this.getValueOf(mappingParam.getName())) == null) continue;
            outParamValues.add(valueOf);
        }
        return outParamValues;
    }

    public EObject createInstance(EClassifier type, ModelParameter extent) {
        if (!(type instanceof EClass)) {
            throw new IllegalArgumentException("Expected EClass, got " + type);
        }
        EClass impl = (EClass)type;
        if (!QvtOperationalUtil.isInstantiable(impl)) {
            throw new IllegalArgumentException("Cannot instantiate type " + impl.getName());
        }
        EObject newObject = impl.getEPackage().getEFactoryInstance().create(impl);
        if (this.myModelExtents.containsKey(extent)) {
            this.myModelExtents.get(extent).addObject(newObject);
        } else if (this.myMapImportedExtents.containsKey(extent)) {
            ModelParameter mappedExtent = this.myMapImportedExtents.get(extent);
            if (this.myModelExtents.containsKey(mappedExtent)) {
                this.myModelExtents.get(mappedExtent).addObject(newObject);
            } else {
                this.myModelExtents.get(UNBOUND_MODEL_EXTENT).addObject(newObject);
            }
        } else {
            this.myModelExtents.get(UNBOUND_MODEL_EXTENT).addObject(newObject);
        }
        return newObject;
    }

    public ModelParameterExtent getDefaultInstantiationExtent(EClassifier type) {
        ModelParameter modelParameter2;
        ArrayList<ModelParameter> params = new ArrayList<ModelParameter>(this.myModelExtents.keySet().size());
        for (ModelParameter modelParameter2 : this.myModelExtents.keySet()) {
            if (modelParameter2 == UNBOUND_MODEL_EXTENT) continue;
            params.add(modelParameter2);
        }
        modelParameter2 = QvtOperationalEnv.findModelParameter(type, DirectionKind.OUT, params);
        if (modelParameter2 != null) {
            return this.myModelExtents.get(modelParameter2);
        }
        return this.myModelExtents.get(UNBOUND_MODEL_EXTENT);
    }

    public void callSetter(EObject owner, EStructuralFeature eStructuralFeature, Object exprValue, boolean valueIsUndefined, boolean isReset) {
        if (this.getInvalidResult() == owner) {
            return;
        }
        if (eStructuralFeature instanceof ContextualProperty) {
            IntermediatePropertyModelAdapter.ShadowEntry shadow = IntermediatePropertyModelAdapter.getPropertyHolder((EObject)eStructuralFeature.getEContainingClass(), (ContextualProperty)eStructuralFeature, owner);
            owner = shadow.getPropertyRuntimeOwner(owner);
            eStructuralFeature = shadow.getProperty();
        }
        if (eStructuralFeature.getEType() instanceof CollectionType) {
            Collection currentValues = (Collection)owner.eGet(eStructuralFeature);
            if (currentValues == null) {
                CollectionType collectionType = (CollectionType)eStructuralFeature.getEType();
                currentValues = CollectionUtil.createNewCollection((CollectionKind)collectionType.getKind());
                owner.eSet(eStructuralFeature, (Object)currentValues);
            }
            if (isReset) {
                currentValues.clear();
            }
            if (exprValue instanceof Collection) {
                Collection newVal = (Collection)exprValue;
                for (Object nextElement : newVal) {
                    if (nextElement == this.getInvalidResult() || nextElement == null) continue;
                    currentValues.add(nextElement);
                }
            } else if (exprValue != this.getInvalidResult() && exprValue != null) {
                currentValues.add(exprValue);
            }
            return;
        }
        Class expectedType = eStructuralFeature.getEType().getInstanceClass();
        if (this.isMany(owner, eStructuralFeature)) {
            List featureValues = (List)owner.eGet(eStructuralFeature);
            if (isReset) {
                featureValues.clear();
            }
            if (exprValue instanceof Collection) {
                for (Object element : (Collection)exprValue) {
                    if (element == null) continue;
                    featureValues.add(this.ensureTypeCompatibility(element, expectedType));
                }
            } else if (!valueIsUndefined) {
                featureValues.add(this.ensureTypeCompatibility(exprValue, expectedType));
            }
        } else if (!valueIsUndefined || this.acceptsNullValue(expectedType)) {
            owner.eSet(eStructuralFeature, this.ensureTypeCompatibility(exprValue, expectedType));
        } else {
            owner.eUnset(eStructuralFeature);
        }
    }

    private boolean isMany(EObject ownerObj, EStructuralFeature eStructuralFeature) {
        if (eStructuralFeature.isMany()) {
            return true;
        }
        if (eStructuralFeature.getLowerBound() == 0 && eStructuralFeature.getUpperBound() == -2) {
            return ownerObj.eGet(eStructuralFeature) instanceof List;
        }
        return false;
    }

    private Object ensureTypeCompatibility(Object value, Class<?> expectedType) {
        if ((expectedType == Double.class || expectedType == Double.TYPE) && value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value == QvtOperationalUtil.getOclInvalid()) {
            return null;
        }
        return value;
    }

    private boolean acceptsNullValue(Class<?> type) {
        if (type == null) {
            return true;
        }
        return !type.isPrimitive();
    }

    public QvtOperationalEvaluationEnv cloneEvaluationEnv() {
        QvtOperationalEvaluationEnv env = new QvtOperationalEvaluationEnv(this.getContext(), (EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject>)this.getParent());
        env.myObjectExpOwnerStack.addAll(this.myObjectExpOwnerStack);
        env.myOperationArgs.addAll(this.myOperationArgs);
        env.myOperationSelf = this.myOperationSelf;
        env.myBindings.putAll(this.myBindings);
        return env;
    }

    public int setCurrentASTOffset(int currentASTOffset) {
        int prevValue = this.myCurrentASTOffset;
        this.myCurrentASTOffset = currentASTOffset;
        return prevValue;
    }

    public int getCurrentASTOffset() {
        return this.myCurrentASTOffset;
    }

    public void setOperation(EOperation myOperation) {
        this.myOperation = myOperation;
    }

    public EOperation getOperation() {
        return this.myOperation;
    }

    private static class TypedBinding {
        final Object value;
        final EClassifier type;

        private TypedBinding(Object value, EClassifier type) {
            this.value = value;
            this.type = type;
        }
    }
}

