/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.jna;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.eclipse.jetty.quic.quiche.QuicheBinding;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.quiche.jna.JnaQuicheConnection;
import org.eclipse.jetty.quic.quiche.jna.LibQuiche;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnaQuicheBinding
implements QuicheBinding {
    private static final Logger LOG = LoggerFactory.getLogger(JnaQuicheBinding.class);

    public boolean isUsable() {
        try {
            LibQuiche.INSTANCE.quiche_version();
            return true;
        }
        catch (Throwable x) {
            LOG.debug("JNA quiche binding is not usable", x);
            return false;
        }
    }

    public int priority() {
        return 200;
    }

    public byte[] fromPacket(ByteBuffer packet) {
        return JnaQuicheConnection.fromPacket(packet);
    }

    public QuicheConnection connect(QuicheConfig quicheConfig, InetSocketAddress peer, int connectionIdLength) throws IOException {
        return JnaQuicheConnection.connect(quicheConfig, peer, connectionIdLength);
    }

    public boolean negotiate(QuicheConnection.TokenMinter tokenMinter, ByteBuffer packetRead, ByteBuffer packetToSend) throws IOException {
        return JnaQuicheConnection.negotiate(tokenMinter, packetRead, packetToSend);
    }

    public QuicheConnection tryAccept(QuicheConfig quicheConfig, QuicheConnection.TokenValidator tokenValidator, ByteBuffer packetRead, SocketAddress peer) throws IOException {
        return JnaQuicheConnection.tryAccept(quicheConfig, tokenValidator, packetRead, peer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{p=" + this.priority() + " u=" + this.isUsable() + "}";
    }
}

