/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.decoration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.diagram.DiagramDiff;
import org.eclipse.emf.compare.diagram.Hide;
import org.eclipse.emf.compare.diagram.LabelChange;
import org.eclipse.emf.compare.diagram.Show;
import org.eclipse.emf.compare.diagram.ide.ui.decoration.provider.DiffDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDifferenceDecorator
implements IDecorator {
    protected NotificationListener notificationListener = new NotificationListener(){

        public void notifyChanged(Notification notification) {
            AbstractDifferenceDecorator.this.refresh();
        }
    };
    private IDecoratorTarget decoratorTarget;
    private List<IDecoration> decorationsTarget;

    protected AbstractDifferenceDecorator(IDecoratorTarget target) {
        this.decoratorTarget = target;
    }

    private boolean addDecorations(List<IDecoration> decorations) {
        if (this.decorationsTarget == null) {
            this.decorationsTarget = new ArrayList<IDecoration>(decorations.size());
        }
        return this.decorationsTarget.addAll(decorations);
    }

    public IDecoratorTarget getTarget() {
        return this.decoratorTarget;
    }

    protected void removeDecorations() {
        if (this.decorationsTarget != null) {
            for (IDecoration decoration : this.decorationsTarget) {
                this.decoratorTarget.removeDecoration(decoration);
            }
            this.decorationsTarget.clear();
        }
    }

    protected IGraphicalEditPart getTargetEditPart() {
        return (IGraphicalEditPart)this.decoratorTarget.getAdapter(IGraphicalEditPart.class);
    }

    public final void refresh() {
        this.removeDecorations();
        if (DiffDecoratorProvider.shouldDecorate(this.getTarget())) {
            IGraphicalEditPart gep = this.getTargetEditPart();
            View view = gep.getNotationView();
            DiagramDiff diff = DiffDecoratorProvider.getRelatedSelectedDifference(view);
            if (diff instanceof Hide) {
                this.addDecorations(this.getHidedDecorations());
            } else if (diff instanceof Show) {
                this.addDecorations(this.getShowedDecorations());
            } else if (diff instanceof LabelChange) {
                this.addDecorations(this.getLabelModifiedDecorations());
            } else if (diff.getKind() == DifferenceKind.MOVE) {
                this.addDecorations(this.getMovedDecorations());
            } else if (diff.getKind() == DifferenceKind.CHANGE) {
                this.addDecorations(this.getModifiedDecorations());
            } else if (diff.getKind() == DifferenceKind.ADD) {
                this.addDecorations(this.getAddedDecorations());
            } else if (diff.getKind() == DifferenceKind.DELETE) {
                this.addDecorations(this.getRemovedDecorations());
            }
        }
    }

    protected void highlightEdge(IFigure figure, Color color, int size) {
        if (figure instanceof PolylineConnection) {
            figure.setBackgroundColor(color);
            figure.setForegroundColor(color);
            ((PolylineConnection)figure).setLineWidth(size);
        }
    }

    protected void highlightNode(IFigure figure, Color color, int size) {
        figure.setBorder((Border)new LineBorder(color, size));
        figure.setOpaque(false);
    }

    protected abstract List<IDecoration> getModifiedDecorations();

    protected abstract List<IDecoration> getAddedDecorations();

    protected abstract List<IDecoration> getRemovedDecorations();

    protected abstract List<IDecoration> getMovedDecorations();

    protected abstract List<IDecoration> getHidedDecorations();

    protected abstract List<IDecoration> getShowedDecorations();

    protected abstract List<IDecoration> getLabelModifiedDecorations();
}

