/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.provider.spec;

import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.compare.provider.ForwardingItemProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.spec.Strings;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardingUMLDiffItemProvider
extends ForwardingItemProvider
implements IItemStyledLabelProvider {
    private static final int MAX_LENGTH = 50;

    public ForwardingUMLDiffItemProvider(ItemProviderAdapter delegate) {
        super(delegate);
    }

    public Collection<?> getChildren(Object object) {
        UMLDiff umlDiff = (UMLDiff)object;
        Object ret = umlDiff.getKind() == DifferenceKind.CHANGE ? umlDiff.getRefinedBy() : super.getChildren(object);
        return ret;
    }

    public boolean hasChildren(Object object) {
        return !this.getChildren(object).isEmpty();
    }

    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    private EObject findNonNullSide(Match match) {
        EObject side = match.getLeft() != null ? match.getLeft() : (match.getRight() != null ? match.getRight() : match.getOrigin());
        return side;
    }

    public Object getImage(Object object) {
        UMLDiff umlDiff = (UMLDiff)object;
        Object image = AdapterFactoryUtil.getImage((AdapterFactory)this.getRootAdapterFactory(), (Object)umlDiff.getDiscriminant());
        return image;
    }

    private String getValueText(UMLDiff umlDiff) {
        String value = AdapterFactoryUtil.getText((AdapterFactory)this.getRootAdapterFactory(), (Object)umlDiff.getDiscriminant());
        value = value == null ? "<null>" : Strings.elide((String)value, (int)50, (String)"...");
        return value;
    }

    private String getReferenceText(UMLDiff umlDiff) {
        String ret = "";
        switch (umlDiff.getKind()) {
            case ADD: 
            case DELETE: 
            case MOVE: {
                EObject discriminant = umlDiff.getDiscriminant();
                ret = discriminant.eContainingFeature().getName();
                break;
            }
            case CHANGE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + umlDiff.getKind());
            }
        }
        return ret;
    }

    public Object getForeground(Object object) {
        UMLDiff referenceChange = (UMLDiff)object;
        switch (referenceChange.getState()) {
            case MERGED: 
            case DISCARDED: {
                return URI.createURI((String)"color://rgb/156/156/156");
            }
        }
        return super.getForeground(object);
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        UMLDiff umlDiff = (UMLDiff)object;
        String valueText = this.getValueText(umlDiff);
        String referenceText = this.getReferenceText(umlDiff);
        ComposedStyledString ret = new ComposedStyledString(valueText);
        ret.append(" [" + referenceText, IStyledString.Style.DECORATIONS_STYLER);
        switch (umlDiff.getKind()) {
            case ADD: {
                ret.append(" add", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case DELETE: {
                ret.append(" delete", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case CHANGE: {
                ret.append(" change", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case MOVE: {
                ret.append(" move", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + umlDiff.getKind());
            }
        }
        ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
        return ret;
    }
}

