/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.internal.extensions.provider.spec;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.compare.provider.ForwardingItemProvider;
import org.eclipse.emf.compare.provider.spec.Strings;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardingDiagramDiffItemProvider
extends ForwardingItemProvider {
    private static final int CHAR_SIZE_LIMIT = 50;
    private static final String HAS_BEEN = " has been ";

    public ForwardingDiagramDiffItemProvider(ItemProviderAdapter delegate) {
        super(delegate);
    }

    public Collection<?> getChildren(Object object) {
        DiagramDiff diagramDiff = (DiagramDiff)object;
        Object ret = diagramDiff.getKind() == DifferenceKind.CHANGE ? diagramDiff.getRefinedBy() : super.getChildren(object);
        return ret;
    }

    public boolean hasChildren(Object object) {
        return !this.getChildren(object).isEmpty();
    }

    public String getText(Object object) {
        DiagramDiff diagramDiff = (DiagramDiff)object;
        String valueText = this.getValueText(diagramDiff);
        String remotely = this.getRemoteText(diagramDiff);
        String ret = "";
        switch (diagramDiff.getKind()) {
            case ADD: {
                ret = String.valueOf(valueText) + HAS_BEEN + remotely + "added";
                break;
            }
            case DELETE: {
                ret = String.valueOf(valueText) + HAS_BEEN + remotely + "deleted";
                break;
            }
            case CHANGE: {
                ret = String.valueOf(valueText) + HAS_BEEN + remotely + "changed";
                break;
            }
            case MOVE: {
                ret = String.valueOf(valueText) + HAS_BEEN + remotely + "moved";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + diagramDiff.getKind());
            }
        }
        return ret;
    }

    protected String getRemoteText(DiagramDiff diagramDiff) {
        String remotely = "";
        if (diagramDiff.getSource() == DifferenceSource.RIGHT) {
            remotely = "remotely ";
        }
        return remotely;
    }

    public Object getImage(Object object) {
        DiagramDiff diagramDiff = (DiagramDiff)object;
        Object image = null;
        if (diagramDiff.getView() instanceof View) {
            image = ForwardingDiagramDiffItemProvider.getImage(this.getRootAdapterFactory(), ((View)diagramDiff.getView()).getElement());
        } else {
            super.getImage(object);
        }
        return image;
    }

    private static Object getImage(AdapterFactory adapterFactory, Object object) {
        Object adapter;
        Preconditions.checkNotNull((Object)adapterFactory);
        if (object != null && (adapter = adapterFactory.adapt(object, IItemLabelProvider.class)) instanceof IItemLabelProvider) {
            return ((IItemLabelProvider)adapter).getImage(object);
        }
        return null;
    }

    protected String getValueText(DiagramDiff diagramDiff) {
        String value = "<null>";
        if (diagramDiff.getView() instanceof View) {
            value = String.valueOf(diagramDiff.getView().eClass().getName()) + " " + AdapterFactoryUtil.getText((AdapterFactory)this.getRootAdapterFactory(), (Object)((View)diagramDiff.getView()).getElement());
        }
        value = Strings.elide((String)value, (int)50, (String)"...");
        return value;
    }

    public Object getForeground(Object object) {
        DiagramDiff referenceChange = (DiagramDiff)object;
        switch (referenceChange.getState()) {
            case MERGED: 
            case DISCARDED: {
                return URI.createURI((String)"color://rgb/156/156/156");
            }
        }
        return super.getForeground(object);
    }
}

