/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.compare.provider.AttributeChangeItemProvider;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.spec.ReferenceChangeItemProviderSpec;
import org.eclipse.emf.compare.provider.spec.Strings;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeChangeItemProviderSpec
extends AttributeChangeItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    private static final int ELIDE_LENGTH = 50;
    private final OverlayImageProvider overlayProvider = new OverlayImageProvider(this.getResourceLocator());

    public AttributeChangeItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public Object getImage(Object object) {
        AttributeChange attributeChange = (AttributeChange)object;
        Object attributeChangeValueImage = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), attributeChange.getValue());
        if (attributeChangeValueImage == null) {
            attributeChangeValueImage = super.getImage(object);
        }
        Object diffImage = this.overlayProvider.getComposedImage((Diff)attributeChange, attributeChangeValueImage);
        Object ret = this.overlayImage(object, diffImage);
        return ret;
    }

    @Override
    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    protected String getAttributeText(AttributeChange attChange) {
        return attChange.getAttribute().getName();
    }

    protected String getValueText(AttributeChange attChange) {
        String value = EcoreUtil.convertToString((EDataType)attChange.getAttribute().getEAttributeType(), (Object)attChange.getValue());
        value = value == null ? "<null>" : Strings.elide(value, 50, "...");
        return value;
    }

    public Collection<?> getChildren(Object object) {
        Collection children = super.getChildren(object);
        ArrayList ret = Lists.newArrayList((Iterable)children);
        AttributeChange attributeChange = (AttributeChange)object;
        Conflict conflict = attributeChange.getConflict();
        return ret;
    }

    public Object getForeground(Object object) {
        AttributeChange attributeChange = (AttributeChange)object;
        switch (attributeChange.getState()) {
            case MERGED: 
            case DISCARDED: {
                return URI.createURI((String)"color://rgb/156/156/156");
            }
        }
        return super.getForeground(object);
    }

    @Override
    public IStyledString.IComposedStyledString getStyledText(Object object) {
        AttributeChange attChange = (AttributeChange)object;
        String valueText = this.getValueText(attChange);
        String attributeText = this.getAttributeText(attChange);
        ComposedStyledString ret = new ComposedStyledString(valueText);
        ret.append(" [" + attributeText, IStyledString.Style.DECORATIONS_STYLER);
        switch (attChange.getKind()) {
            case ADD: {
                ret.append(" add", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case DELETE: {
                ret.append(" delete", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case CHANGE: {
                ret.append(" " + ReferenceChangeItemProviderSpec.changeText((Diff)attChange, (EStructuralFeature)attChange.getAttribute()), IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case MOVE: {
                ret.append(" move", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + attChange.getKind());
            }
        }
        ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
        return ret;
    }

    @Override
    public String getDescription(Object object) {
        AttributeChange attChange = (AttributeChange)object;
        String valueText = this.getValueText(attChange);
        String attributeText = this.getAttributeText(attChange);
        String remotely = "";
        if (attChange.getSource() == DifferenceSource.RIGHT) {
            remotely = "remotely ";
        }
        String ret = "";
        switch (attChange.getKind()) {
            case ADD: {
                ret = String.valueOf(valueText) + " has been " + remotely + "added to " + attributeText;
                break;
            }
            case DELETE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "deleted from " + attributeText;
                break;
            }
            case CHANGE: {
                String changeText = ReferenceChangeItemProviderSpec.changeText((Diff)attChange, (EStructuralFeature)attChange.getAttribute());
                ret = String.valueOf(attributeText) + " " + valueText + " has been " + remotely + changeText;
                break;
            }
            case MOVE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "moved in '" + attributeText;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + attChange.getKind());
            }
        }
        return ret;
    }
}

