/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.AbstractEDiffNode;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;

public class MatchNode
extends AbstractEDiffNode {
    private static final Predicate<Diff> CONFLICTUAL_DIFF = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return input != null && input.getConflict() != null;
        }
    };

    public MatchNode(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Match getTarget() {
        return (Match)super.getTarget();
    }

    public int getKind() {
        int ret = super.getKind();
        EObject ancestor = this.getTarget().getOrigin();
        EObject left = this.getTarget().getLeft();
        EObject right = this.getTarget().getRight();
        Iterable differences = this.getTarget().getAllDifferences();
        if (this.getTarget().getComparison().isThreeWay()) {
            if (Iterables.any((Iterable)differences, (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}))) {
                ret |= 0xC;
            } else if (Iterables.any((Iterable)differences, (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}))) {
                ret |= 0x1C;
            } else {
                if (Iterables.any((Iterable)differences, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT))) {
                    ret |= 4;
                }
                if (Iterables.any((Iterable)differences, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT))) {
                    ret |= 8;
                }
            }
            if (ancestor == null) {
                if (left == null || right == null) {
                    ret |= 1;
                }
            } else if (left == null || right == null) {
                ret |= 2;
            } else if (!Iterables.isEmpty((Iterable)differences)) {
                ret |= 3;
            }
        } else if (left == null) {
            ret |= 2;
        } else if (right == null) {
            ret |= 1;
        } else if (!Iterables.isEmpty((Iterable)differences)) {
            ret |= 3;
        }
        return ret;
    }
}

