/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAttachmentChangeMergeViewerItem
extends MergeViewerItem.Container {
    public ResourceAttachmentChangeMergeViewerItem(Comparison comparison, Diff diff, Resource left, Resource right, Resource ancestor, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
        super(comparison, diff, left, right, ancestor, side, adapterFactory);
    }

    public ResourceAttachmentChangeMergeViewerItem(Comparison comparison, Diff diff, Match match, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
        super(comparison, diff, match, side, adapterFactory);
    }

    @Override
    public IMergeViewerItem[] getChildren(IDifferenceGroupProvider group, Collection<IDifferenceFilter> filters) {
        Object sideValue = this.getSideValue(this.getSide());
        Object bestSideValue = this.getBestSideValue();
        ArrayList ret = Lists.newArrayList();
        if (bestSideValue instanceof Resource) {
            List<Object> mergeViewerItems = Lists.newArrayList();
            if (sideValue instanceof Resource) {
                mergeViewerItems = this.createMergeViewerItemFrom((Collection<?>)((Resource)sideValue).getContents());
            }
            if (this.getSide() != IMergeViewer.MergeViewerSide.ANCESTOR) {
                EList differences = this.getComparison().getDifferences();
                Iterable racs = Iterables.filter((Iterable)differences, ResourceAttachmentChange.class);
                ArrayList resourceAttachmentChanges = Lists.newArrayList((Iterable)racs);
                Object left = this.getLeft();
                Object right = this.getRight();
                Object ancestor = this.getAncestor();
                for (ResourceAttachmentChange resourceAttachmentChange : racs) {
                    if (resourceAttachmentChange.getState() == DifferenceState.MERGED) {
                        resourceAttachmentChanges.remove(resourceAttachmentChange);
                        continue;
                    }
                    if (!this.isUnrelated(resourceAttachmentChange, left) || !this.isUnrelated(resourceAttachmentChange, right) || !this.isUnrelated(resourceAttachmentChange, ancestor)) continue;
                    resourceAttachmentChanges.remove(resourceAttachmentChange);
                }
                ret.addAll(this.createInsertionPoints(mergeViewerItems, this.filteredDiffs(resourceAttachmentChanges, filters, group)));
            } else {
                ret.addAll(mergeViewerItems);
            }
        }
        return ret.toArray(ResourceAttachmentChangeMergeViewerItem.getNoItemsArr());
    }

    private boolean isUnrelated(ResourceAttachmentChange change, Object resource) {
        return resource == null || resource instanceof Resource && !change.getResourceURI().equals(((Resource)resource).getURI().toString());
    }

    @Override
    protected IMergeViewerItem createMergeViewerItemFrom(EObject eObject) {
        ResourceAttachmentChange rac;
        Match match = this.getComparison().getMatch(eObject);
        if (match != null && (rac = (ResourceAttachmentChange)Iterables.getFirst((Iterable)Iterables.filter((Iterable)match.getDifferences(), ResourceAttachmentChange.class), null)) != null) {
            EObject left = match.getLeft();
            EObject right = match.getRight();
            EObject ancestor = match.getOrigin();
            if (MergeViewerUtil.getResource(this.getComparison(), IMergeViewer.MergeViewerSide.LEFT, (Diff)rac) == null) {
                left = null;
            }
            if (MergeViewerUtil.getResource(this.getComparison(), IMergeViewer.MergeViewerSide.RIGHT, (Diff)rac) == null) {
                right = null;
            }
            if (MergeViewerUtil.getResource(this.getComparison(), IMergeViewer.MergeViewerSide.ANCESTOR, (Diff)rac) == null) {
                ancestor = null;
            }
            return new MergeViewerItem.Container(this.getComparison(), (Diff)rac, left, right, ancestor, this.getSide(), this.getAdapterFactory());
        }
        return null;
    }

    private List<? extends IMergeViewerItem> createInsertionPoints(List<? extends IMergeViewerItem> values, List<ResourceAttachmentChange> racs) {
        ArrayList ret = Lists.newArrayList(values);
        for (ResourceAttachmentChange diff : Lists.reverse(racs)) {
            int insertionIndex;
            boolean b9;
            boolean rightToLeft = this.getSide() == IMergeViewer.MergeViewerSide.LEFT;
            Comparison comparison = this.getComparison();
            Object left = MergeViewerUtil.getValueFromResourceAttachmentChange(diff, comparison, IMergeViewer.MergeViewerSide.LEFT);
            Object right = MergeViewerUtil.getValueFromResourceAttachmentChange(diff, comparison, IMergeViewer.MergeViewerSide.RIGHT);
            DifferenceSource source = diff.getSource();
            DifferenceKind kind = diff.getKind();
            DifferenceState state = diff.getState();
            boolean b1 = source == DifferenceSource.LEFT && kind == DifferenceKind.DELETE && this.getSide() == IMergeViewer.MergeViewerSide.LEFT && DifferenceState.MERGED != state;
            boolean b2 = source == DifferenceSource.LEFT && kind == DifferenceKind.ADD && this.getSide() == IMergeViewer.MergeViewerSide.RIGHT && DifferenceState.MERGED != state;
            boolean b3 = source == DifferenceSource.RIGHT && kind == DifferenceKind.ADD && this.getSide() == IMergeViewer.MergeViewerSide.LEFT && DifferenceState.MERGED != state;
            boolean b4 = source == DifferenceSource.RIGHT && kind == DifferenceKind.DELETE && this.getSide() == IMergeViewer.MergeViewerSide.RIGHT && DifferenceState.MERGED != state;
            boolean b5 = DifferenceState.MERGED == state && source == DifferenceSource.LEFT && kind == DifferenceKind.ADD && right == null;
            boolean b6 = DifferenceState.MERGED == state && source == DifferenceSource.LEFT && kind == DifferenceKind.DELETE && left == null;
            boolean b7 = DifferenceState.MERGED == state && source == DifferenceSource.RIGHT && kind == DifferenceKind.ADD && left == null;
            boolean b8 = DifferenceState.MERGED == state && source == DifferenceSource.RIGHT && kind == DifferenceKind.DELETE && right == null;
            boolean bl = b9 = diff.getConflict() == null || diff.getConflict().getKind() != ConflictKind.PSEUDO || kind == DifferenceKind.DELETE;
            if (!b1 && !b2 && !b3 && !b4 && !b5 && !b6 && !b7 && !b8 || !b9) continue;
            Object ancestor = MergeViewerUtil.getValueFromResourceAttachmentChange(diff, comparison, IMergeViewer.MergeViewerSide.ANCESTOR);
            if (left != null && MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.LEFT, (Diff)diff) == null) {
                left = null;
            }
            if (right != null && MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.RIGHT, (Diff)diff) == null) {
                right = null;
            }
            if (ancestor != null && MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.ANCESTOR, (Diff)diff) == null) {
                ancestor = null;
            }
            if (b5 || b8) {
                left = null;
            }
            if (b6 || b7) {
                right = null;
            }
            MergeViewerItem.Container insertionPoint = new MergeViewerItem.Container(comparison, (Diff)diff, left, right, ancestor, this.getSide(), this.getAdapterFactory());
            if (left == null && right == null && ancestor != null) {
                Resource resource = MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.ANCESTOR, (Diff)diff);
                EList contents = resource.getContents();
                insertionIndex = contents.indexOf(ancestor);
            } else {
                insertionIndex = Math.min(this.findInsertionIndex((Diff)diff, rightToLeft), ret.size());
            }
            int realIndex = 0;
            int index = 0;
            while (index < insertionIndex && realIndex < ret.size()) {
                if (!((IMergeViewerItem)ret.get(realIndex)).isInsertionPoint()) {
                    ++index;
                }
                ++realIndex;
            }
            ret.add(realIndex, insertionPoint);
        }
        return ret;
    }

    private int findInsertionIndex(Diff diff, boolean rightToLeft) {
        Resource expectedResource;
        Resource initialResource;
        Match valueMatch = diff.getMatch();
        Comparison comparison = this.getComparison();
        EObject expectedValue = valueMatch.getLeft() != null ? valueMatch.getLeft() : valueMatch.getRight();
        if (rightToLeft) {
            initialResource = MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.RIGHT, diff);
            expectedResource = MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.LEFT, diff);
        } else {
            initialResource = MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.LEFT, diff);
            expectedResource = MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.RIGHT, diff);
        }
        if (expectedResource != null) {
            EList sourceList = initialResource.getContents();
            EList targetList = expectedResource.getContents();
            return DiffUtil.findInsertionIndex((Comparison)comparison, (List)sourceList, (List)targetList, (Object)expectedValue);
        }
        return 0;
    }
}

