/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.INavigatable;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.RedoAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.UndoAction;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonScopeInput;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.progress.JobProgressInfoComposite;
import org.eclipse.emf.compare.ide.ui.internal.progress.JobProgressMonitorWrapper;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.AbstractStructuredViewerWrapper;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareToolBar;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.DependencyData;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareDiffTreeRuler;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerLabelProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.Navigatable;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.WrappableTreeViewer;
import org.eclipse.emf.compare.ide.ui.internal.util.CompareHandlerService;
import org.eclipse.emf.compare.ide.ui.internal.util.ExceptionUtil;
import org.eclipse.emf.compare.ide.ui.internal.util.JFaceUtil;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ICompareEditingDomainChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IMergePreviewModeChange;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilterChange;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.PseudoConflictsFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProviderChange;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.StructureMergeViewerGrouper;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.rcp.ui.internal.util.SWTUtil;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.ActionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFCompareStructureMergeViewer
extends AbstractStructuredViewerWrapper<Composite, WrappableTreeViewer>
implements CommandStackListener {
    private static final Predicate<Diff> UNRESOLVED_AND_WITHOUT_PSEUDO_CONFLICT = Predicates.and((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
    static final String REQUIRED_DIFF_COLOR = "RequiredDiffColor";
    static final String REQUIRED_DIFF_BORDER_COLOR = "RequiredDiffBorderColor";
    static final String UNMERGEABLE_DIFF_COLOR = "UnmergeableDiffColor";
    static final String UNMERGEABLE_DIFF_BORDER_COLOR = "UnmergeableDiffBorderColor";
    private Color requiredDiffColor;
    private Color unmergeableDiffColor;
    private static final int TREE_RULER_WIDTH = 17;
    private static final Predicate<? super Object> IS_DIFF = new Predicate<Object>(){

        public boolean apply(Object object) {
            return EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(object) instanceof Diff;
        }
    };
    private ComposedAdapterFactory fAdapterFactory;
    private EMFCompareDiffTreeRuler treeRuler;
    private final ICompareInputChangeListener fCompareInputChangeListener;
    private ITreeViewerListener fWrappedTreeListener;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private CompareHandlerService fHandlerService;
    private boolean resourcesShouldBeUnload;
    private DependencyData dependencyData;
    private ISelectionChangedListener selectionChangeListener;
    private final Listener fEraseItemListener;
    private JobProgressInfoComposite progressInfoItem;
    private Job inputChangedTask;
    private CompareToolBar toolBar;
    private boolean pseudoConflictsFilterEnabled;
    private INavigatable navigatable;

    public EMFCompareStructureMergeViewer(Composite parent, EMFCompareConfiguration config) {
        super(parent, config);
        this.updateLayout(true, false);
        StructureMergeViewerFilter structureMergeViewerFilter = this.getCompareConfiguration().getStructureMergeViewerFilter();
        ((WrappableTreeViewer)this.getViewer()).addFilter((ViewerFilter)structureMergeViewerFilter);
        StructureMergeViewerGrouper structureMergeViewerGrouper = this.getCompareConfiguration().getStructureMergeViewerGrouper();
        structureMergeViewerGrouper.install((StructuredViewer)this.getViewer());
        this.fCompareInputChangeListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput input) {
                EMFCompareStructureMergeViewer.this.compareInputChanged(input);
            }
        };
        this.navigatable = new Navigatable((AdapterFactory)this.fAdapterFactory, (WrappableTreeViewer)this.getViewer());
        this.toolBar = new CompareToolBar(structureMergeViewerGrouper, structureMergeViewerFilter, this.getCompareConfiguration());
        ((WrappableTreeViewer)this.getViewer()).addSelectionChangedListener(this.toolBar);
        this.toolBar.initToolbar(CompareViewerPane.getToolBarManager((Composite)parent), (AbstractTreeViewer)this.getViewer(), this.navigatable);
        this.selectionChangeListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EMFCompareStructureMergeViewer.this.handleSelectionChangedEvent(event);
            }
        };
        this.addSelectionChangedListener(this.selectionChangeListener);
        this.fWrappedTreeListener = new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                EMFCompareStructureMergeViewer.this.treeRuler.redraw();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                EMFCompareStructureMergeViewer.this.treeRuler.redraw();
            }
        };
        ((WrappableTreeViewer)this.getViewer()).addTreeListener(this.fWrappedTreeListener);
        this.fEraseItemListener = new Listener(){

            public void handleEvent(Event event) {
                EMFCompareStructureMergeViewer.this.handleEraseItemEvent(event);
            }
        };
        ((WrappableTreeViewer)this.getViewer()).getControl().addListener(40, this.fEraseItemListener);
        this.fHandlerService = CompareHandlerService.createFor(this.getCompareConfiguration().getContainer(), ((Composite)this.getControl()).getShell());
        this.setContentProvider((IContentProvider)new EMFCompareStructureMergeViewerContentProvider(this.getCompareConfiguration().getAdapterFactory()));
        this.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new EMFCompareStructureMergeViewerLabelProvider(this.getCompareConfiguration().getAdapterFactory(), (Viewer)this)));
        this.undoAction = new UndoAction(this.getCompareConfiguration().getEditingDomain());
        this.redoAction = new RedoAction(this.getCompareConfiguration().getEditingDomain());
        this.editingDomainChange(null, this.getCompareConfiguration().getEditingDomain());
        this.inputChangedTask.setPriority(30);
        config.getEventBus().register((Object)this);
    }

    @Override
    protected void preHookCreateControlAndViewer() {
        this.fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)EMFCompareRCPPlugin.getDefault().getAdapterFactoryRegistry());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new TreeItemProviderAdapterFactorySpec());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.getCompareConfiguration().setAdapterFactory((AdapterFactory)this.fAdapterFactory);
        JFaceResources.getColorRegistry().put(REQUIRED_DIFF_COLOR, new RGB(215, 255, 200));
        JFaceResources.getColorRegistry().put(REQUIRED_DIFF_BORDER_COLOR, new RGB(195, 235, 180));
        JFaceResources.getColorRegistry().put(UNMERGEABLE_DIFF_COLOR, new RGB(255, 205, 180));
        JFaceResources.getColorRegistry().put(UNMERGEABLE_DIFF_BORDER_COLOR, new RGB(235, 185, 160));
        this.requiredDiffColor = JFaceResources.getColorRegistry().get(REQUIRED_DIFF_COLOR);
        this.unmergeableDiffColor = JFaceResources.getColorRegistry().get(UNMERGEABLE_DIFF_COLOR);
        this.inputChangedTask = new CompareInputChangedJob("Computing Model Differences");
    }

    @Override
    protected AbstractStructuredViewerWrapper.ControlAndViewer<Composite, WrappableTreeViewer> createControlAndViewer(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        control.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        control.setLayout((Layout)layout);
        this.progressInfoItem = new JobProgressInfoComposite(this.inputChangedTask, control, 65792, 0);
        this.progressInfoItem.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.progressInfoItem.setBackground(Display.getDefault().getSystemColor(25));
        WrappableTreeViewer treeViewer = new WrappableTreeViewer(control, 770){

            public boolean isExpandable(Object parent) {
                if (this.hasFilters()) {
                    return this.getFilteredChildren(parent).length > 0;
                }
                return super.isExpandable(parent);
            }
        };
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.setUseHashlookup(true);
        this.dependencyData = new DependencyData(this.getCompareConfiguration(), treeViewer);
        control.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)"Model differences");
        this.treeRuler = new EMFCompareDiffTreeRuler(control, 0, treeViewer, this.dependencyData);
        GridData rulerLayoutData = new GridData(4, 4, false, true);
        rulerLayoutData.exclude = true;
        rulerLayoutData.widthHint = 17;
        rulerLayoutData.minimumWidth = 17;
        this.treeRuler.setLayoutData(rulerLayoutData);
        return AbstractStructuredViewerWrapper.ControlAndViewer.create(control, treeViewer);
    }

    @Subscribe
    public void handleEditingDomainChange(ICompareEditingDomainChange event) {
        this.editingDomainChange(event.getOldValue(), event.getNewValue());
    }

    private void editingDomainChange(ICompareEditingDomain oldValue, ICompareEditingDomain newValue) {
        if (newValue != oldValue) {
            if (oldValue != null) {
                oldValue.getCommandStack().removeCommandStackListener((CommandStackListener)this);
            }
            if (newValue != null) {
                newValue.getCommandStack().addCommandStackListener((CommandStackListener)this);
            }
            this.undoAction.setEditingDomain(newValue);
            this.redoAction.setEditingDomain(newValue);
        }
    }

    private void refreshTitle() {
        Composite parent = ((Composite)this.getControl()).getParent();
        if (parent instanceof CompareViewerSwitchingPane) {
            int displayedDiff = JFaceUtil.filterVisibleElement((TreeViewer)this.getViewer(), IS_DIFF).size();
            Comparison comparison = this.getCompareConfiguration().getComparison();
            if (comparison != null) {
                EList differences = comparison.getDifferences();
                int computedDiff = this.pseudoConflictsFilterEnabled ? Iterables.size((Iterable)Iterables.filter((Iterable)differences, (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})))) : differences.size();
                int filteredDiff = differences.size() - displayedDiff;
                if (filteredDiff < 0) {
                    filteredDiff = 0;
                }
                int differencesToMerge = this.pseudoConflictsFilterEnabled ? Iterables.size((Iterable)Iterables.filter((Iterable)differences, UNRESOLVED_AND_WITHOUT_PSEUDO_CONFLICT)) : Iterables.size((Iterable)Iterables.filter((Iterable)differences, (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})));
                ((CompareViewerSwitchingPane)parent).setTitleArgument(String.valueOf(differencesToMerge) + " over " + computedDiff + " differences still to be merged \u2014 " + filteredDiff + " differences filtered from view");
            }
        }
    }

    static EObject getDataOfTreeNodeOfAdapter(Object object) {
        Notifier target;
        EObject data = null;
        if (object instanceof Adapter && (target = ((Adapter)object).getTarget()) instanceof TreeNode) {
            data = ((TreeNode)target).getData();
        }
        return data;
    }

    @Subscribe
    public void mergePreviewModeChange(IMergePreviewModeChange event) {
        this.dependencyData.updateDependencies(this.getSelection());
        this.internalRedraw();
    }

    @Subscribe
    public void handleDifferenceFilterChange(IDifferenceFilterChange event) {
        this.pseudoConflictsFilterEnabled = Iterables.any((Iterable)event.getSelectedDifferenceFilters(), (Predicate)Predicates.instanceOf(PseudoConflictsFilter.class));
        SWTUtil.safeRefresh((Viewer)this, (boolean)false);
    }

    @Subscribe
    public void handleDifferenceGroupProviderChange(IDifferenceGroupProviderChange event) {
        SWTUtil.safeRefresh((Viewer)this, (boolean)false);
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput instanceof ICompareInput) {
            ICompareInput old = (ICompareInput)oldInput;
            old.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.addCompareInputChangeListener(this.fCompareInputChangeListener);
            TreeItem item = new TreeItem(((WrappableTreeViewer)this.getViewer()).getTree(), 0);
            item.setText("Computing model differences...");
            this.compareInputChanged(ci);
        }
    }

    @Override
    protected void handleDispose(DisposeEvent event) {
        if (this.fHandlerService != null) {
            this.fHandlerService.dispose();
        }
        this.getCompareConfiguration().getEventBus().unregister((Object)this);
        ((WrappableTreeViewer)this.getViewer()).removeTreeListener(this.fWrappedTreeListener);
        Object input = this.getInput();
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        this.removeSelectionChangedListener(this.selectionChangeListener);
        ((WrappableTreeViewer)this.getViewer()).removeSelectionChangedListener(this.toolBar);
        ((WrappableTreeViewer)this.getViewer()).getTree().removeListener(40, this.fEraseItemListener);
        this.compareInputChanged(null);
        this.treeRuler.handleDispose();
        this.fAdapterFactory.dispose();
        this.toolBar.dispose();
        super.handleDispose(event);
    }

    public void commandStackChanged(EventObject event) {
        IDifferenceGroupProvider groupProvider;
        List treeNodes;
        TreeNode treeNode;
        Object first;
        Collection affectedObjects;
        this.undoAction.update();
        this.redoAction.update();
        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
        if (mostRecentCommand instanceof ICompareCopyCommand && !(affectedObjects = mostRecentCommand.getAffectedObjects()).isEmpty() && (first = Iterables.getFirst((Iterable)affectedObjects, null)) instanceof EObject && (treeNode = (TreeNode)Iterables.getFirst((Iterable)(treeNodes = (groupProvider = this.getCompareConfiguration().getStructureMergeViewerGrouper().getProvider()).getTreeNodes((EObject)first)), null)) != null) {
            final Adapter adaptedAffectedObject = this.fAdapterFactory.adapt((Notifier)treeNode, ICompareInput.class);
            SWTUtil.safeSyncExec((Runnable)new Runnable(){

                public void run() {
                    EMFCompareStructureMergeViewer.this.refresh();
                    EMFCompareStructureMergeViewer.this.setSelection((ISelection)new StructuredSelection(adaptedAffectedObject), true);
                }
            });
        }
    }

    void compareInputChanged(ICompareInput input) {
        if (input == null) {
            this.compareInputChanged((ICompareInput)null, (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        if (this.getCompareConfiguration() != null) {
            this.updateLayout(true, true);
            this.inputChangedTask.schedule();
        }
    }

    void compareInputChanged(CompareInputAdapter input, IProgressMonitor monitor) {
        this.compareInputChanged(null, (Comparison)input.getComparisonObject());
    }

    void compareInputChanged(ComparisonScopeInput input, IProgressMonitor monitor) {
        EMFCompare comparator = this.getCompareConfiguration().getEMFComparator();
        IComparisonScope comparisonScope = input.getComparisonScope();
        Comparison comparison = comparator.compare(comparisonScope, BasicMonitor.toMonitor((IProgressMonitor)monitor));
        this.reportErrors(comparison);
        this.compareInputChanged(input.getComparisonScope(), comparison);
    }

    void compareInputChanged(IComparisonScope scope, Comparison comparison) {
        if (!((Composite)this.getControl()).isDisposed()) {
            TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
            treeNode.setData((EObject)comparison);
            final Adapter input = this.fAdapterFactory.adapt((Notifier)treeNode, ICompareInput.class);
            IDifferenceGroupProvider groupProvider = this.getCompareConfiguration().getStructureMergeViewerGrouper().getProvider();
            treeNode.eAdapters().add((Object)groupProvider);
            SWTUtil.safeSyncExec((Runnable)new Runnable(){

                public void run() {
                    ((WrappableTreeViewer)EMFCompareStructureMergeViewer.this.getViewer()).setInput(input);
                }
            });
            this.getCompareConfiguration().setComparisonAndScope(comparison, scope);
            SWTUtil.safeAsyncExec((Runnable)new Runnable(){

                public void run() {
                    EMFCompareStructureMergeViewer.this.updateLayout(false, true);
                    EMFCompareStructureMergeViewer.this.refreshTitle();
                    EMFCompareStructureMergeViewer.this.navigatable.selectChange(3);
                }
            });
            SWTUtil.safeAsyncExec((Runnable)new Runnable(){

                public void run() {
                    EMFCompareStructureMergeViewer.this.fHandlerService.updatePaneActionHandlers(new Runnable(){

                        public void run() {
                            EMFCompareStructureMergeViewer.this.fHandlerService.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)EMFCompareStructureMergeViewer.this.undoAction);
                            EMFCompareStructureMergeViewer.this.fHandlerService.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)EMFCompareStructureMergeViewer.this.redoAction);
                        }
                    });
                }
            });
        }
    }

    void compareInputChanged(ICompareInput input, IProgressMonitor monitor) {
        if (input != null) {
            if (input instanceof CompareInputAdapter) {
                this.resourcesShouldBeUnload = false;
                this.compareInputChanged((CompareInputAdapter)input, monitor);
            } else if (input instanceof ComparisonScopeInput) {
                this.resourcesShouldBeUnload = false;
                this.compareInputChanged((ComparisonScopeInput)input, monitor);
            } else {
                this.resourcesShouldBeUnload = true;
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ITypedElement left = input.getLeft();
                ITypedElement right = input.getRight();
                ITypedElement origin = input.getAncestor();
                IComparisonScope scope = null;
                try {
                    scope = ComparisonScopeBuilder.create(this.getCompareConfiguration().getContainer(), left, right, origin, (IProgressMonitor)subMonitor.newChild(85));
                }
                catch (Exception e) {
                    ExceptionUtil.handleException(e, this.getCompareConfiguration(), true);
                    return;
                }
                Comparison compareResult = EMFCompare.builder().setMatchEngineFactoryRegistry(EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryRegistry()).setPostProcessorRegistry(EMFCompareRCPPlugin.getDefault().getPostProcessorRegistry()).build().compare(scope, BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor.newChild(15)));
                this.reportErrors(compareResult);
                ResourceSet leftResourceSet = (ResourceSet)scope.getLeft();
                ResourceSet rightResourceSet = (ResourceSet)scope.getRight();
                ResourceSet originResourceSet = (ResourceSet)scope.getOrigin();
                ICompareEditingDomain editingDomain = EMFCompareEditingDomain.create((Notifier)leftResourceSet, (Notifier)rightResourceSet, (Notifier)originResourceSet);
                this.getCompareConfiguration().setEditingDomain(editingDomain);
                this.compareInputChanged(scope, compareResult);
            }
        } else {
            this.compareInputChangedToNull();
        }
    }

    private void updateLayout(boolean displayProgress, boolean doLayout) {
        ((GridData)this.progressInfoItem.getLayoutData()).exclude = !displayProgress;
        this.progressInfoItem.setVisible(displayProgress);
        ((GridData)((WrappableTreeViewer)this.getViewer()).getControl().getLayoutData()).exclude = displayProgress;
        ((WrappableTreeViewer)this.getViewer()).getControl().setVisible(!displayProgress);
        ((GridData)this.treeRuler.getLayoutData()).exclude = displayProgress;
        this.treeRuler.setVisible(!displayProgress);
        if (doLayout) {
            ((Composite)this.getControl()).layout(true, true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void compareInputChangedToNull() {
        block7: {
            leftResourceSet = null;
            rightResourceSet = null;
            originResourceSet = null;
            if (this.getCompareConfiguration().getComparison() == null) break block7;
            comparison = this.getCompareConfiguration().getComparison();
            matchIt = comparison.getMatches().iterator();
            if (!comparison.isThreeWay()) ** GOTO lbl23
            while (matchIt.hasNext() && (leftResourceSet == null || rightResourceSet == null || originResourceSet == null)) {
                match = (Match)matchIt.next();
                if (leftResourceSet == null) {
                    leftResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getLeft());
                }
                if (rightResourceSet == null) {
                    rightResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getRight());
                }
                if (originResourceSet != null) continue;
                originResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getOrigin());
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                match = (Match)matchIt.next();
                if (leftResourceSet == null) {
                    leftResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getLeft());
                }
                if (rightResourceSet != null) continue;
                rightResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getRight());
lbl23:
                // 3 sources

                ** while (matchIt.hasNext() && (leftResourceSet == null || rightResourceSet == null))
            }
        }
        this.editingDomainChange(this.getCompareConfiguration().getEditingDomain(), null);
        if (this.resourcesShouldBeUnload) {
            EMFCompareStructureMergeViewer.unload(leftResourceSet);
            EMFCompareStructureMergeViewer.unload(rightResourceSet);
            EMFCompareStructureMergeViewer.unload(originResourceSet);
        }
        if (this.getCompareConfiguration() != null) {
            this.getCompareConfiguration().dispose();
        }
        ((WrappableTreeViewer)this.getViewer()).setInput(null);
    }

    private void handleEraseItemEvent(Event event) {
        TreeItem item = (TreeItem)event.item;
        EObject dataItem = EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(item.getData());
        if (dataItem != null) {
            Set<Diff> requires = this.dependencyData.getRequires();
            Set<Diff> unmergeables = this.dependencyData.getUnmergeables();
            GC g = event.gc;
            if (requires.contains(dataItem)) {
                this.paintItemBackground(g, item, this.requiredDiffColor);
            } else if (unmergeables.contains(dataItem)) {
                this.paintItemBackground(g, item, this.unmergeableDiffColor);
            }
        }
    }

    private void paintItemBackground(GC g, TreeItem item, Color color) {
        Rectangle itemBounds = item.getBounds();
        Tree tree = item.getParent();
        Rectangle areaBounds = tree.getClientArea();
        g.setClipping(areaBounds.x, itemBounds.y, areaBounds.width, itemBounds.height);
        g.setBackground(color);
        g.fillRectangle(areaBounds.x, itemBounds.y, areaBounds.width, itemBounds.height);
    }

    private void reportErrors(final Comparison comparison) {
        if (ComparisonUtil.containsErrors((Comparison)comparison)) {
            SWTUtil.safeAsyncExec((Runnable)new Runnable(){

                public void run() {
                    DiagnosticDialog.open((Shell)((Composite)EMFCompareStructureMergeViewer.this.getControl()).getShell(), (String)"Comparison report", (String)"Some issues were detected.", (Diagnostic)comparison.getDiagnostic());
                }
            });
        }
    }

    private static void unload(ResourceSet resourceSet) {
        if (resourceSet != null) {
            for (Resource resource : resourceSet.getResources()) {
                resource.unload();
            }
            resourceSet.getResources().clear();
        }
    }

    private static ResourceSet getResourceSet(EObject eObject) {
        Resource eResource;
        if (eObject != null && (eResource = eObject.eResource()) != null) {
            return eResource.getResourceSet();
        }
        return null;
    }

    protected void internalRefresh(Object element) {
        ((WrappableTreeViewer)this.getViewer()).refresh();
        this.dependencyData.updateTreeItemMappings();
        this.dependencyData.updateDependencies(this.getSelection());
        this.internalRedraw();
        this.refreshTitle();
    }

    private void handleSelectionChangedEvent(SelectionChangedEvent event) {
        this.dependencyData.updateDependencies(event.getSelection());
        this.internalRedraw();
    }

    private void internalRedraw() {
        ((WrappableTreeViewer)this.getViewer()).getTree().redraw();
        this.treeRuler.redraw();
    }

    private final class CompareInputChangedJob
    extends Job {
        private CompareInputChangedJob(String name) {
            super(name);
        }

        public IStatus run(IProgressMonitor monitor) {
            JobProgressMonitorWrapper wrapper = new JobProgressMonitorWrapper(monitor, EMFCompareStructureMergeViewer.this.progressInfoItem);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)wrapper, (String)"Computing Model Differences", (int)100);
            EMFCompareStructureMergeViewer.this.compareInputChanged((ICompareInput)EMFCompareStructureMergeViewer.this.getInput(), (IProgressMonitor)subMonitor.newChild(100));
            return Status.OK_STATUS;
        }
    }
}

