/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.utils.DelegatingURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageURIConverter
extends DelegatingURIConverter {
    private Set<IStorage> loadedRevisions = Sets.newSetFromMap(new ConcurrentHashMap());

    public StorageURIConverter(URIConverter delegate) {
        super(delegate);
    }

    public Set<IStorage> getLoadedRevisions() {
        return this.loadedRevisions;
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = this.normalize(uri);
        URIHandler handler = this.getURIHandler(normalizedURI);
        this.getLoadedRevisions().add(this.createStorage(normalizedURI, handler, (URIConverter)this));
        LinkedHashMap actualOptions = Maps.newLinkedHashMap();
        actualOptions.put("URI_CONVERTER", this);
        if (options != null) {
            actualOptions.putAll(options);
        }
        return handler.createInputStream(normalizedURI, (Map)actualOptions);
    }

    protected IStorage createStorage(URI uri, URIHandler handler, URIConverter converter) {
        return new URIStorage(uri, handler, converter);
    }

    private class URIStorage
    implements IStorage {
        private final URI uri;
        private final URIHandler handler;
        private URIConverter converter;

        public URIStorage(URI uri, URIHandler handler, URIConverter converter) {
            this.uri = uri;
            this.handler = handler;
            this.converter = converter;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public InputStream getContents() throws CoreException {
            Map<String, URIConverter> options = Collections.singletonMap("URI_CONVERTER", this.converter);
            try {
                return this.handler.createInputStream(this.uri, options);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.compare.ide", e.getMessage(), (Throwable)e));
            }
        }

        public IPath getFullPath() {
            String path = this.uri.isRelative() ? this.uri.toString() : (this.uri.isPlatformResource() ? this.uri.toPlatformString(true) : this.uri.toString());
            return new Path(path);
        }

        public String getName() {
            return URI.decode((String)this.uri.lastSegment());
        }

        public boolean isReadOnly() {
            Map<String, Set<String>> options = Collections.singletonMap("requestedAttributes", Collections.singleton("readOnly"));
            Map attributes = this.handler.getAttributes(this.uri, options);
            return Boolean.TRUE.equals(attributes.get("readOnly"));
        }
    }
}

