/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.match.eobject.EObjectIndex;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierEObjectMatcher
implements IEObjectMatcher {
    private Optional<IEObjectMatcher> delegate;
    private Function<EObject, String> idComputation = new DefaultIDFunction();
    private BasicDiagnostic diagnostic;

    public IdentifierEObjectMatcher() {
        this(null, new DefaultIDFunction());
    }

    public IdentifierEObjectMatcher(IEObjectMatcher delegateWhenNoID) {
        this(delegateWhenNoID, new DefaultIDFunction());
    }

    public IdentifierEObjectMatcher(Function<EObject, String> idComputation) {
        this(null, idComputation);
    }

    public IdentifierEObjectMatcher(IEObjectMatcher delegateWhenNoID, Function<EObject, String> idComputation) {
        this.delegate = Optional.fromNullable((Object)delegateWhenNoID);
        this.idComputation = idComputation;
    }

    @Override
    public void createMatches(Comparison comparison, Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects, Monitor monitor) {
        if (monitor.isCanceled()) {
            throw new ComparisonCanceledException();
        }
        ArrayList leftEObjectsNoID = Lists.newArrayList();
        ArrayList rightEObjectsNoID = Lists.newArrayList();
        ArrayList originEObjectsNoID = Lists.newArrayList();
        this.diagnostic = new BasicDiagnostic(0, "org.eclipse.emf.common", 0, CommonPlugin.INSTANCE.getString("_UI_OK_diagnostic_0"), null);
        Set<Match> matches = this.matchPerId(leftEObjects, rightEObjects, originEObjects, leftEObjectsNoID, rightEObjectsNoID, originEObjectsNoID);
        this.addDiagnostic(comparison);
        Iterables.addAll(comparison.getMatches(), matches);
        if (!(leftEObjectsNoID.isEmpty() && rightEObjectsNoID.isEmpty() && originEObjectsNoID.isEmpty())) {
            if (this.delegate.isPresent()) {
                this.doDelegation(comparison, leftEObjectsNoID, rightEObjectsNoID, originEObjectsNoID, monitor);
            } else {
                Match match;
                for (EObject eObject : leftEObjectsNoID) {
                    if (monitor.isCanceled()) {
                        throw new ComparisonCanceledException();
                    }
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setLeft(eObject);
                    matches.add(match);
                }
                for (EObject eObject : rightEObjectsNoID) {
                    if (monitor.isCanceled()) {
                        throw new ComparisonCanceledException();
                    }
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setRight(eObject);
                    matches.add(match);
                }
                for (EObject eObject : originEObjectsNoID) {
                    if (monitor.isCanceled()) {
                        throw new ComparisonCanceledException();
                    }
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setOrigin(eObject);
                    matches.add(match);
                }
            }
        }
    }

    protected void doDelegation(Comparison comparison, List<EObject> leftEObjectsNoID, List<EObject> rightEObjectsNoID, List<EObject> originEObjectsNoID, Monitor monitor) {
        ((IEObjectMatcher)this.delegate.get()).createMatches(comparison, leftEObjectsNoID.iterator(), rightEObjectsNoID.iterator(), originEObjectsNoID.iterator(), monitor);
    }

    protected Set<Match> matchPerId(Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects, List<EObject> leftEObjectsNoID, List<EObject> rightEObjectsNoID, List<EObject> originEObjectsNoID) {
        Match parent;
        EObject parentEObject;
        Match match;
        String identifier;
        LinkedHashSet matches = Sets.newLinkedHashSet();
        SwitchMap<String, Match> idProxyMap = new SwitchMap<String, Match>();
        HashMap leftEObjectsToMatch = Maps.newHashMap();
        HashMap rightEObjectsToMatch = Maps.newHashMap();
        HashMap originEObjectsToMatch = Maps.newHashMap();
        while (leftEObjects.hasNext()) {
            EObject left = leftEObjects.next();
            identifier = (String)this.idComputation.apply((Object)left);
            if (identifier != null) {
                match = CompareFactory.eINSTANCE.createMatch();
                match.setLeft(left);
                parentEObject = this.getParentEObject(left);
                parent = (Match)leftEObjectsToMatch.get(parentEObject);
                if (parent != null) {
                    ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                } else {
                    matches.add(match);
                }
                boolean isAlreadyContained = idProxyMap.put(left.eIsProxy(), identifier, match);
                if (isAlreadyContained) {
                    this.reportDuplicateID(EObjectIndex.Side.LEFT, left);
                }
                leftEObjectsToMatch.put(left, match);
                continue;
            }
            leftEObjectsNoID.add(left);
        }
        while (rightEObjects.hasNext()) {
            EObject right = rightEObjects.next();
            identifier = (String)this.idComputation.apply((Object)right);
            if (identifier != null) {
                match = (Match)idProxyMap.get(right.eIsProxy(), identifier);
                if (match != null) {
                    if (match.getRight() != null) {
                        this.reportDuplicateID(EObjectIndex.Side.RIGHT, right);
                    }
                    match.setRight(right);
                    rightEObjectsToMatch.put(right, match);
                    continue;
                }
                match = CompareFactory.eINSTANCE.createMatch();
                match.setRight(right);
                parentEObject = this.getParentEObject(right);
                parent = (Match)rightEObjectsToMatch.get(parentEObject);
                if (parent != null) {
                    ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                } else {
                    matches.add(match);
                }
                rightEObjectsToMatch.put(right, match);
                idProxyMap.put(right.eIsProxy(), identifier, match);
                continue;
            }
            rightEObjectsNoID.add(right);
        }
        while (originEObjects.hasNext()) {
            EObject origin = originEObjects.next();
            identifier = (String)this.idComputation.apply((Object)origin);
            if (identifier != null) {
                match = (Match)idProxyMap.get(origin.eIsProxy(), identifier);
                if (match != null) {
                    if (match.getOrigin() != null) {
                        this.reportDuplicateID(EObjectIndex.Side.ORIGIN, origin);
                    }
                    match.setOrigin(origin);
                    originEObjectsToMatch.put(origin, match);
                    continue;
                }
                match = CompareFactory.eINSTANCE.createMatch();
                match.setOrigin(origin);
                parentEObject = this.getParentEObject(origin);
                parent = (Match)originEObjectsToMatch.get(parentEObject);
                if (parent != null) {
                    ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                } else {
                    matches.add(match);
                }
                idProxyMap.put(origin.eIsProxy(), identifier, match);
                originEObjectsToMatch.put(origin, match);
                continue;
            }
            originEObjectsNoID.add(origin);
        }
        return matches;
    }

    protected EObject getParentEObject(EObject eObject) {
        return eObject.eContainer();
    }

    private void reportDuplicateID(EObjectIndex.Side side, EObject eObject) {
        String duplicateID = (String)this.idComputation.apply((Object)eObject);
        String sideName = side.name().toLowerCase();
        String uriString = this.getUriString(eObject);
        String message = uriString != null ? EMFCompareMessages.getString("IdentifierEObjectMatcher.duplicateIdWithResource", duplicateID, sideName, uriString) : EMFCompareMessages.getString("IdentifierEObjectMatcher.duplicateId", duplicateID, sideName);
        this.diagnostic.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.emf.compare", 0, message, null));
    }

    private String getUriString(EObject eObject) {
        String uriString = null;
        Resource resource = eObject.eResource();
        if (resource != null && resource.getURI() != null) {
            URI uri = resource.getURI();
            uriString = uri.isPlatform() ? uri.toPlatformString(true) : uri.toString();
        }
        return uriString;
    }

    private void addDiagnostic(Comparison comparison) {
        if (comparison.getDiagnostic() == null) {
            comparison.setDiagnostic((Diagnostic)this.diagnostic);
        } else {
            ((BasicDiagnostic)comparison.getDiagnostic()).merge((Diagnostic)this.diagnostic);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultIDFunction
    implements Function<EObject, String> {
        public String apply(EObject eObject) {
            String identifier;
            if (eObject == null) {
                identifier = null;
            } else if (eObject.eIsProxy()) {
                identifier = ((InternalEObject)eObject).eProxyURI().fragment();
            } else {
                Resource eObjectResource = eObject.eResource();
                String xmiID = eObjectResource instanceof XMIResource ? ((XMIResource)eObjectResource).getID(eObject) : null;
                identifier = xmiID != null ? xmiID : EcoreUtil.getID((EObject)eObject);
            }
            return identifier;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SwitchMap<K, V> {
        final Map<K, V> trueMap = Maps.newHashMap();
        final Map<K, V> falseMap = Maps.newHashMap();

        private SwitchMap() {
        }

        public boolean put(boolean switcher, K key, V value) {
            Map<K, V> selectedMap = this.getMap(switcher);
            boolean isContained = selectedMap.containsKey(key);
            selectedMap.put(key, value);
            return isContained;
        }

        public V get(boolean switcher, K key) {
            Map<K, V> selectedMap = this.getMap(switcher);
            return selectedMap.get(key);
        }

        private Map<K, V> getMap(boolean switcher) {
            if (switcher) {
                return this.falseMap;
            }
            return this.trueMap;
        }
    }
}

