/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl.AbstractStructuralFeatureAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainmentReferenceChangeAccessorImpl
extends AbstractStructuralFeatureAccessor {
    public ContainmentReferenceChangeAccessorImpl(AdapterFactory adapterFactory, Diff diff, IMergeViewer.MergeViewerSide side) {
        super(adapterFactory, diff, side);
    }

    @Override
    protected ImmutableList<Diff> computeDifferences() {
        EList allDifferences = this.getComparison().getDifferences();
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)allDifferences, (Predicate)EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE));
    }

    @Override
    public IMergeViewerItem getInitialItem() {
        Diff initialDiff = this.getInitialDiff();
        EObject diffValue = (EObject)MergeViewerUtil.getDiffValue(initialDiff);
        Match match = this.getComparison().getMatch(diffValue);
        if (match == null && DifferenceState.MERGED == initialDiff.getState() && IMergeViewer.MergeViewerSide.ANCESTOR != this.getSide()) {
            match = this.getMatchWithNullValues(initialDiff.getMatch());
        }
        if (match != null) {
            return new MergeViewerItem.Container(this.getComparison(), this.getInitialDiff(), match, this.getSide(), this.getRootAdapterFactory());
        }
        return null;
    }

    private Match getMatchWithNullValues(Match match) {
        for (Match subMatch : match.getSubmatches()) {
            if (subMatch.getLeft() != null || subMatch.getRight() != null) continue;
            return subMatch;
        }
        return null;
    }

    @Override
    public ImmutableList<? extends IMergeViewerItem> getItems() {
        ImmutableList.Builder ret = ImmutableList.builder();
        EList matches = this.getComparison().getMatches();
        for (Match match : matches) {
            ResourceAttachmentChange diff = (ResourceAttachmentChange)Iterables.getFirst((Iterable)Iterables.filter((Iterable)match.getDifferences(), ResourceAttachmentChange.class), null);
            MergeViewerItem.Container container = null;
            if (this.getSide() == IMergeViewer.MergeViewerSide.ANCESTOR && (this.getSide() != IMergeViewer.MergeViewerSide.ANCESTOR || match.getOrigin() == null)) continue;
            container = new MergeViewerItem.Container(this.getComparison(), (Diff)diff, match.getLeft(), match.getRight(), match.getOrigin(), this.getSide(), this.getRootAdapterFactory());
            ret.add((Object)container);
        }
        return ret.build();
    }

    @Override
    public String getType() {
        return "org.eclipse.emf.compare.rcp.ui.eTreeDiff";
    }
}

