/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.compare.INavigatable;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.WrappableTreeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Navigatable
implements INavigatable {
    private final WrappableTreeViewer viewer;
    private final EMFCompareStructureMergeViewerContentProvider contentProvider;

    public Navigatable(WrappableTreeViewer viewer, EMFCompareStructureMergeViewerContentProvider contentProvider) {
        this.viewer = viewer;
        this.contentProvider = contentProvider;
    }

    public boolean selectChange(final int flag) {
        this.contentProvider.runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_ASYNC, new Runnable(){

            public void run() {
                Navigatable.this.internalSelectChange(flag);
            }
        });
        return false;
    }

    private boolean internalSelectChange(int flag) {
        Object nextOrPrev = null;
        Item[] selection = this.viewer.getSelection((Control)this.viewer.getTree());
        Item firstSelectedItem = selection.length > 0 ? selection[0] : null;
        switch (flag) {
            case 1: {
                nextOrPrev = this.getNextDiff(firstSelectedItem);
                break;
            }
            case 2: {
                nextOrPrev = this.getPreviousDiff(firstSelectedItem);
                break;
            }
            case 3: {
                nextOrPrev = this.getNextDiff(null);
                break;
            }
            case 4: {
                nextOrPrev = this.getPreviousDiff(null);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (nextOrPrev != null) {
            this.fireOpen(nextOrPrev);
        }
        return nextOrPrev == null;
    }

    public void fireOpen(Object element) {
        StructuredSelection newSelection = new StructuredSelection(element);
        this.viewer.setSelection((ISelection)newSelection);
        this.viewer.fireOpen(new OpenEvent((Viewer)this.viewer, (ISelection)newSelection));
    }

    public WrappableTreeViewer getViewer() {
        return this.viewer;
    }

    public Object getInput() {
        return this.viewer.getInput();
    }

    public boolean openSelectedChange() {
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        this.viewer.fireOpen(new OpenEvent((Viewer)this.viewer, selection));
        return true;
    }

    public boolean hasChange(int changeFlag) {
        Item[] selection = this.viewer.getSelection((Control)this.viewer.getTree());
        Item firstSelectedItem = selection.length > 0 ? selection[0] : null;
        switch (changeFlag) {
            case 1: {
                return this.getNextDiff(firstSelectedItem) != null;
            }
            case 2: {
                return this.getPreviousDiff(firstSelectedItem) != null;
            }
            case 3: {
                return this.getNextDiff(null) != null;
            }
        }
        throw new IllegalStateException();
    }

    private Object getNextDiff(Item item) {
        Object startingItem = item != null ? item : this.getStartingItem();
        if (startingItem == null) {
            return null;
        }
        Item nextItem = this.getNextItem((Item)startingItem);
        Object result = null;
        while (nextItem != null && result == null) {
            EObject data = EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(nextItem.getData());
            if (data instanceof Diff) {
                result = nextItem.getData();
                continue;
            }
            nextItem = this.getNextItem(nextItem);
        }
        return result;
    }

    private TreeItem getStartingItem() {
        TreeItem[] roots = this.viewer.getTree().getItems();
        TreeItem startingItem = roots != null && roots.length > 0 ? roots[0] : null;
        return startingItem;
    }

    private Object getPreviousDiff(Item item) {
        Object startingItem = item != null ? item : this.getStartingItem();
        if (startingItem == null) {
            return null;
        }
        Item previousItem = this.getPreviousItem((Item)startingItem);
        Object result = null;
        while (previousItem != null && result == null) {
            EObject data = EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(previousItem.getData());
            if (data instanceof Diff) {
                result = previousItem.getData();
                continue;
            }
            previousItem = this.getPreviousItem(previousItem);
        }
        return result;
    }

    protected Item getNextItem(Item previousItem) {
        TreeItem sibling;
        TreeItem firstChild = this.getFirstChild(previousItem);
        TreeItem result = firstChild != null ? firstChild : ((sibling = this.getSibling(previousItem)) != null ? sibling : this.getAncestorSibling(previousItem));
        if (result instanceof TreeItem && result.getData() == null) {
            TreeItem parentItem = result.getParentItem();
            if (parentItem != null) {
                this.viewer.createChildren((Widget)parentItem);
            } else {
                this.viewer.createChildren((Widget)this.viewer.getTree());
            }
            return this.getNextItem(previousItem);
        }
        return result;
    }

    protected Item getPreviousItem(Item previousItem) {
        Object parent;
        TreeItem previousSibling = this.getPreviousSibling(previousItem);
        Object result = previousSibling != null ? this.getDeepestChild(previousSibling) : ((parent = this.getParent(previousItem)) instanceof TreeItem ? (TreeItem)parent : null);
        if (result instanceof TreeItem && result.getData() == null) {
            TreeItem parentItem = result.getParentItem();
            if (parentItem != null) {
                this.viewer.createChildren((Widget)parentItem);
            } else {
                this.viewer.createChildren((Widget)this.viewer.getTree());
            }
            return this.getPreviousItem(previousItem);
        }
        return result;
    }

    private TreeItem getPreviousSibling(Item item) {
        List<TreeItem> sibling;
        int indexOfCurrent;
        TreeItem previsousSibling = null;
        Object parent = this.getParent(item);
        if (parent != null && (indexOfCurrent = (sibling = this.getChildren(parent)).indexOf(item)) > 0) {
            previsousSibling = sibling.get(indexOfCurrent - 1);
        }
        return previsousSibling;
    }

    private TreeItem getDeepestChild(TreeItem input) {
        List<TreeItem> children = this.getChildren(input);
        TreeItem deepestChild = input;
        while (!children.isEmpty()) {
            deepestChild = children.get(children.size() - 1);
            children = this.getChildren(deepestChild);
        }
        return deepestChild;
    }

    private TreeItem getFirstChild(Item item) {
        List<TreeItem> children = this.getChildren(item);
        if (!children.isEmpty()) {
            return children.get(0);
        }
        return null;
    }

    private List<TreeItem> getChildren(Object item) {
        Object[] children = item instanceof TreeItem ? ((TreeItem)item).getItems() : (item instanceof Tree ? ((Tree)item).getItems() : new TreeItem[]{});
        return Lists.newArrayList((Object[])children);
    }

    private Object getParent(Item item) {
        Item parentItem = this.viewer.getParentItem(item);
        Object parent = parentItem != null ? parentItem : this.viewer.getTree();
        return parent;
    }

    private TreeItem getAncestorSibling(Item inputItem) {
        Object parent = this.getParent(inputItem);
        TreeItem ancestorSibling = null;
        while (parent instanceof TreeItem && ancestorSibling == null) {
            ancestorSibling = this.getSibling((Item)((TreeItem)parent));
            parent = this.getParent((Item)((TreeItem)parent));
        }
        return ancestorSibling;
    }

    private TreeItem getSibling(Item item) {
        List<TreeItem> children;
        int indexOfCurrent;
        Object parent = this.getParent(item);
        if (parent != null && (indexOfCurrent = (children = this.getChildren(parent)).indexOf(item)) != children.size() - 1) {
            return children.get(indexOfCurrent + 1);
        }
        return null;
    }
}

