/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.postprocessor;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatchResourcePredicates {
    private MatchResourcePredicates() {
    }

    public static Predicate<MatchResource> hasSameURI(URI uri, IStorageProviderAccessor.DiffSide side) {
        return new HasSameURI(uri, side);
    }

    public static Predicate<MatchResource> hasSameTrimmedURI(MatchResource mr, IStorageProviderAccessor.DiffSide side) {
        return new HasSameTrimmedURI(mr, side);
    }

    private static final class HasSameTrimmedURI
    extends HasSameURI {
        public HasSameTrimmedURI(MatchResource match, IStorageProviderAccessor.DiffSide side) {
            super(HasSameTrimmedURI.getTrimmedURI(match, side), side);
        }

        private static URI getTrimmedURI(MatchResource match, IStorageProviderAccessor.DiffSide aSide) {
            URI result;
            switch (aSide) {
                case ORIGIN: {
                    if (!HasSameTrimmedURI.hasURI(match.getOrigin())) {
                        throw new IllegalArgumentException();
                    }
                    result = match.getOrigin().getURI().trimFileExtension();
                    break;
                }
                case SOURCE: {
                    if (!HasSameTrimmedURI.hasURI(match.getLeft())) {
                        throw new IllegalArgumentException();
                    }
                    result = match.getLeft().getURI().trimFileExtension();
                    break;
                }
                case REMOTE: {
                    if (!HasSameTrimmedURI.hasURI(match.getRight())) {
                        throw new IllegalArgumentException();
                    }
                    result = match.getRight().getURI().trimFileExtension();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return result;
        }

        public boolean apply(MatchResource input) {
            boolean result;
            switch (this.side) {
                case ORIGIN: {
                    result = HasSameTrimmedURI.hasURI(input.getOrigin()) && this.uri.trimFileExtension().equals(input.getOrigin().getURI().trimFileExtension());
                    break;
                }
                case SOURCE: {
                    result = HasSameTrimmedURI.hasURI(input.getLeft()) && this.uri.trimFileExtension().equals(input.getLeft().getURI().trimFileExtension());
                    break;
                }
                case REMOTE: {
                    result = HasSameTrimmedURI.hasURI(input.getRight()) && this.uri.trimFileExtension().equals(input.getRight().getURI().trimFileExtension());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return result;
        }

        private static boolean hasURI(Resource r) {
            return r != null && r.getURI() != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HasSameURI
    implements Predicate<MatchResource> {
        protected final IStorageProviderAccessor.DiffSide side;
        protected final URI uri;

        public HasSameURI(URI uri, IStorageProviderAccessor.DiffSide side) {
            this.side = (IStorageProviderAccessor.DiffSide)Preconditions.checkNotNull((Object)side);
            this.uri = (URI)Preconditions.checkNotNull((Object)uri);
        }

        public boolean apply(MatchResource input) {
            boolean result;
            switch (this.side) {
                case ORIGIN: {
                    result = input.getOrigin() != null && this.uri.equals(input.getOrigin().getURI());
                    break;
                }
                case SOURCE: {
                    result = input.getLeft() != null && this.uri.equals(input.getLeft().getURI());
                    break;
                }
                case REMOTE: {
                    result = input.getRight() != null && this.uri.equals(input.getRight().getURI());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return result;
        }
    }
}

