/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.internal.extension.impl.ItemRegistry;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.factory.IAccessorFactory;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ui.ConfigurationUIRegistryEventListener;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ui.IConfigurationUIFactory;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.factory.impl.AccessorFactoryExtensionRegistryListener;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.factory.impl.AccessorFactoryRegistryImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.DifferenceFilterExtensionRegistryListener;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.DifferenceFilterManager;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.DifferenceFilterRegistryImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.extender.DifferenceGroupExtenderRegistryImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.extender.DifferenceGroupExtenderRegistryListener;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DifferenceGroupManager;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DifferenceGroupProviderExtensionRegistryListener;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DifferenceGroupRegistryImpl;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.extender.IDifferenceGroupExtender;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFCompareRCPUIPlugin
extends AbstractUIPlugin {
    public static final Logger LOGGER = Logger.getLogger((String)"org.eclipse.emf.compare");
    public static final String PLUGIN_ID = "org.eclipse.emf.compare.rcp.ui";
    public static final String GROUP_PROVIDER_PPID = "groups";
    public static final String FILTER_PROVIDER_PPID = "filters";
    public static final String ACCESSOR_FACTORY_PPID = "accessorFactory";
    public static final String DIFFERENCE_GROUP_EXTENDER_PPID = "differenceGroupExtender";
    private static final String MATCH_ENGINE_FACTORY_CONFIGURATION_UI_PPID = "matchEngineFactoryConfigurationUI";
    private static final String LOG_PATTERN = "%d{ISO8601} [%t] %-5p %c{3} %x - %m%n";
    private static EMFCompareRCPUIPlugin plugin;
    private static Map<String, Image> resourcesMapper;
    private AbstractRegistryEventListener groupProviderRegistryListener;
    private IItemRegistry<IDifferenceGroupProvider.Descriptor> groupItemRegistry;
    private IDifferenceGroupProvider.Descriptor.Registry groupProviderRegistry;
    private AbstractRegistryEventListener filterRegistryListener;
    private IDifferenceFilter.Registry filterRegistry;
    private DifferenceFilterManager filterManager;
    private AbstractRegistryEventListener accessorFactoryRegistryListener;
    private IAccessorFactory.Registry accessorFactoryRegistry;
    private AbstractRegistryEventListener differenceGroupExtenderRegistryListener;
    private IDifferenceGroupExtender.Registry differenceGroupExtenderRegistry;
    private Map<String, IConfigurationUIFactory> matchEngineConfiguratorRegistry;
    private ConfigurationUIRegistryEventListener matchEngineConfiguratorRegistryListener;
    private IEMFCompareConfiguration compareConfiguration;
    private IPropertyChangeListener propertyChangeListener;
    private InstanceScope instanceScope = new InstanceScope();

    static {
        resourcesMapper = new HashMap<String, Image>();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        this.groupItemRegistry = new ItemRegistry();
        DifferenceGroupManager groupManager = new DifferenceGroupManager(this.getEMFCompareUIPreferences(), this.groupItemRegistry);
        this.groupProviderRegistry = new DifferenceGroupRegistryImpl(groupManager, this.groupItemRegistry);
        this.groupProviderRegistryListener = new DifferenceGroupProviderExtensionRegistryListener(PLUGIN_ID, GROUP_PROVIDER_PPID, this.getLog(), this.groupItemRegistry);
        extensionRegistry.addListener((IRegistryEventListener)this.groupProviderRegistryListener, "org.eclipse.emf.compare.rcp.ui.groups");
        this.groupProviderRegistryListener.readRegistry(extensionRegistry);
        this.filterManager = new DifferenceFilterManager(this.getEMFCompareUIPreferences());
        this.filterRegistry = new DifferenceFilterRegistryImpl(this.filterManager);
        this.filterRegistryListener = new DifferenceFilterExtensionRegistryListener(PLUGIN_ID, FILTER_PROVIDER_PPID, this.getLog(), this.filterManager);
        extensionRegistry.addListener((IRegistryEventListener)this.filterRegistryListener, "org.eclipse.emf.compare.rcp.ui.filters");
        this.filterRegistryListener.readRegistry(extensionRegistry);
        this.accessorFactoryRegistry = new AccessorFactoryRegistryImpl();
        this.accessorFactoryRegistryListener = new AccessorFactoryExtensionRegistryListener(PLUGIN_ID, ACCESSOR_FACTORY_PPID, this.getLog(), this.accessorFactoryRegistry);
        extensionRegistry.addListener((IRegistryEventListener)this.accessorFactoryRegistryListener, "org.eclipse.emf.compare.rcp.ui.accessorFactory");
        this.accessorFactoryRegistryListener.readRegistry(extensionRegistry);
        this.differenceGroupExtenderRegistry = new DifferenceGroupExtenderRegistryImpl();
        this.differenceGroupExtenderRegistryListener = new DifferenceGroupExtenderRegistryListener(PLUGIN_ID, DIFFERENCE_GROUP_EXTENDER_PPID, this.getLog(), this.differenceGroupExtenderRegistry);
        extensionRegistry.addListener((IRegistryEventListener)this.differenceGroupExtenderRegistryListener, "org.eclipse.emf.compare.rcp.ui.differenceGroupExtender");
        this.differenceGroupExtenderRegistryListener.readRegistry(extensionRegistry);
        this.matchEngineConfiguratorRegistry = new ConcurrentHashMap<String, IConfigurationUIFactory>();
        this.matchEngineConfiguratorRegistryListener = new ConfigurationUIRegistryEventListener(PLUGIN_ID, MATCH_ENGINE_FACTORY_CONFIGURATION_UI_PPID, this.getLog(), this.matchEngineConfiguratorRegistry, EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryDescriptorRegistry());
        extensionRegistry.addListener((IRegistryEventListener)this.matchEngineConfiguratorRegistryListener, "org.eclipse.emf.compare.rcp.ui.matchEngineFactoryConfigurationUI");
        this.matchEngineConfiguratorRegistryListener.readRegistry(extensionRegistry);
        this.initLogging();
    }

    public void stop(BundleContext context) throws Exception {
        this.getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        extensionRegistry.removeListener((IRegistryEventListener)this.matchEngineConfiguratorRegistryListener);
        this.matchEngineConfiguratorRegistry = null;
        this.matchEngineConfiguratorRegistryListener = null;
        extensionRegistry.removeListener((IRegistryEventListener)this.differenceGroupExtenderRegistryListener);
        this.differenceGroupExtenderRegistryListener = null;
        this.differenceGroupExtenderRegistry = null;
        extensionRegistry.removeListener((IRegistryEventListener)this.accessorFactoryRegistryListener);
        this.accessorFactoryRegistryListener = null;
        this.accessorFactoryRegistry = null;
        extensionRegistry.removeListener((IRegistryEventListener)this.filterRegistryListener);
        this.filterRegistryListener = null;
        this.filterRegistry = null;
        this.filterManager = null;
        extensionRegistry.removeListener((IRegistryEventListener)this.groupProviderRegistryListener);
        this.groupProviderRegistryListener = null;
        this.groupItemRegistry = null;
        this.groupProviderRegistry = null;
        plugin = null;
        EMFCompareRCPUIPlugin.disposeCachedImages();
        super.stop(context);
    }

    public static EMFCompareRCPUIPlugin getDefault() {
        return plugin;
    }

    private void initLogging() {
        this.resetDefaultLoggingPreferences();
        LOGGER.setLevel(Level.toLevel((String)this.getPreferenceStore().getString("org.eclipse.emf.compare.log.level")));
        RollingFileAppender appender = (RollingFileAppender)LOGGER.getAppender("EMFCFile");
        String logFileName = this.getPreferenceStore().getString("org.eclipse.emf.compare.log.file.name");
        if (logFileName.length() > 0) {
            if (appender == null) {
                try {
                    this.createLogAppender(logFileName);
                }
                catch (IOException iOException) {
                    this.getPreferenceStore().setToDefault("org.eclipse.emf.compare.log.file.name");
                }
            } else {
                appender.setMaxBackupIndex(this.getPreferenceStore().getInt("org.eclipse.emf.compare.log.backup.count"));
                appender.setMaximumFileSize(this.getPreferenceStore().getLong("org.eclipse.emf.compare.log.file.max.size") * 1024L * 1024L);
            }
        }
        this.propertyChangeListener = new LoggingPropertyChangeListener();
        this.getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    private void resetDefaultLoggingPreferences() {
        this.getPreferenceStore().setDefault("org.eclipse.emf.compare.log.file.name", "");
        this.getPreferenceStore().setDefault("org.eclipse.emf.compare.log.level", "OFF");
        this.getPreferenceStore().setValue("org.eclipse.emf.compare.log.backup.count", 20);
        this.getPreferenceStore().setValue("org.eclipse.emf.compare.log.file.max.size", 10);
    }

    private void createLogAppender(String newFileName) throws IOException {
        RollingFileAppender appender = new RollingFileAppender((Layout)new PatternLayout(LOG_PATTERN), newFileName, true);
        LOGGER.removeAllAppenders();
        LOGGER.addAppender((Appender)appender);
        appender.setMaxBackupIndex(this.getPreferenceStore().getInt("org.eclipse.emf.compare.log.backup.count"));
        appender.setMaximumFileSize(EMFCompareRCPUIPlugin.getDefault().getPreferenceStore().getLong("org.eclipse.emf.compare.log.file.max.size") * 1024L * 1024L);
    }

    public void log(Throwable e) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), e));
    }

    public void log(int severity, String message) {
        this.getLog().log((IStatus)new Status(severity, PLUGIN_ID, message));
    }

    public IDifferenceGroupProvider.Descriptor.Registry getDifferenceGroupProviderRegistry() {
        return this.groupProviderRegistry;
    }

    public IItemRegistry<IDifferenceGroupProvider.Descriptor> getItemDifferenceGroupProviderRegistry() {
        return this.groupItemRegistry;
    }

    public IDifferenceFilter.Registry getDifferenceFilterRegistry() {
        return this.filterRegistry;
    }

    public DifferenceFilterManager getDifferenceFilterManager() {
        return this.filterManager;
    }

    public IAccessorFactory.Registry getAccessorFactoryRegistry() {
        return this.accessorFactoryRegistry;
    }

    public IDifferenceGroupExtender.Registry getDifferenceGroupExtenderRegistry() {
        return this.differenceGroupExtenderRegistry;
    }

    public static Image getImage(String imagePath) {
        Image image = resourcesMapper.get(imagePath);
        if (image == null) {
            ImageDescriptor imageDescriptor = EMFCompareRCPUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)imagePath);
            image = imageDescriptor.createImage();
            resourcesMapper.put(imagePath, image);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String imagePath) {
        return EMFCompareRCPUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)imagePath);
    }

    public static void disposeImage(String id) {
        Image image = resourcesMapper.remove(id);
        if (image != null) {
            image.dispose();
        }
    }

    public static void disposeCachedImages() {
        Iterator<Image> iterator = resourcesMapper.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        resourcesMapper.clear();
    }

    public Map<String, IConfigurationUIFactory> getMatchEngineConfiguratorRegistry() {
        return this.matchEngineConfiguratorRegistry;
    }

    public Preferences getEMFCompareUIPreferences() {
        return this.instanceScope.getNode(PLUGIN_ID);
    }

    public IEMFCompareConfiguration getEMFCompareConfiguration() {
        return this.compareConfiguration;
    }

    public void setEMFCompareConfiguration(IEMFCompareConfiguration compareConfiguration) {
        this.compareConfiguration = compareConfiguration;
    }

    private static class LoggingPropertyChangeListener
    implements IPropertyChangeListener {
        private LoggingPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            RollingFileAppender appender;
            if ("org.eclipse.emf.compare.log.file.name".equals(event.getProperty())) {
                String newFileName = (String)event.getNewValue();
                RollingFileAppender appender2 = (RollingFileAppender)LOGGER.getAppender("EMFCFile");
                if (newFileName != null && newFileName.length() > 0) {
                    if (appender2 == null) {
                        try {
                            EMFCompareRCPUIPlugin.getDefault().createLogAppender(newFileName);
                        }
                        catch (IOException e) {
                            EMFCompareRCPUIPlugin.getDefault().getPreferenceStore().setToDefault("org.eclipse.emf.compare.log.file.name");
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)EMFCompareRCPUIMessages.getString("LoggingPreferencePage.appender.error.title"), (String)EMFCompareRCPUIMessages.getString("LoggingPreferencePage.appender.error.msg", newFileName, e.getMessage()));
                        }
                    } else {
                        appender2.setFile(newFileName);
                    }
                } else {
                    LOGGER.removeAllAppenders();
                }
            } else if ("org.eclipse.emf.compare.log.level".equals(event.getProperty())) {
                LOGGER.setLevel(Level.toLevel((String)((String)event.getNewValue())));
            } else if ("org.eclipse.emf.compare.log.backup.count".equals(event.getProperty())) {
                RollingFileAppender appender3 = (RollingFileAppender)LOGGER.getAppender("EMFCFile");
                if (appender3 != null) {
                    appender3.setMaxBackupIndex(Integer.parseInt((String)event.getNewValue()));
                }
            } else if ("org.eclipse.emf.compare.log.file.max.size".equals(event.getProperty()) && (appender = (RollingFileAppender)LOGGER.getAppender("EMFCFile")) != null) {
                appender.setMaximumFileSize(Long.parseLong((String)event.getNewValue()) * 1024L * 1024L);
            }
        }
    }
}

