/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.eventbus.EventBus;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DefaultResolutionContext;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DependencyGraphUpdater;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResolutionContext;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.LocalModelResolution;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.LocalModelsResolution;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ModelResourceListener;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ModelsResolution;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceComputationScheduler;
import org.eclipse.emf.compare.ide.ui.logical.AbstractModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.internal.utils.Graph;
import org.eclipse.emf.compare.internal.utils.ReadOnlyGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedModelResolver
extends AbstractModelResolver {
    private IResolutionContext context;

    public ReadOnlyGraph<URI> getDependencyGraph() {
        return ReadOnlyGraph.toReadOnlyGraph(this.context.getGraph());
    }

    @Override
    public void initialize() {
        super.initialize();
        EventBus eventBus = new EventBus();
        Graph graph = new Graph();
        this.context = this.createContext(eventBus, (Graph<URI>)graph);
        this.context.initialize();
    }

    @Override
    public void dispose() {
        this.context.dispose();
        super.dispose();
    }

    protected DefaultResolutionContext createContext(EventBus eventBus, Graph<URI> graph) {
        return new DefaultResolutionContext(eventBus, graph, new DependencyGraphUpdater<URI>(graph, eventBus), new ResourceComputationScheduler<URI>(), new ModelResourceListener());
    }

    @Override
    public boolean canResolve(IStorage sourceStorage) {
        return true;
    }

    @Override
    public StorageTraversal resolveLocalModel(IResource start, IProgressMonitor monitor) throws InterruptedException {
        LocalModelResolution comp = new LocalModelResolution(this.context, monitor);
        return comp.run(start);
    }

    @Override
    public SynchronizationModel resolveLocalModels(IResource left, IResource right, IResource origin, IProgressMonitor monitor) throws InterruptedException {
        LocalModelsResolution comp = new LocalModelsResolution(this.context, left, right, origin, monitor);
        return comp.run();
    }

    @Override
    public SynchronizationModel resolveModels(IStorageProviderAccessor storageAccessor, IStorage left, IStorage right, IStorage origin, IProgressMonitor monitor) throws InterruptedException {
        ModelsResolution comp = new ModelsResolution(this.context, monitor, storageAccessor, left, right, origin);
        return comp.run();
    }
}

