/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.util.PlatformElementUtil;
import org.eclipse.emf.compare.ide.utils.IStoragePathProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.CachedResourceVariant;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.ui.IEditorInput;

public class StreamAccessorStorage
implements IStorage {
    private final IStreamContentAccessor accessor;
    private final String fullPath;

    public StreamAccessorStorage(IStreamContentAccessor accessor, String fullPath) {
        this.accessor = accessor;
        this.fullPath = fullPath;
    }

    public static StreamAccessorStorage fromTypedElement(ITypedElement element) throws IllegalArgumentException {
        return StreamAccessorStorage.fromTypedElement(null, element);
    }

    public static StreamAccessorStorage fromTypedElement(String storagePath, ITypedElement element) throws IllegalArgumentException {
        if (!(element instanceof IStreamContentAccessor)) {
            throw new IllegalArgumentException();
        }
        String fullPath = storagePath != null ? storagePath : StreamAccessorStorage.findPath(element);
        return new StreamAccessorStorage((IStreamContentAccessor)element, fullPath);
    }

    private static String findPath(ITypedElement element) {
        String fullPath;
        IFile file = PlatformElementUtil.findFile(element);
        if (file != null) {
            fullPath = file.getFullPath().toString();
        } else {
            IFileRevision revision = StreamAccessorStorage.findFileRevision(element);
            String tmp = null;
            if (revision != null) {
                java.net.URI uri = revision.getURI();
                if (uri != null) {
                    tmp = URI.decode((String)uri.toString());
                } else if (revision instanceof IAdaptable) {
                    tmp = StreamAccessorStorage.findPath((IAdaptable)revision);
                }
            }
            fullPath = tmp != null ? tmp : element.getName();
        }
        return fullPath;
    }

    private static String findPath(IAdaptable adaptable) {
        String result = null;
        IResourceVariant variant = (IResourceVariant)adaptable.getAdapter(IResourceVariant.class);
        if (variant != null) {
            try {
                IStorage storage = variant.getStorage((IProgressMonitor)new NullProgressMonitor());
                if (storage != null) {
                    Object adapter = Platform.getAdapterManager().loadAdapter((Object)storage, IStoragePathProvider.class.getName());
                    if (adapter instanceof IStoragePathProvider) {
                        IPath fixedPath = ((IStoragePathProvider)adapter).computeFixedPath(storage);
                        result = fixedPath.toString();
                    } else if (storage instanceof IFile) {
                        result = storage.getFullPath().toString();
                    }
                } else if (variant instanceof CachedResourceVariant) {
                    result = ((CachedResourceVariant)variant).getDisplayPath().toString();
                }
            }
            catch (TeamException teamException) {}
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        StreamAccessorStorage adapted = null;
        if (adapter.isInstance(this)) {
            adapted = this;
        } else if (adapter == IStreamContentAccessor.class) {
            adapted = this.accessor;
        } else if (this.accessor instanceof ITypedElement) {
            if (adapter == ITypedElement.class) {
                adapted = this.accessor;
            } else if (adapter.isAssignableFrom(IFile.class)) {
                adapted = PlatformElementUtil.findFile((ITypedElement)this.accessor);
            }
        }
        return adapted;
    }

    public InputStream getContents() throws CoreException {
        return this.accessor.getContents();
    }

    public IPath getFullPath() {
        return new Path(this.fullPath);
    }

    public String getName() {
        if (this.accessor instanceof ITypedElement) {
            return ((ITypedElement)this.accessor).getName();
        }
        return this.getFullPath().lastSegment();
    }

    public boolean isReadOnly() {
        File file;
        if (this.accessor instanceof ITypedElement && (file = PlatformElementUtil.findFile((ITypedElement)this.accessor)) != null) {
            return file.isReadOnly();
        }
        file = this.getFullPath().toFile();
        return !file.exists() || !file.canWrite();
    }

    private static IFileRevision findFileRevision(ITypedElement element) {
        IEditorInput editorInput;
        ISharedDocumentAdapter documentAdapter;
        if (element == null) {
            return null;
        }
        IFileRevision revision = PlatformElementUtil.adaptAs(element, IFileRevision.class);
        if (revision == null && (documentAdapter = PlatformElementUtil.adaptAs(element, ISharedDocumentAdapter.class)) != null && (editorInput = documentAdapter.getDocumentKey((Object)element)) != null) {
            revision = PlatformElementUtil.adaptAs(editorInput, IFileRevision.class);
        }
        if (revision == null) {
            try {
                Method method = element.getClass().getMethod("getFileRevision", new Class[0]);
                Object value = method.invoke((Object)element, new Object[0]);
                if (value instanceof IFileRevision) {
                    revision = (IFileRevision)value;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return revision;
    }
}

