/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.rcp.ui.internal.accessor;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl.ManyStructuralFeatureAccessorImpl;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLStereotypeManyStructuralFeatureChangeAccessor
extends ManyStructuralFeatureAccessorImpl {
    public UMLStereotypeManyStructuralFeatureChangeAccessor(AdapterFactory adapterFactory, UMLDiff diff, IMergeViewer.MergeViewerSide side) {
        super(adapterFactory, (Diff)diff, side);
    }

    protected ImmutableList<Diff> computeDifferences() {
        Match match = this.getInitialDiff().getMatch();
        EList siblingDifferences = match.getDifferences();
        EStructuralFeature affectedFeature = this.getAffectedFeature(this.getInitialDiff());
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)siblingDifferences, UMLStereotypeManyStructuralFeatureChangeAccessor.onFeature(this.getStructuralFeature().getName(), affectedFeature)));
    }

    private static Predicate<? super Diff> onFeature(final String featureName, final EStructuralFeature affectedFeature) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                return featureName.equals(affectedFeature.getName());
            }
        };
    }

    protected EStructuralFeature getAffectedFeature(Diff diff) {
        return (EStructuralFeature)((UMLDiff)diff).getDiscriminant();
    }

    public EObject getEObject(IMergeViewer.MergeViewerSide side) {
        EObject eObject;
        Diff refined = (Diff)this.getInitialDiff().getRefinedBy().get(0);
        switch (side) {
            case ANCESTOR: {
                eObject = refined.getMatch().getOrigin();
                break;
            }
            case LEFT: {
                eObject = refined.getMatch().getLeft();
                break;
            }
            case RIGHT: {
                eObject = refined.getMatch().getRight();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return eObject;
    }

    protected Object getValueFromDiff(Diff diff, IMergeViewer.MergeViewerSide side) {
        Diff refined = (Diff)diff.getRefinedBy().get(0);
        return super.getValueFromDiff(refined, side);
    }

    protected int findInsertionIndex(Diff diff, boolean rightToLeft) {
        Diff refined = (Diff)diff.getRefinedBy().get(0);
        return super.findInsertionIndex(refined, rightToLeft);
    }
}

