/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.internal.utils.ForwardingXMLDefaultHandler;
import org.eclipse.emf.compare.ide.internal.utils.ForwardingXMLHelper;
import org.eclipse.emf.compare.ide.internal.utils.INamespaceDeclarationListener;
import org.eclipse.emf.compare.ide.internal.utils.IProxyCreationListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLDefaultHandler;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyingParserPool
extends XMLParserPoolImpl {
    protected final boolean containmentOnly;
    private ListenerList proxyListeners = new ListenerList();
    private ListenerList namespaceDeclarationListeners = new ListenerList();

    public NotifyingParserPool(boolean containmentOnly) {
        super(false);
        this.containmentOnly = containmentOnly;
    }

    public synchronized XMLDefaultHandler getDefaultHandler(XMLResource resource, XMLLoad xmlLoad, XMLHelper helper, Map<?, ?> options) {
        NotifyingXMLHelper wrapper = new NotifyingXMLHelper(helper, this.containmentOnly);
        Object[] objectArray = this.proxyListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            wrapper.addProxyListener((IProxyCreationListener)listener);
            ++n2;
        }
        XMLDefaultHandler handler = this.createDefaultHandler(resource, xmlLoad, wrapper, options);
        NamespaceDeclarationNotifyingXMLDefaultHandler handlerWrapper = new NamespaceDeclarationNotifyingXMLDefaultHandler(handler);
        Object[] objectArray2 = this.namespaceDeclarationListeners.getListeners();
        int n3 = objectArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            Object listener = objectArray2[n4];
            handlerWrapper.addNamespaceDeclarationListener((INamespaceDeclarationListener)listener);
            ++n4;
        }
        HashMap<Object, Object> tmpMap = new HashMap<Object, Object>();
        tmpMap.putAll(options);
        ExtendedMetaData extendedMetaData = helper.getExtendedMetaData();
        if (extendedMetaData != null && !options.containsKey("EXTENDED_META_DATA")) {
            tmpMap.put("EXTENDED_META_DATA", extendedMetaData);
        }
        handlerWrapper.prepare(resource, wrapper, tmpMap);
        return handlerWrapper;
    }

    protected XMLDefaultHandler createDefaultHandler(XMLResource resource, XMLLoad xmlLoad, XMLHelper helper, Map<?, ?> options) {
        return super.getDefaultHandler(resource, xmlLoad, helper, options);
    }

    public void addProxyListener(IProxyCreationListener listener) {
        this.proxyListeners.add((Object)listener);
    }

    public void removeProxyListener(IProxyCreationListener listener) {
        this.proxyListeners.remove((Object)listener);
    }

    public void addNamespaceDeclarationListener(INamespaceDeclarationListener listener) {
        this.namespaceDeclarationListeners.add((Object)listener);
    }

    public void removeNamespaceDeclarationListener(INamespaceDeclarationListener listener) {
        this.namespaceDeclarationListeners.remove((Object)listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamespaceDeclarationNotifyingXMLDefaultHandler
    extends ForwardingXMLDefaultHandler {
        private ListenerList namespaceDeclarationListeners = new ListenerList();
        private boolean isRoot;
        private XMLHelper delegateHelper;

        public NamespaceDeclarationNotifyingXMLDefaultHandler(XMLDefaultHandler delegate) {
            super(delegate);
        }

        @Override
        public void startDocument() throws SAXException {
            this.isRoot = true;
            super.startDocument();
        }

        @Override
        public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
            if (this.isRoot) {
                String xsiSchemaLocation = arg3.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
                if (xsiSchemaLocation != null) {
                    this.declareSchemaLocation(xsiSchemaLocation);
                }
                this.isRoot = false;
            }
            super.startElement(arg0, arg1, arg2, arg3);
        }

        @Override
        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            if (this.delegateHelper instanceof NotifyingXMLHelper) {
                ((NotifyingXMLHelper)this.delegateHelper).checkProxies();
            }
            super.endElement(arg0, arg1, arg2);
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.delegateHelper instanceof NotifyingXMLHelper) {
                ((NotifyingXMLHelper)this.delegateHelper).checkProxies();
            }
            super.endDocument();
        }

        @Override
        public void prepare(XMLResource resource, XMLHelper helper, Map<?, ?> options) {
            super.prepare(resource, helper, options);
            this.delegateHelper = helper;
        }

        public void addNamespaceDeclarationListener(INamespaceDeclarationListener listener) {
            this.namespaceDeclarationListeners.add((Object)listener);
        }

        private void declareSchemaLocation(String xsiSchemaLocation) {
            StringTokenizer stringTokenizer = new StringTokenizer(xsiSchemaLocation, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String key = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) continue;
                String value = stringTokenizer.nextToken();
                URI uri = URI.createURI((String)value);
                Object[] objectArray = this.namespaceDeclarationListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((INamespaceDeclarationListener)listener).schemaLocationDeclared(key, uri);
                    ++n2;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotifyingXMLHelper
    extends ForwardingXMLHelper {
        private final ListenerList proxyListeners;
        private final boolean containmentOnly;
        private Set<ProxyEntry> potentialProxies = new LinkedHashSet<ProxyEntry>();

        public NotifyingXMLHelper(XMLHelper delegate, boolean containmentOnly) {
            super(delegate);
            this.proxyListeners = new ListenerList();
            this.containmentOnly = containmentOnly;
        }

        @Override
        public void setValue(EObject eObject, EStructuralFeature eStructuralFeature, Object value, int position) {
            boolean isContainment;
            boolean bl = isContainment = eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment();
            if (!this.containmentOnly || isContainment) {
                super.setValue(eObject, eStructuralFeature, value, position);
            }
            if (value instanceof EObject) {
                ProxyEntry entry = new ProxyEntry(eObject, eStructuralFeature, (EObject)value, position);
                if (((EObject)value).eIsProxy()) {
                    this.notifyProxy(entry);
                } else if (!isContainment) {
                    this.potentialProxies.add(entry);
                }
            }
        }

        @Override
        public List<XMIException> setManyReference(XMLHelper.ManyReference reference, String location) {
            boolean isContainment;
            EStructuralFeature eStructuralFeature = reference.getFeature();
            boolean bl = isContainment = eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment();
            if (!this.containmentOnly || isContainment) {
                return super.setManyReference(reference, location);
            }
            return Collections.emptyList();
        }

        public void checkProxies() {
            Iterator<ProxyEntry> candidateIterator = this.potentialProxies.iterator();
            while (candidateIterator.hasNext()) {
                ProxyEntry candidate = candidateIterator.next();
                if (candidate.getValue().eIsProxy()) {
                    this.notifyProxy(candidate);
                }
                candidateIterator.remove();
            }
        }

        private void notifyProxy(ProxyEntry proxy) {
            Object[] objectArray = this.proxyListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IProxyCreationListener)listener).proxyCreated((Resource)this.getResource(), proxy.getEObject(), proxy.getFeature(), proxy.getValue(), proxy.getPosition());
                ++n2;
            }
        }

        public void addProxyListener(IProxyCreationListener listener) {
            this.proxyListeners.add((Object)listener);
        }
    }

    private static class ProxyEntry {
        private EObject eObject;
        private EStructuralFeature feature;
        private EObject value;
        private int position;

        public ProxyEntry(EObject eObject, EStructuralFeature feature, EObject value, int position) {
            this.eObject = eObject;
            this.feature = feature;
            this.value = value;
            this.position = position;
        }

        public EObject getEObject() {
            return this.eObject;
        }

        public EStructuralFeature getFeature() {
            return this.feature;
        }

        public EObject getValue() {
            return this.value;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

