/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProvider;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RevisionedURIConverter
extends StorageURIConverter {
    private final IStorageProviderAccessor storageAccessor;
    private final IStorageProviderAccessor.DiffSide side;
    private final ConcurrentMap<URI, InputStream> prefetchedStreams = new ConcurrentHashMap<URI, InputStream>();

    public RevisionedURIConverter(URIConverter delegate, IStorageProviderAccessor storageAccessor, IStorageProviderAccessor.DiffSide side) {
        super(delegate);
        this.storageAccessor = storageAccessor;
        this.side = side;
    }

    public boolean prefetchStream(URI uri, Map<?, ?> options) throws IOException {
        InputStream stream = this.createInputStream(uri, options);
        if (stream != null) {
            this.prefetchedStreams.put(uri, stream);
        }
        return stream != null;
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        IResource targetFile;
        InputStream stream = (InputStream)this.prefetchedStreams.remove(uri);
        if (stream != null) {
            return stream;
        }
        URI normalizedUri = this.normalize(uri);
        stream = normalizedUri.isPlatformPlugin() || normalizedUri.toString().matches("(\\.\\./)+?plugins/.*") ? super.createInputStream(uri, options) : ((targetFile = ResourceUtil.getResourceFromURI((URI)normalizedUri)) != null ? this.openRevisionStream(targetFile) : super.createInputStream(uri, options));
        return stream;
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        boolean exists = false;
        try {
            URI normalizedUri = this.normalize(uri);
            IStorageProvider storageProvider = this.storageAccessor.getStorageProvider(ResourceUtil.getResourceFromURI((URI)normalizedUri), this.side);
            exists = storageProvider != null ? storageProvider.getStorage((IProgressMonitor)new NullProgressMonitor()) != null : super.exists(normalizedUri, options);
        }
        catch (CoreException e) {
            EMFCompareIDEUIPlugin.getDefault().log(4, e.getMessage());
        }
        return exists;
    }

    private InputStream openRevisionStream(IResource targetFile) {
        if (this.storageAccessor != null) {
            try {
                IStorage storage;
                IStorageProvider provider = this.storageAccessor.getStorageProvider(targetFile, this.side);
                if (provider != null && (storage = provider.getStorage((IProgressMonitor)new NullProgressMonitor())) != null && (!(storage instanceof IResource) || ((IResource)storage).exists())) {
                    this.getLoadedRevisions().add(storage);
                    return storage.getContents();
                }
            }
            catch (CoreException e) {
                RevisionedURIConverter.logError((Exception)((Object)e));
            }
        }
        return null;
    }

    private static void logError(Exception e) {
        Status status = new Status(4, "org.eclipse.emf.compare.ide.ui", e.getMessage(), (Throwable)e);
        EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)status);
    }
}

