/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.AbstractResolution;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IComputation;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResolutionContext;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyLocalResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyRemoteResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceComputationScheduler;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.RevisionedURIConverter;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.SynchronizedResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.util.PlatformElementUtil;
import org.eclipse.emf.compare.ide.ui.internal.util.ThreadSafeProgressMonitor;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.ecore.resource.URIConverter;

public class ModelsResolution
extends AbstractResolution {
    private final IStorageProviderAccessor storageAccessor;
    private final IStorage left;
    private final IStorage right;
    private final IStorage origin;
    private final IResourceDependencyLocalResolver localResolver;
    private final IResourceDependencyRemoteResolver remoteResolver;

    public ModelsResolution(IResolutionContext context, IProgressMonitor monitor, IStorageProviderAccessor storageAccessor, IStorage left, IStorage right, IStorage origin) {
        super(context, monitor);
        this.localResolver = context.getLocalResolver();
        this.remoteResolver = context.getRemoteResolver();
        this.storageAccessor = (IStorageProviderAccessor)Preconditions.checkNotNull((Object)storageAccessor);
        this.left = left;
        this.right = right;
        this.origin = origin;
        Preconditions.checkArgument((left != null || right != null || origin != null ? 1 : 0) != 0);
    }

    public SynchronizationModel run() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"run() - START");
        }
        return this.call(new Callable<SynchronizationModel>(){

            @Override
            public SynchronizationModel call() throws Exception {
                IFile leftFile = PlatformElementUtil.adaptAs(ModelsResolution.this.left, IFile.class);
                SynchronizationModel synchronizationModel = leftFile != null ? ModelsResolution.this.resolveModelsWithLocal(leftFile, new ThreadSafeProgressMonitor((IProgressMonitor)ModelsResolution.this.monitor)) : ModelsResolution.this.resolveRemoteModels(new ThreadSafeProgressMonitor((IProgressMonitor)ModelsResolution.this.monitor));
                if (ModelsResolution.this.logger.isDebugEnabled()) {
                    ModelsResolution.this.logger.debug((Object)"run() - FINISH");
                }
                return synchronizationModel;
            }
        });
    }

    @Override
    protected Runnable getFinalizeResolvingRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                ModelsResolution.super.getFinalizeResolvingRunnable().run();
                if (ModelsResolution.this.monitor != null) {
                    ModelsResolution.this.monitor.setWorkRemaining(0);
                }
            }
        };
    }

    private SynchronizationModel resolveModelsWithLocal(IFile leftFile, ThreadSafeProgressMonitor tspm) throws InterruptedException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"resolveModelsWithLocal() - updating dependencies");
        }
        this.localResolver.updateDependencies((IProgressMonitor)this.monitor, this.diagnostic, leftFile);
        if (tspm.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"resolveModelsWithLocal() - resolving traversal");
        }
        Set<IStorage> leftTraversal = this.resolveTraversal(leftFile, Collections.emptySet());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"resolveModelsWithLocal() - resolving remote traversal");
        }
        return this.resolveRemoteTraversals(leftTraversal, tspm);
    }

    private SynchronizationModel resolveRemoteModels(ThreadSafeProgressMonitor tspm) throws InterruptedException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"resolveRemoteModels() - resolving left remote traversal");
        }
        Set<IStorage> leftTraversal = this.resolveRemoteTraversal(this.left, Collections.emptySet(), IStorageProviderAccessor.DiffSide.SOURCE, tspm);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"resolveRemoteModels() - resolving other remote traversals");
        }
        return this.resolveRemoteTraversals(leftTraversal, tspm);
    }

    private SynchronizationModel resolveRemoteTraversals(Set<IStorage> leftTraversal, ThreadSafeProgressMonitor tspm) throws InterruptedException {
        Set<IStorage> originTraversal;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"resolveRemotetraversals() - START");
        }
        Set<IStorage> rightTraversal = this.resolveRemoteTraversal(this.right, Iterables.transform(leftTraversal, (Function)ResourceUtil.asURI()), IStorageProviderAccessor.DiffSide.REMOTE, tspm);
        Set<IStorage> differenceRightLeft = this.difference(rightTraversal, this.asURISet(leftTraversal));
        this.loadAdditionalRemoteStorages(leftTraversal, rightTraversal, differenceRightLeft, tspm);
        if (this.origin != null) {
            LinkedHashSet unionLeftRight = Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)Sets.union(leftTraversal, rightTraversal), (Function)ResourceUtil.asURI()));
            originTraversal = this.resolveRemoteTraversal(this.origin, unionLeftRight, IStorageProviderAccessor.DiffSide.ORIGIN, tspm);
            Set<IStorage> differenceOriginLeft = this.difference(originTraversal, this.asURISet(leftTraversal));
            Set<IStorage> differenceOriginRight = this.difference(originTraversal, this.asURISet(rightTraversal));
            Set<IStorage> additional = this.symmetricDifference(differenceOriginLeft, differenceOriginRight);
            this.loadAdditionalRemoteStorages(leftTraversal, rightTraversal, originTraversal, additional, tspm);
        } else {
            originTraversal = Collections.emptySet();
        }
        SynchronizationModel synchronizationModel = new SynchronizationModel(new StorageTraversal(leftTraversal), new StorageTraversal(rightTraversal), new StorageTraversal(originTraversal), (Diagnostic)this.diagnostic.getDiagnostic());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"resolveRemotetraversals() - FINISH");
        }
        return synchronizationModel;
    }

    private Set<IStorage> loadAdditionalRemoteStorages(Set<IStorage> leftSet, Set<IStorage> rightSet, Set<IStorage> additional, ThreadSafeProgressMonitor tspm) throws InterruptedException {
        boolean sourceIsLocal = Iterables.any(leftSet, (Predicate)new Predicate<IStorage>(){

            public boolean apply(IStorage input) {
                return PlatformElementUtil.adaptAs(input, IFile.class) != null;
            }
        });
        LinkedHashSet<IStorage> additionalStorages = new LinkedHashSet<IStorage>();
        LinkedHashSet<URI> additionalURIs = new LinkedHashSet<URI>();
        Set<IStorage> differenceRightLeft = additional;
        boolean somethingToAdd = !differenceRightLeft.isEmpty();
        while (somethingToAdd) {
            Set<IStorage> differenceAdditionalLeftRight;
            Set<IStorage> additionalRight;
            somethingToAdd = false;
            Set<IStorage> additionalLeft = sourceIsLocal ? this.findAdditionalLocalTraversal(leftSet, differenceRightLeft, tspm) : this.findAdditionalRemoteTraversal(leftSet, differenceRightLeft, IStorageProviderAccessor.DiffSide.SOURCE, tspm);
            if (leftSet.addAll(additionalLeft)) {
                somethingToAdd = true;
                for (IStorage storage : additionalLeft) {
                    URI newURI = (URI)ResourceUtil.asURI().apply((Object)storage);
                    if (!additionalURIs.add(newURI)) continue;
                    additionalStorages.add(storage);
                }
            }
            if (rightSet.addAll(additionalRight = this.findAdditionalRemoteTraversal(rightSet, differenceAdditionalLeftRight = this.difference(additionalLeft, this.asURISet(rightSet)), IStorageProviderAccessor.DiffSide.REMOTE, tspm))) {
                somethingToAdd = true;
                for (IStorage storage : additionalRight) {
                    URI newURI = (URI)ResourceUtil.asURI().apply((Object)storage);
                    if (!additionalURIs.add(newURI)) continue;
                    additionalStorages.add(storage);
                }
            }
            if (!somethingToAdd) continue;
            differenceRightLeft = this.difference(additionalRight, this.asURISet(leftSet));
        }
        return additionalStorages;
    }

    private void loadAdditionalRemoteStorages(Set<IStorage> leftSet, Set<IStorage> rightSet, Set<IStorage> originSet, Set<IStorage> additional, ThreadSafeProgressMonitor tspm) throws InterruptedException {
        Set<IStorage> additionalStorages = additional;
        while (!additionalStorages.isEmpty()) {
            Set<IStorage> additionalLeftRightComparedToOrigin = this.loadAdditionalRemoteStorages(leftSet, rightSet, additionalStorages, tspm);
            Set<IStorage> additionalOrigin = this.findAdditionalRemoteTraversal(originSet, additionalLeftRightComparedToOrigin, IStorageProviderAccessor.DiffSide.ORIGIN, tspm);
            originSet.addAll(additionalOrigin);
            Set<IStorage> differenceOriginLeft = this.difference(additionalOrigin, this.asURISet(leftSet));
            Set<IStorage> differenceOriginRight = this.difference(additionalOrigin, this.asURISet(rightSet));
            additionalStorages = this.symmetricDifference(differenceOriginRight, differenceOriginLeft);
            additionalStorages.removeAll(originSet);
        }
    }

    private Set<IStorage> findAdditionalRemoteTraversal(Set<IStorage> alreadyLoaded, Set<IStorage> additionalStorages, IStorageProviderAccessor.DiffSide side, ThreadSafeProgressMonitor tspm) throws InterruptedException {
        if (additionalStorages.isEmpty()) {
            return Collections.emptySet();
        }
        SynchronizedResourceSet resourceSet = this.remoteResolver.getResourceSetForRemoteResolution(this.diagnostic, tspm);
        RevisionedURIConverter converter = new RevisionedURIConverter(resourceSet.getURIConverter(), this.storageAccessor, side);
        resourceSet.setURIConverter((URIConverter)converter);
        ResourceComputationScheduler<URI> scheduler = this.context.getScheduler();
        scheduler.setComputedElements(Iterables.transform((Iterable)converter.getLoadedRevisions(), (Function)ResourceUtil.asURI()));
        Iterable urisToResolve = Iterables.transform(additionalStorages, (Function)ResourceUtil.asURI());
        urisToResolve = Iterables.filter((Iterable)urisToResolve, (Predicate)new Predicate<URI>(){

            public boolean apply(URI input) {
                return input != null && input.isPlatformResource();
            }
        });
        scheduler.computeAll(Iterables.transform((Iterable)urisToResolve, this.resolveRemoteURI(tspm, resourceSet)));
        resourceSet.dispose();
        if (tspm.isCanceled()) {
            throw new OperationCanceledException();
        }
        scheduler.clearComputedElements();
        return converter.getLoadedRevisions();
    }

    private Set<IStorage> findAdditionalLocalTraversal(Set<IStorage> alreadyLoaded, Set<IStorage> additionalStorages, ThreadSafeProgressMonitor tspm) throws InterruptedException {
        if (additionalStorages.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<IStorage> traversal = new LinkedHashSet<IStorage>();
        Iterable urisToResolve = Iterables.transform(additionalStorages, (Function)ResourceUtil.asURI());
        urisToResolve = Iterables.filter((Iterable)urisToResolve, (Predicate)new Predicate<URI>(){

            public boolean apply(URI input) {
                return input != null && input.isPlatformResource();
            }
        });
        for (URI resolveMe : urisToResolve) {
            IResource file = ResourceUtil.getResourceFromURI((URI)resolveMe);
            if (!(file instanceof IFile) || alreadyLoaded.contains(file)) continue;
            this.localResolver.updateDependencies((IProgressMonitor)this.monitor, this.diagnostic, (IFile)file);
            if (tspm.isCanceled()) {
                throw new OperationCanceledException();
            }
            traversal.addAll(this.resolveTraversal((IFile)file, Collections.emptySet()));
        }
        return traversal;
    }

    private Set<IStorage> symmetricDifference(Set<IStorage> set1, Set<IStorage> set2) {
        LinkedHashSet uris1 = Sets.newLinkedHashSet((Iterable)Iterables.transform(set1, (Function)ResourceUtil.asURI()));
        LinkedHashSet uris2 = Sets.newLinkedHashSet((Iterable)Iterables.transform(set2, (Function)ResourceUtil.asURI()));
        LinkedHashSet<IStorage> symmetricDifference = new LinkedHashSet<IStorage>();
        for (IStorage storage1 : set1) {
            if (uris2.contains(ResourceUtil.asURI().apply((Object)storage1))) continue;
            symmetricDifference.add(storage1);
        }
        for (IStorage storage2 : set2) {
            if (uris1.contains(ResourceUtil.asURI().apply((Object)storage2))) continue;
            symmetricDifference.add(storage2);
        }
        return symmetricDifference;
    }

    private Set<IStorage> difference(Set<IStorage> set1, Set<URI> set2) {
        LinkedHashSet<IStorage> difference = new LinkedHashSet<IStorage>();
        for (IStorage storage1 : set1) {
            URI uri = (URI)ResourceUtil.asURI().apply((Object)storage1);
            if (set2.contains(uri)) continue;
            difference.add(storage1);
        }
        return difference;
    }

    private Set<IStorage> resolveRemoteTraversal(IStorage start, Iterable<URI> knownVariants, IStorageProviderAccessor.DiffSide side, ThreadSafeProgressMonitor tspm) throws InterruptedException {
        if (start == null) {
            return Sets.newLinkedHashSet();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("resolveRemotetraversal() - START for " + start));
        }
        SynchronizedResourceSet resourceSet = this.remoteResolver.getResourceSetForRemoteResolution(this.diagnostic, tspm);
        RevisionedURIConverter converter = new RevisionedURIConverter(resourceSet.getURIConverter(), this.storageAccessor, side);
        resourceSet.setURIConverter((URIConverter)converter);
        ResourceComputationScheduler<URI> scheduler = this.context.getScheduler();
        scheduler.clearComputedElements();
        URI startURI = converter.normalize(ResourceUtil.createURIFor((IStorage)start));
        Iterable knownVariantsAndStart = Iterables.concat(knownVariants, Collections.singleton(startURI));
        Iterable<URI> urisToResolve = this.addRenamedUris(knownVariantsAndStart, converter, side);
        scheduler.computeAll(Iterables.transform(urisToResolve, this.resolveRemoteURI(tspm, resourceSet)));
        if (tspm.isCanceled()) {
            throw new OperationCanceledException();
        }
        scheduler.clearComputedElements();
        resourceSet.dispose();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("resolveRemotetraversal() - END for " + start));
        }
        return converter.getLoadedRevisions();
    }

    private Iterable<URI> addRenamedUris(Iterable<URI> resolvedUris, RevisionedURIConverter converter, IStorageProviderAccessor.DiffSide side) {
        HashSet<URI> renamedUris = new HashSet<URI>();
        for (URI resolvedUri : resolvedUris) {
            IResource iResource = ResourceUtil.getResourceFromURI((URI)resolvedUri);
            if (!(iResource instanceof IFile)) continue;
            IFile iFile = (IFile)iResource;
            Optional fileBeforeRename = Optional.fromNullable((Object)this.storageAccessor.getFileBeforeRename(iFile, IStorageProviderAccessor.DiffSide.SOURCE));
            if (IStorageProviderAccessor.DiffSide.ORIGIN.equals((Object)side)) {
                renamedUris.addAll(this.resolveRenamedUri((Optional<IFile>)fileBeforeRename, converter));
                continue;
            }
            if (!IStorageProviderAccessor.DiffSide.REMOTE.equals((Object)side)) continue;
            Optional fileAfterRename = Optional.fromNullable((Object)this.storageAccessor.getFileAfterRename(iFile, IStorageProviderAccessor.DiffSide.REMOTE));
            renamedUris.addAll(this.resolveRenamedUri((Optional<IFile>)fileAfterRename, converter));
            renamedUris.addAll(this.resolveRenamedUri((Optional<IFile>)fileBeforeRename, converter));
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        return builder.addAll(renamedUris).addAll(resolvedUris).build();
    }

    private Collection<URI> resolveRenamedUri(Optional<IFile> renamedFile, RevisionedURIConverter converter) {
        HashSet<URI> renamedUris = new HashSet<URI>();
        if (renamedFile.isPresent()) {
            URI unnormalizedRenamedUri = ResourceUtil.createURIFor((IFile)((IFile)renamedFile.get()));
            URI renamedUri = converter.normalize(unnormalizedRenamedUri);
            renamedUris.addAll(this.context.getImplicitDependencies().of(renamedUri, (URIConverter)converter));
            renamedUris.add(renamedUri);
        }
        return renamedUris;
    }

    protected Function<URI, IComputation<URI>> resolveRemoteURI(final ThreadSafeProgressMonitor tspm, final SynchronizedResourceSet resourceSet) {
        return new Function<URI, IComputation<URI>>(){

            public IComputation<URI> apply(URI uri) {
                return ModelsResolution.this.remoteResolver.getRemoteResolveComputation(resourceSet, uri, ModelsResolution.this.diagnostic, tspm);
            }
        };
    }
}

