/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions.ui.SynchronizerDialog;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.DifferenceFilterManager;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.Preferences;

public class FilterAction
extends Action {
    private final IDifferenceFilter filter;
    private final StructureMergeViewerFilter structureMergeViewerFilter;
    private final Preferences preferences;
    private final DifferenceFilterManager filterManager;

    public FilterAction(String text, StructureMergeViewerFilter structureMergeViewerFilter, IDifferenceFilter filter) {
        super(text, 2);
        this.structureMergeViewerFilter = structureMergeViewerFilter;
        this.filter = filter;
        this.preferences = EMFCompareRCPUIPlugin.getDefault().getEMFCompareUIPreferences();
        this.filterManager = EMFCompareRCPUIPlugin.getDefault().getDifferenceFilterManager();
    }

    public void runWithEvent(Event event) {
        if (this.isChecked()) {
            this.structureMergeViewerFilter.addFilter(this.filter);
        } else {
            this.structureMergeViewerFilter.removeFilter(this.filter);
        }
        this.handleSynchronization(event);
    }

    private void handleSynchronization(Event event) {
        String sync = this.preferences.get("org.eclipse.emf.compare.rcp.ui.filters.syncbehavior", "prompt");
        Shell shell = event.display.getActiveShell();
        if ("prompt".equals(sync) && shell != null) {
            shell.getDisplay().asyncExec((Runnable)new SynchronizationBehaviorRunnable(shell));
        } else if ("always".equals(sync)) {
            this.synchonizeFilters();
        }
    }

    private void synchonizeFilters() {
        LinkedHashSet byDefaultFilters = Sets.newLinkedHashSet(this.filterManager.getCurrentByDefaultFilters());
        for (IDifferenceFilter activeFilter : this.structureMergeViewerFilter.getSelectedDifferenceFilters()) {
            byDefaultFilters.add(activeFilter);
        }
        for (IDifferenceFilter toDeactivateFilter : this.structureMergeViewerFilter.getUnSelectedDifferenceFilters()) {
            byDefaultFilters.remove(toDeactivateFilter);
        }
        this.filterManager.setCurrentByDefaultFilters(byDefaultFilters);
    }

    private final class SynchronizationBehaviorRunnable
    implements Runnable {
        private final Shell shell;

        private SynchronizationBehaviorRunnable(Shell shell) {
            this.shell = shell;
        }

        @Override
        public void run() {
            SynchronizerDialog dialog = new SynchronizerDialog(this.shell, EMFCompareRCPUIMessages.getString("FilterAction.synchronization.dialog.title"), EMFCompareRCPUIMessages.getString("FilterAction.synchronization.dialog.message"), "org.eclipse.emf.compare.rcp.ui.preferencePage.filters");
            dialog.setPrefKey("org.eclipse.emf.compare.rcp.ui.filters.syncbehavior");
            dialog.setPrefStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.emf.compare.rcp.ui"));
            if (dialog.open() == 2) {
                FilterAction.this.synchonizeFilters();
            }
        }
    }
}

