/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.view.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.logical.view.registry.LogicalModelViewHandlerDescriptor;
import org.eclipse.emf.compare.ide.ui.internal.logical.view.registry.LogicalModelViewHandlerRegistry;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;

public class LogicalModelViewHandlerRegistryListener
extends AbstractRegistryEventListener {
    private static final String TAG_HANDLER = "handler";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_RANKING = "ranking";
    private final LogicalModelViewHandlerRegistry registry;

    public LogicalModelViewHandlerRegistryListener(String pluginID, String extensionPointID, ILog log, LogicalModelViewHandlerRegistry registry) {
        super(pluginID, extensionPointID, log);
        this.registry = registry;
    }

    protected boolean addedValid(IConfigurationElement element) {
        if (element.getName().equals(TAG_HANDLER)) {
            String className = element.getAttribute(ATTRIBUTE_CLASS);
            String rankingStr = element.getAttribute(ATTRIBUTE_RANKING);
            int ranking = -1;
            try {
                ranking = Integer.parseInt(rankingStr);
            }
            catch (NumberFormatException numberFormatException) {
                this.log(4, element, EMFCompareIDEUIMessages.getString("ModelhandlerRegistry.invalidRanking", className, rankingStr));
            }
            LogicalModelViewHandlerDescriptor descriptor = new LogicalModelViewHandlerDescriptor(element, ATTRIBUTE_CLASS, ranking);
            this.registry.addHandler(className, descriptor);
            return true;
        }
        return false;
    }

    protected boolean removedValid(IConfigurationElement element) {
        String className = element.getAttribute(ATTRIBUTE_CLASS);
        this.registry.removeHandler(className);
        return true;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        return true;
    }
}

