/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.RevisionedURIConverter;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProvider;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.tests.unit.AbstractURITest;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jgit.api.Status;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class RevisionedURIConverterTest
extends AbstractURITest {
    @Test
    public void testStorageAccessorContents_straight() throws Exception {
        this.setupStraightRepo();
        IStorageProviderAccessor accessor = this.createAccessorForComparison("refs/heads/master", "refs/heads/branch", false);
        URI file1URI = ResourceUtil.createURIFor((IFile)this.iFile1);
        this.assertStateInitial(file1URI, accessor, IStorageProviderAccessor.DiffSide.ORIGIN);
        this.assertStateMaster(file1URI, accessor, IStorageProviderAccessor.DiffSide.SOURCE);
        this.assertStateBranch(file1URI, accessor, IStorageProviderAccessor.DiffSide.REMOTE);
    }

    @Test
    public void testStorageAccessorContents_multipleCommits() throws Exception {
        String branch1Name = "refs/heads/branch1";
        String branch2Name = "refs/heads/branch2";
        this.setupMultipleCommitsRepo(branch1Name, branch2Name);
        IStorageProviderAccessor accessor = this.createAccessorForComparison("refs/heads/master", branch2Name, false);
        URI file1URI = ResourceUtil.createURIFor((IFile)this.iFile1);
        this.assertStateInitial(file1URI, accessor, IStorageProviderAccessor.DiffSide.ORIGIN);
        this.assertStateMaster(file1URI, accessor, IStorageProviderAccessor.DiffSide.SOURCE);
        this.assertStateBranch(file1URI, accessor, IStorageProviderAccessor.DiffSide.REMOTE);
    }

    @Test
    public void testRedirectingAccessor() throws Exception {
        IProject iProject = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File originFile = this.project.getOrCreateFile(iProject, String.valueOf(IStorageProviderAccessor.DiffSide.ORIGIN.toString()) + "/file1.ecore");
        File sourceFile = this.project.getOrCreateFile(iProject, String.valueOf(IStorageProviderAccessor.DiffSide.SOURCE.toString()) + "/file1.ecore");
        File remoteFile = this.project.getOrCreateFile(iProject, String.valueOf(IStorageProviderAccessor.DiffSide.REMOTE.toString()) + "/file1.ecore");
        IFile originIFile = this.project.getIFile(iProject, originFile);
        IFile sourceIFile = this.project.getIFile(iProject, sourceFile);
        IFile remoteIFile = this.project.getIFile(iProject, remoteFile);
        Resource originResource = this.connectResource(originIFile, (ResourceSet)resourceSet);
        Resource sourceResource = this.connectResource(sourceIFile, (ResourceSet)resourceSet);
        Resource remoteResource = this.connectResource(remoteIFile, (ResourceSet)resourceSet);
        EPackage originRoot = this.createPackage(null, "P1");
        this.createClass(originRoot, "C1");
        this.createClass(originRoot, "C2");
        originResource.getContents().add((Object)originRoot);
        this.save(new Resource[]{originResource});
        EPackage sourceRoot = this.createPackage(null, "P1");
        this.createClass(sourceRoot, "C1_renamed");
        sourceResource.getContents().add((Object)sourceRoot);
        this.save(new Resource[]{sourceResource});
        EPackage remoteRoot = this.createPackage(null, "P1");
        EClass class1 = this.createClass(remoteRoot, "C1");
        EClass class2 = this.createClass(remoteRoot, "C2");
        this.createClass(remoteRoot, "C3");
        class1.getESuperTypes().add((Object)class2);
        remoteResource.getContents().add((Object)remoteRoot);
        this.save(new Resource[]{remoteResource});
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        IStorageProviderAccessor accessor = (IStorageProviderAccessor)Mockito.mock(IStorageProviderAccessor.class);
        Mockito.when((Object)accessor.getStorageProvider((IResource)Matchers.any(IResource.class), (IStorageProviderAccessor.DiffSide)Matchers.any(IStorageProviderAccessor.DiffSide.class))).then(this.getPathRedirectingStorageProvider());
        URI file1URI = ResourceUtil.createURIFor((IFile)this.iFile1);
        this.assertStateInitial(file1URI, accessor, IStorageProviderAccessor.DiffSide.ORIGIN);
        this.assertStateMaster(file1URI, accessor, IStorageProviderAccessor.DiffSide.SOURCE);
        this.assertStateBranch(file1URI, accessor, IStorageProviderAccessor.DiffSide.REMOTE);
    }

    @Test
    public void testNullAccessor() throws Exception {
        IStorageProviderAccessor accessor = (IStorageProviderAccessor)Mockito.mock(IStorageProviderAccessor.class);
        ExtensibleURIConverterImpl delegate = new ExtensibleURIConverterImpl();
        URI fileURI = ResourceUtil.createURIFor((IFile)this.iFile1);
        RevisionedURIConverter converter = new RevisionedURIConverter((URIConverter)delegate, accessor, IStorageProviderAccessor.DiffSide.ORIGIN);
        InputStream stream = converter.createInputStream(fileURI, Collections.emptyMap());
        Assert.assertNull((Object)stream);
        converter = new RevisionedURIConverter((URIConverter)delegate, accessor, IStorageProviderAccessor.DiffSide.REMOTE);
        stream = converter.createInputStream(fileURI, Collections.emptyMap());
        Assert.assertNull((Object)stream);
        converter = new RevisionedURIConverter((URIConverter)delegate, accessor, IStorageProviderAccessor.DiffSide.SOURCE);
        stream = converter.createInputStream(fileURI, Collections.emptyMap());
        Assert.assertNull((Object)stream);
    }

    @Test
    public void testExceptionAccessor() throws Exception {
        IStorageProviderAccessor accessor = (IStorageProviderAccessor)Mockito.mock(IStorageProviderAccessor.class);
        Mockito.when((Object)accessor.getStorageProvider((IResource)Matchers.any(IResource.class), (IStorageProviderAccessor.DiffSide)Matchers.any(IStorageProviderAccessor.DiffSide.class))).thenThrow(new Class[]{UnsupportedOperationException.class});
        ExtensibleURIConverterImpl delegate = new ExtensibleURIConverterImpl();
        URI fileURI = ResourceUtil.createURIFor((IFile)this.iFile1);
        RevisionedURIConverter converter = new RevisionedURIConverter((URIConverter)delegate, accessor, IStorageProviderAccessor.DiffSide.ORIGIN);
        try {
            converter.createInputStream(fileURI, Collections.emptyMap());
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            converter = new RevisionedURIConverter((URIConverter)delegate, accessor, IStorageProviderAccessor.DiffSide.REMOTE);
            converter.createInputStream(fileURI, Collections.emptyMap());
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            converter = new RevisionedURIConverter((URIConverter)delegate, accessor, IStorageProviderAccessor.DiffSide.SOURCE);
            converter.createInputStream(fileURI, Collections.emptyMap());
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testExistsCache() throws CoreException {
        final IStorageProvider fileStorageProvider = (IStorageProvider)Mockito.mock(IStorageProvider.class);
        Mockito.when((Object)fileStorageProvider.getStorage((IProgressMonitor)Matchers.any(IProgressMonitor.class))).thenReturn((Object)this.iFile1);
        final IStorageProvider nullStorageProvider = (IStorageProvider)Mockito.mock(IStorageProvider.class);
        Mockito.when((Object)nullStorageProvider.getStorage((IProgressMonitor)Matchers.any(IProgressMonitor.class))).thenReturn(null);
        IStorageProviderAccessor accessor = (IStorageProviderAccessor)Mockito.mock(IStorageProviderAccessor.class);
        Mockito.when((Object)accessor.getStorageProvider((IResource)Matchers.any(IResource.class), (IStorageProviderAccessor.DiffSide)Matchers.any(IStorageProviderAccessor.DiffSide.class))).then((Answer)new Answer<IStorageProvider>(){

            public IStorageProvider answer(InvocationOnMock invocation) throws Throwable {
                return RevisionedURIConverterTest.this.iFile1.equals(invocation.getArguments()[0]) ? fileStorageProvider : nullStorageProvider;
            }
        });
        Assert.assertSame((Object)nullStorageProvider, (Object)accessor.getStorageProvider(null, IStorageProviderAccessor.DiffSide.ORIGIN));
        Assert.assertSame((Object)fileStorageProvider, (Object)accessor.getStorageProvider((IResource)this.iFile1, IStorageProviderAccessor.DiffSide.ORIGIN));
        URI fileURI = ResourceUtil.createURIFor((IFile)this.iFile1);
        URI nullURI = URI.createURI((String)"noProject/notExisting.file");
        ExtensibleURIConverterImpl delegate = new ExtensibleURIConverterImpl();
        RevisionedURIConverter converter = new RevisionedURIConverter((URIConverter)delegate, accessor, IStorageProviderAccessor.DiffSide.ORIGIN);
        Assert.assertTrue((boolean)converter.exists(fileURI, null));
        Assert.assertFalse((boolean)converter.exists(nullURI, null));
        ((IStorageProvider)Mockito.verify((Object)fileStorageProvider, (VerificationMode)Mockito.times((int)1))).getStorage((IProgressMonitor)Matchers.any(IProgressMonitor.class));
        ((IStorageProvider)Mockito.verify((Object)nullStorageProvider, (VerificationMode)Mockito.times((int)1))).getStorage((IProgressMonitor)Matchers.any(IProgressMonitor.class));
        Assert.assertTrue((boolean)converter.exists(fileURI, null));
        Assert.assertFalse((boolean)converter.exists(nullURI, null));
        Assert.assertTrue((boolean)converter.exists(fileURI, null));
        Assert.assertFalse((boolean)converter.exists(nullURI, null));
        Assert.assertTrue((boolean)converter.exists(fileURI, null));
        Assert.assertFalse((boolean)converter.exists(nullURI, null));
        ((IStorageProvider)Mockito.verify((Object)fileStorageProvider, (VerificationMode)Mockito.times((int)1))).getStorage((IProgressMonitor)Matchers.any(IProgressMonitor.class));
        ((IStorageProvider)Mockito.verify((Object)nullStorageProvider, (VerificationMode)Mockito.times((int)1))).getStorage((IProgressMonitor)Matchers.any(IProgressMonitor.class));
    }

    private Answer<IStorageProvider> getPathRedirectingStorageProvider() {
        return new Answer<IStorageProvider>(){

            public IStorageProvider answer(InvocationOnMock invocation) throws Throwable {
                IResource resource = (IResource)invocation.getArguments()[0];
                IStorageProviderAccessor.DiffSide side = (IStorageProviderAccessor.DiffSide)invocation.getArguments()[1];
                Assert.assertTrue((resource instanceof IFile && resource.exists() ? 1 : 0) != 0);
                IPath originalPath = resource.getFullPath();
                String fileName = originalPath.lastSegment();
                final IPath redirectedPath = originalPath.removeLastSegments(1).append(side.toString()).append(fileName);
                return new IStorageProvider(){

                    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
                        return ResourcesPlugin.getWorkspace().getRoot().getFile(redirectedPath);
                    }
                };
            }
        };
    }
}

