/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMergeOptionAware;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.postprocessor.PostProcessorDescriptorRegistryImpl;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.postprocess.data.TestPostProcessor;
import org.eclipse.emf.compare.uml2.internal.StereotypedElementChange;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.compare.uml2.internal.merge.OpaqueElementBodyChangeMerger;
import org.eclipse.emf.compare.uml2.internal.merge.UMLMerger;
import org.eclipse.emf.compare.uml2.internal.merge.UMLReferenceChangeMerger;
import org.eclipse.emf.compare.uml2.internal.postprocessor.OpaqueElementBodyChangePostProcessor;
import org.eclipse.emf.compare.uml2.internal.postprocessor.UMLPostProcessor;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.resource.UMLResourceFactoryImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractUMLTest {
    private IMerger.Registry mergerRegistry;
    private static final Map<IMergeOptionAware, Object> CACHED_OPTIONS = Maps.newHashMap();

    public static void fillRegistries() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
            EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/compare", (Object)ComparePackage.eINSTANCE);
            EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/uml2/5.0.0/UML", (Object)UMLPackage.eINSTANCE);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("uml", new UMLResourceFactoryImpl());
        }
    }

    public static void resetRegistries() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().remove("uml");
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().remove("ecore");
            EPackage.Registry.INSTANCE.remove((Object)"http://www.eclipse.org/emf/compare/uml2/1.0.0/testprofile");
            EPackage.Registry.INSTANCE.remove((Object)"http://www.eclipse.org/emf/compare");
            EPackage.Registry.INSTANCE.remove((Object)"http://www.eclipse.org/emf/2002/Ecore");
        }
    }

    @Before
    public void before() {
        this.mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
        UMLMerger umlMerger = new UMLMerger();
        UMLReferenceChangeMerger umlReferenceChangeMerger = new UMLReferenceChangeMerger();
        OpaqueElementBodyChangeMerger opaqueElementBodyChangeMerger = new OpaqueElementBodyChangeMerger();
        umlMerger.setRanking(20);
        umlReferenceChangeMerger.setRanking(25);
        opaqueElementBodyChangeMerger.setRanking(25);
        this.mergerRegistry.add((IMerger)umlMerger);
        this.mergerRegistry.add((IMerger)umlReferenceChangeMerger);
        this.mergerRegistry.add((IMerger)opaqueElementBodyChangeMerger);
    }

    protected void registerPostProcessors(IPostProcessor.Descriptor.Registry<String> postProcessorRegistry) {
        postProcessorRegistry.put((Object)UMLPostProcessor.class.getName(), (IPostProcessor.Descriptor)new TestPostProcessor.TestPostProcessorDescriptor(Pattern.compile("http://www.eclipse.org/uml2/\\d\\.0\\.0/UML"), null, (IPostProcessor)new UMLPostProcessor(), 20));
        postProcessorRegistry.put((Object)OpaqueElementBodyChangePostProcessor.class.getName(), (IPostProcessor.Descriptor)new TestPostProcessor.TestPostProcessorDescriptor(Pattern.compile("http://www.eclipse.org/uml2/\\d\\.0\\.0/UML"), null, (IPostProcessor)new OpaqueElementBodyChangePostProcessor(), 25));
    }

    @After
    public void cleanup() {
        for (ResourceSet set : this.getInput().getSets()) {
            for (Resource res : set.getResources()) {
                res.unload();
            }
            set.getResources().clear();
        }
        this.getInput().getSets().clear();
    }

    protected EMFCompare getCompare() {
        EMFCompare.Builder builder = EMFCompare.builder();
        PostProcessorDescriptorRegistryImpl postProcessorRegistry = new PostProcessorDescriptorRegistryImpl();
        this.registerPostProcessors((IPostProcessor.Descriptor.Registry<String>)postProcessorRegistry);
        builder.setPostProcessorRegistry((IPostProcessor.Descriptor.Registry)postProcessorRegistry);
        return builder.build();
    }

    protected Comparison compare(Notifier left, Notifier right) {
        return this.compare(left, right, null);
    }

    protected Comparison compare(Notifier left, Notifier right, Notifier origin) {
        DefaultComparisonScope scope = new DefaultComparisonScope(left, right, origin);
        return this.getCompare().compare((IComparisonScope)scope);
    }

    protected IMerger.Registry getMergerRegistry() {
        return this.mergerRegistry;
    }

    protected static int count(List<Diff> differences, Predicate<Object> p) {
        int count = 0;
        UnmodifiableIterator result = Iterators.filter(differences.iterator(), p);
        while (result.hasNext()) {
            ++count;
            result.next();
        }
        return count;
    }

    public static Predicate<? super Diff> onRealFeature(final EStructuralFeature feature) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                EAttribute affectedFeature;
                if (input instanceof AttributeChange) {
                    affectedFeature = ((AttributeChange)input).getAttribute();
                } else if (input instanceof ReferenceChange) {
                    affectedFeature = ((ReferenceChange)input).getReference();
                } else {
                    return false;
                }
                return feature == affectedFeature;
            }
        };
    }

    public static Predicate<? super Diff> isChangeAdd() {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                if (input instanceof ReferenceChange) {
                    return ReferenceUtil.getAsList((EObject)input.getMatch().getLeft(), (EStructuralFeature)((ReferenceChange)input).getReference()).contains(((ReferenceChange)input).getValue());
                }
                if (input instanceof AttributeChange) {
                    return ReferenceUtil.getAsList((EObject)input.getMatch().getLeft(), (EStructuralFeature)((AttributeChange)input).getAttribute()).contains(((AttributeChange)input).getValue());
                }
                return false;
            }
        };
    }

    protected static Predicate<Diff> discriminantInstanceOf(final EClass clazz) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                return input instanceof UMLDiff && clazz.isInstance((Object)((UMLDiff)input).getDiscriminant());
            }
        };
    }

    protected abstract AbstractUMLInputData getInput();

    protected void testMergeLeftToRight(Notifier left, Notifier right, Notifier origin) {
        this.testMergeLeftToRight(left, right, origin, false);
    }

    protected void testMergeRightToLeft(Notifier left, Notifier right, Notifier origin) {
        this.testMergeRightToLeft(left, right, origin, false);
    }

    protected void testMergeLeftToRight(Notifier left, Notifier right, Notifier origin, boolean pseudoAllowed) {
        DefaultComparisonScope scope = new DefaultComparisonScope(left, right, origin);
        Comparison comparisonBefore = this.getCompare().compare((IComparisonScope)scope);
        EList differencesBefore = comparisonBefore.getDifferences();
        BatchMerger merger = new BatchMerger(this.mergerRegistry);
        merger.copyAllLeftToRight((Iterable)differencesBefore, (Monitor)new BasicMonitor());
        Comparison comparisonAfter = this.getCompare().compare((IComparisonScope)scope);
        EList differencesAfter = comparisonAfter.getDifferences();
        boolean diffs = pseudoAllowed ? Iterators.all((Iterator)differencesAfter.iterator(), (Predicate)EMFComparePredicates.hasDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})) : differencesAfter.isEmpty();
        Assert.assertTrue((String)"Comparison#getDifferences() must be empty after copyAllLeftToRight", (boolean)diffs);
    }

    protected void testMergeRightToLeft(Notifier left, Notifier right, Notifier origin, boolean pseudoAllowed) {
        DefaultComparisonScope scope = new DefaultComparisonScope(left, right, origin);
        Comparison comparisonBefore = this.getCompare().compare((IComparisonScope)scope);
        EList differencesBefore = comparisonBefore.getDifferences();
        BatchMerger merger = new BatchMerger(this.mergerRegistry);
        merger.copyAllRightToLeft((Iterable)differencesBefore, (Monitor)new BasicMonitor());
        Comparison comparisonAfter = this.getCompare().compare((IComparisonScope)scope);
        EList differencesAfter = comparisonAfter.getDifferences();
        boolean diffs = pseudoAllowed ? Iterators.all((Iterator)differencesAfter.iterator(), (Predicate)EMFComparePredicates.hasDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})) : differencesAfter.isEmpty();
        Assert.assertTrue((String)"Comparison#getDifferences() must be empty after copyAllRightToLeft", (boolean)diffs);
    }

    protected void testIntersections(Comparison comparison) {
        for (Diff diff : comparison.getDifferences()) {
            int realRefinesSize = Iterables.size((Iterable)Iterables.filter((Iterable)diff.getRefines(), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(StereotypedElementChange.class))));
            Assert.assertFalse((String)("Wrong number of refines (without StereotypedElementChange) on" + diff), (realRefinesSize > 1 ? 1 : 0) != 0);
            int stereotypedElementChangeRefines = Iterables.size((Iterable)Iterables.filter((Iterable)diff.getRefines(), (Predicate)Predicates.instanceOf(StereotypedElementChange.class)));
            Assert.assertFalse((String)("Wrong number of refines (of type StereotypedElementChange) on " + diff), (stereotypedElementChangeRefines > 1 ? 1 : 0) != 0);
        }
    }

    protected void enableCascadingFilter() {
        this.setCascadingFilter(true);
    }

    protected void disableCascadingFilter() {
        this.setCascadingFilter(false);
    }

    private void setCascadingFilter(boolean enabled) {
        for (IMergeOptionAware merger : Iterables.filter((Iterable)this.mergerRegistry.getMergers(null), IMergeOptionAware.class)) {
            Map mergeOptions = merger.getMergeOptions();
            Object previousValue = mergeOptions.get("subDiffAwareOption");
            CACHED_OPTIONS.put(merger, previousValue);
            mergeOptions.put("subDiffAwareOption", enabled);
        }
    }

    protected void restoreCascadingFilter() {
        for (Map.Entry<IMergeOptionAware, Object> entry : CACHED_OPTIONS.entrySet()) {
            IMergeOptionAware merger = entry.getKey();
            merger.getMergeOptions().put("subDiffAwareOption", entry.getValue());
        }
    }

    protected static enum TestKind {
        ADD,
        DELETE;

    }
}

