/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.egit;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.StorageTypedElement;
import org.eclipse.emf.compare.ide.ui.internal.logical.SubscriberStorageAccessor;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ThreadedModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IModelMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProvider;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.tests.CompareTestCase;
import org.eclipse.emf.compare.ide.ui.tests.egit.fixture.GitTestRepository;
import org.eclipse.emf.compare.ide.ui.tests.egit.fixture.MockSystemReader;
import org.eclipse.emf.compare.ide.ui.tests.workspace.TestProject;
import org.eclipse.emf.compare.internal.utils.Graph;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.team.core.subscribers.Subscriber;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.osgi.framework.Bundle;

public class CompareGitTestCase
extends CompareTestCase {
    protected static final String TEST_BUNDLE = "org.eclipse.emf.compare.ide.ui.tests.git";
    protected GitTestRepository repository;
    protected File gitDir;

    @BeforeClass
    public static void setUpClass() {
        IEclipsePreferences eGitPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.egit.core");
        eGitPreferences.put("core_preferredMergeStrategy", "model recursive");
        eGitPreferences.putBoolean("core_autoShareProjects", false);
        eGitPreferences.putBoolean("core_autoIgnoreDerivedResources", false);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        RepositoryCache.getInstance().clear();
        MockSystemReader mockSystemReader = new MockSystemReader();
        SystemReader.setInstance((SystemReader)mockSystemReader);
        mockSystemReader.setProperty("GIT_CEILING_DIRECTORIES", ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getParentFile().getAbsoluteFile().toString());
        IWorkspaceRoot workspaceRoot = this.project.getProject().getWorkspace().getRoot();
        this.gitDir = new File(workspaceRoot.getRawLocation().toFile(), ".git");
        this.repository = new GitTestRepository(this.gitDir);
        this.repository.connect(this.project.getProject());
        File gitIgnoreFile = workspaceRoot.getRawLocation().append(".gitignore").toFile();
        Path gitIgnorePath = gitIgnoreFile.toPath();
        Files.write(gitIgnorePath, Collections.singleton("/.metadata/"), Charset.forName("UTF-8"), StandardOpenOption.CREATE);
    }

    @After
    public void tearDown() throws Exception {
        this.repository.dispose();
        RepositoryCache.getInstance().clear();
        if (this.gitDir.exists()) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Stream<Path> walk = Files.walk(this.gitDir.toPath(), new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        super.tearDown();
    }

    protected void compareBothDirectionsAndCheck(IFile file, String source, String destination, int expectedConflicts, int diffsInSource, int diffsInDestination) throws Exception {
        this.repository.checkoutBranch(source);
        Comparison compareResult = this.compare(source, destination, file);
        Assert.assertEquals((long)expectedConflicts, (long)compareResult.getConflicts().size());
        CompareGitTestCase.assertDiffCount((List<Diff>)compareResult.getDifferences(), diffsInSource, diffsInDestination);
        this.repository.checkoutBranch(destination);
        compareResult = this.compare(destination, source, file);
        Assert.assertEquals((long)expectedConflicts, (long)compareResult.getConflicts().size());
        CompareGitTestCase.assertDiffCount((List<Diff>)compareResult.getDifferences(), diffsInDestination, diffsInSource);
        this.repository.checkoutBranch(source);
    }

    protected Comparison compare(String sourceRev, String targetRev, IFile file) throws Exception {
        String fullPath = file.getFullPath().toString();
        Subscriber subscriber = this.repository.createSubscriberForComparison(sourceRev, targetRev, file, false);
        SubscriberStorageAccessor accessor = new SubscriberStorageAccessor(subscriber);
        IStorageProvider sourceProvider = accessor.getStorageProvider((IResource)file, IStorageProviderAccessor.DiffSide.SOURCE);
        IStorageProvider remoteProvider = accessor.getStorageProvider((IResource)file, IStorageProviderAccessor.DiffSide.REMOTE);
        IStorageProvider ancestorProvider = accessor.getStorageProvider((IResource)file, IStorageProviderAccessor.DiffSide.ORIGIN);
        Assert.assertNotNull((Object)sourceProvider);
        Assert.assertNotNull((Object)remoteProvider);
        Assert.assertNotNull((Object)ancestorProvider);
        NullProgressMonitor monitor = new NullProgressMonitor();
        SubscriberStorageAccessor storageAccessor = new SubscriberStorageAccessor(subscriber);
        StorageTypedElement left = new StorageTypedElement((IStorage)file, fullPath);
        StorageTypedElement right = new StorageTypedElement(remoteProvider.getStorage((IProgressMonitor)monitor), fullPath);
        StorageTypedElement origin = new StorageTypedElement(ancestorProvider.getStorage((IProgressMonitor)monitor), fullPath);
        ThreadedModelResolver resolver = new ThreadedModelResolver();
        resolver.setGraph((IGraph)new Graph());
        resolver.initialize();
        ComparisonScopeBuilder scopeBuilder = new ComparisonScopeBuilder((IModelResolver)resolver, (IModelMinimizer)EMFCompareIDEUIPlugin.getDefault().getModelMinimizerRegistry().getCompoundMinimizer(), (IStorageProviderAccessor)storageAccessor);
        IComparisonScope scope = scopeBuilder.build((ITypedElement)left, (ITypedElement)right, (ITypedElement)origin, (IProgressMonitor)monitor);
        ResourceSet leftResourceSet = (ResourceSet)scope.getLeft();
        ResourceSet rightResourceSet = (ResourceSet)scope.getRight();
        ResourceSet originResourceSet = (ResourceSet)scope.getOrigin();
        Assert.assertFalse((boolean)leftResourceSet.getResources().isEmpty());
        Assert.assertFalse((boolean)rightResourceSet.getResources().isEmpty());
        Assert.assertFalse((boolean)originResourceSet.getResources().isEmpty());
        EMFCompare.Builder comparisonBuilder = EMFCompare.builder();
        EMFCompareBuilderConfigurator.createDefault().configure(comparisonBuilder);
        return comparisonBuilder.build().compare(scope, (Monitor)new BasicMonitor());
    }

    protected IStorageProviderAccessor createAccessorForComparison(String sourceRev, String targetRev, boolean includeLocal) throws Exception {
        Subscriber subscriber = this.repository.createSubscriberForResolution(sourceRev, targetRev, includeLocal);
        return new SubscriberStorageAccessor(subscriber);
    }

    protected IStorageProviderAccessor createRemoteAccessorForComparison(String sourceRev, String targetRev, IFile file) throws Exception {
        Subscriber subscriber = this.repository.createSubscriberForComparisonWithRemoteMappings(sourceRev, targetRev, file);
        return new SubscriberStorageAccessor(subscriber);
    }

    protected static void assertDiffCount(List<Diff> differences, int expectedOutgoing, int expectedIncoming) {
        Assert.assertEquals((long)(expectedOutgoing + expectedIncoming), (long)differences.size());
        int outgoingCount = 0;
        int incomingCount = 0;
        for (Diff diff : differences) {
            switch (diff.getSource()) {
                case LEFT: {
                    ++outgoingCount;
                    break;
                }
                case RIGHT: {
                    ++incomingCount;
                    break;
                }
            }
        }
        Assert.assertEquals((long)expectedOutgoing, (long)outgoingCount);
        Assert.assertEquals((long)expectedIncoming, (long)incomingCount);
    }

    protected IFile addToProject(String testDataPath, TestProject testProject, IProject testIProject, String filePath, String destinationPath) throws IOException, URISyntaxException, CoreException {
        Bundle bundle = Platform.getBundle((String)TEST_BUNDLE);
        URI fileUri = this.getFileUri(bundle.getEntry(String.valueOf(testDataPath) + filePath));
        File file = testProject.getOrCreateFile(testIProject, String.valueOf(destinationPath) + fileUri.lastSegment());
        CompareGitTestCase.copyFile((File)this.toFile(fileUri), (File)file);
        return testProject.getIFile(testIProject, file);
    }

    private URI getFileUri(URL bundleUrl) throws IOException {
        URL fileLocation = FileLocator.toFileURL((URL)bundleUrl);
        return URI.createFileURI((String)fileLocation.getPath());
    }

    private File toFile(URI fileUri) throws URISyntaxException {
        return new File(fileUri.toFileString());
    }
}

