/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.mergeviewer.item;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.io.IOException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.AbstractTableOrTreeMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.fullcomparison.data.identifier.IdentifierMatchInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MergeViewerItemTest {
    private static IdentifierMatchInputData inputData = new IdentifierMatchInputData();
    private static final ComposedAdapterFactory fAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final AbstractTableOrTreeMergeViewer.ElementComparer ec = new AbstractTableOrTreeMergeViewer.ElementComparer();
    private static Comparison comparison;

    @BeforeClass
    public static void beforeClass() throws IOException {
        fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        Resource leftResource = inputData.getExtlibraryLeft();
        Resource rightResource = inputData.getExtlibraryRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftResource, (Notifier)rightResource, null);
        EMFCompare.Builder comparisonBuilder = EMFCompare.builder();
        EMFCompareBuilderConfigurator.createDefault().configure(comparisonBuilder);
        comparison = comparisonBuilder.build().compare((IComparisonScope)scope);
    }

    @Test
    public void test2WayRefContainmentMultiValued() throws IOException {
        EList differences = comparison.getDifferences();
        Predicate titledItem = EMFComparePredicates.removedFromReference((String)"extlibrary", (String)"eClassifiers", (String)"extlibrary.TitledItem");
        Diff titledItemDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)titledItem);
        EObject titledItemValue = (EObject)MergeViewerUtil.getDiffValue((Diff)titledItemDiff);
        Match titledItemMatch = comparison.getMatch(titledItemValue);
        MergeViewerItem.Container titledItemMVI = new MergeViewerItem.Container(comparison, titledItemDiff, titledItemMatch, IMergeViewer.MergeViewerSide.LEFT, (AdapterFactory)fAdapterFactory);
        Assert.assertEquals((Object)titledItemMVI.getLeft(), null);
        Assert.assertEquals((Object)titledItemMVI.getRight(), (Object)titledItemValue);
        Assert.assertTrue((boolean)titledItemMVI.isInsertionPoint());
        IMergeViewerItem[] children = titledItemMVI.getChildren(null, null);
        Assert.assertTrue((children.length == 1 ? 1 : 0) != 0);
        Predicate title = EMFComparePredicates.removedFromReference((String)"extlibrary.TitledItem", (String)"eStructuralFeatures", (String)"extlibrary.TitledItem.title");
        Diff titleDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)title);
        IMergeViewerItem titleMVI = children[0];
        Assert.assertEquals((Object)titleDiff, (Object)titleMVI.getDiff());
        Assert.assertEquals((Object)titleMVI.getLeft(), null);
        Assert.assertEquals((Object)titleMVI.getRight(), (Object)MergeViewerUtil.getDiffValue((Diff)titleDiff));
        Assert.assertTrue((boolean)titleMVI.isInsertionPoint());
        Assert.assertEquals((Object)titleMVI.getSide(), (Object)IMergeViewer.MergeViewerSide.LEFT);
        Assert.assertTrue((boolean)this.ec.equals((Object)titleMVI.getParent(), (Object)titledItemMVI));
        titledItemMVI = new MergeViewerItem.Container(comparison, titledItemDiff, titledItemMatch, IMergeViewer.MergeViewerSide.RIGHT, (AdapterFactory)fAdapterFactory);
        Assert.assertEquals((Object)titledItemMVI.getLeft(), null);
        Assert.assertEquals((Object)titledItemMVI.getRight(), (Object)titledItemValue);
        Assert.assertFalse((boolean)titledItemMVI.isInsertionPoint());
        children = titledItemMVI.getChildren(null, null);
        Assert.assertTrue((children.length == 1 ? 1 : 0) != 0);
        title = EMFComparePredicates.removedFromReference((String)"extlibrary.TitledItem", (String)"eStructuralFeatures", (String)"extlibrary.TitledItem.title");
        titleDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)title);
        titleMVI = children[0];
        Assert.assertEquals((Object)titleDiff, (Object)titleMVI.getDiff());
        Assert.assertEquals((Object)titleMVI.getLeft(), null);
        Assert.assertEquals((Object)titleMVI.getRight(), (Object)MergeViewerUtil.getDiffValue((Diff)titleDiff));
        Assert.assertFalse((boolean)titleMVI.isInsertionPoint());
        Assert.assertEquals((Object)titleMVI.getSide(), (Object)IMergeViewer.MergeViewerSide.RIGHT);
        Assert.assertTrue((boolean)this.ec.equals((Object)titleMVI.getParent(), (Object)titledItemMVI));
    }

    @Test
    public void test2WayRefNonContainmentMultiValued() throws IOException {
        EList differences = comparison.getDifferences();
        Predicate periodcial = EMFComparePredicates.removedFromReference((String)"extlibrary", (String)"eClassifiers", (String)"extlibrary.Periodical");
        Diff periodicalDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)periodcial);
        EObject periodicalValue = (EObject)MergeViewerUtil.getDiffValue((Diff)periodicalDiff);
        Match periodicalMatch = comparison.getMatch(periodicalValue);
        Predicate item = EMFComparePredicates.removedFromReference((String)"extlibrary.Periodical", (String)"eSuperTypes", (String)"extlibrary.Item");
        Diff itemDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)item);
        MergeViewerItem itemMVI = new MergeViewerItem(comparison, itemDiff, periodicalMatch, IMergeViewer.MergeViewerSide.LEFT, (AdapterFactory)fAdapterFactory);
        Assert.assertEquals((Object)itemMVI.getLeft(), null);
        Assert.assertEquals((Object)itemMVI.getRight(), (Object)periodicalValue);
        Assert.assertTrue((boolean)itemMVI.isInsertionPoint());
        Assert.assertEquals((Object)itemDiff, (Object)itemMVI.getDiff());
        itemMVI = new MergeViewerItem(comparison, itemDiff, periodicalMatch, IMergeViewer.MergeViewerSide.RIGHT, (AdapterFactory)fAdapterFactory);
        Assert.assertEquals((Object)itemMVI.getLeft(), null);
        Assert.assertEquals((Object)itemMVI.getRight(), (Object)periodicalValue);
        Assert.assertFalse((boolean)itemMVI.isInsertionPoint());
        Assert.assertEquals((Object)itemDiff, (Object)itemMVI.getDiff());
    }
}

