/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.generalizationSet;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.uml2.internal.GeneralizationSetChange;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.generalizationSet.data.GeneralizationSetInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.UMLPackage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AddGeneralizationSetTest
extends AbstractUMLTest {
    private GeneralizationSetInputData input = new GeneralizationSetInputData();

    @BeforeClass
    public static void setupClass() {
        AddGeneralizationSetTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        AddGeneralizationSetTest.resetRegistries();
    }

    @Test
    public void testA10UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testA11UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testA10UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testA11UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
    }

    private void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)6L, (long)differences.size());
        Predicate addGeneralizationSetDescription = null;
        Predicate<? super Diff> addRefGeneralizationSetInClass2Description = null;
        Predicate<? super Diff> addRefGeneralizationSetInClass0Description = null;
        Predicate<? super Diff> addRefGeneralizationInGeneralizationSetDescription1 = null;
        Predicate<? super Diff> addRefGeneralizationInGeneralizationSetDescription2 = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addGeneralizationSetDescription = EMFComparePredicates.removed((String)"model.GeneralizationSet_Class2_Class0");
            addRefGeneralizationSetInClass2Description = AddGeneralizationSetTest.removedFromReference1("model.Class2.Class1", "generalizationSet", "model.GeneralizationSet_Class2_Class0", (EStructuralFeature)UMLPackage.Literals.GENERALIZATION__GENERAL);
            addRefGeneralizationSetInClass0Description = AddGeneralizationSetTest.removedFromReference1("model.Class0.Class1", "generalizationSet", "model.GeneralizationSet_Class2_Class0", (EStructuralFeature)UMLPackage.Literals.GENERALIZATION__GENERAL);
            addRefGeneralizationInGeneralizationSetDescription1 = AddGeneralizationSetTest.removedFromReference2("model.GeneralizationSet_Class2_Class0", "generalization", "model.Class0.Class1", (EStructuralFeature)UMLPackage.Literals.GENERALIZATION__GENERAL);
            addRefGeneralizationInGeneralizationSetDescription2 = AddGeneralizationSetTest.removedFromReference2("model.GeneralizationSet_Class2_Class0", "generalization", "model.Class2.Class1", (EStructuralFeature)UMLPackage.Literals.GENERALIZATION__GENERAL);
        } else {
            addGeneralizationSetDescription = EMFComparePredicates.added((String)"model.GeneralizationSet_Class2_Class0");
            addRefGeneralizationSetInClass2Description = AddGeneralizationSetTest.addedToReference1("model.Class2.Class1", "generalizationSet", "model.GeneralizationSet_Class2_Class0", (EStructuralFeature)UMLPackage.Literals.GENERALIZATION__GENERAL);
            addRefGeneralizationSetInClass0Description = AddGeneralizationSetTest.addedToReference1("model.Class0.Class1", "generalizationSet", "model.GeneralizationSet_Class2_Class0", (EStructuralFeature)UMLPackage.Literals.GENERALIZATION__GENERAL);
            addRefGeneralizationInGeneralizationSetDescription1 = AddGeneralizationSetTest.addedToReference2("model.GeneralizationSet_Class2_Class0", "generalization", "model.Class0.Class1", (EStructuralFeature)UMLPackage.Literals.GENERALIZATION__GENERAL);
            addRefGeneralizationInGeneralizationSetDescription2 = AddGeneralizationSetTest.addedToReference2("model.GeneralizationSet_Class2_Class0", "generalization", "model.Class2.Class1", (EStructuralFeature)UMLPackage.Literals.GENERALIZATION__GENERAL);
        }
        Diff addGeneralizationSet = (Diff)Iterators.find(differences.iterator(), (Predicate)addGeneralizationSetDescription);
        Diff addRefGeneralizationSetInClass0 = (Diff)Iterators.find(differences.iterator(), addRefGeneralizationSetInClass0Description);
        Diff addRefGeneralizationSetInClass2 = (Diff)Iterators.find(differences.iterator(), addRefGeneralizationSetInClass2Description);
        Diff addRefGeneralizationInGeneralizationSet1 = (Diff)Iterators.find(differences.iterator(), addRefGeneralizationInGeneralizationSetDescription1);
        Diff addRefGeneralizationInGeneralizationSet2 = (Diff)Iterators.find(differences.iterator(), addRefGeneralizationInGeneralizationSetDescription2);
        Assert.assertNotNull((Object)addGeneralizationSet);
        Assert.assertNotNull((Object)addRefGeneralizationSetInClass0);
        Assert.assertNotNull((Object)addRefGeneralizationSetInClass2);
        Assert.assertNotNull((Object)addRefGeneralizationInGeneralizationSet1);
        Assert.assertNotNull((Object)addRefGeneralizationInGeneralizationSet2);
        Assert.assertEquals((long)1L, (long)AddGeneralizationSetTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(GeneralizationSetChange.class)));
        Diff addUMLGeneralizationSet = null;
        addUMLGeneralizationSet = kind.equals((Object)AbstractUMLTest.TestKind.ADD) ? (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(GeneralizationSetChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))) : (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(GeneralizationSetChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        Assert.assertNotNull((Object)addUMLGeneralizationSet);
        Assert.assertEquals((long)5L, (long)addUMLGeneralizationSet.getRefinedBy().size());
        Assert.assertTrue((boolean)addUMLGeneralizationSet.getRefinedBy().contains((Object)addRefGeneralizationInGeneralizationSet1));
        Assert.assertTrue((boolean)addUMLGeneralizationSet.getRefinedBy().contains((Object)addRefGeneralizationInGeneralizationSet2));
        Assert.assertTrue((boolean)addUMLGeneralizationSet.getRefinedBy().contains((Object)addGeneralizationSet));
        Assert.assertTrue((boolean)addUMLGeneralizationSet.getRefinedBy().contains((Object)addRefGeneralizationSetInClass0));
        Assert.assertTrue((boolean)addUMLGeneralizationSet.getRefinedBy().contains((Object)addRefGeneralizationSetInClass2));
        if (kind.equals((Object)AbstractUMLTest.TestKind.ADD)) {
            Assert.assertEquals((long)1L, (long)addRefGeneralizationInGeneralizationSet1.getRequires().size());
            Assert.assertTrue((boolean)addRefGeneralizationInGeneralizationSet1.getRequires().contains((Object)addGeneralizationSet));
            Assert.assertEquals((long)1L, (long)addRefGeneralizationInGeneralizationSet2.getRequires().size());
            Assert.assertTrue((boolean)addRefGeneralizationInGeneralizationSet2.getRequires().contains((Object)addGeneralizationSet));
            Assert.assertEquals((long)1L, (long)addRefGeneralizationSetInClass0.getRequires().size());
            Assert.assertTrue((boolean)addRefGeneralizationSetInClass0.getRequires().contains((Object)addGeneralizationSet));
            Assert.assertEquals((long)1L, (long)addRefGeneralizationSetInClass2.getRequires().size());
            Assert.assertTrue((boolean)addRefGeneralizationSetInClass2.getRequires().contains((Object)addGeneralizationSet));
            Assert.assertEquals((long)0L, (long)addGeneralizationSet.getRequires().size());
            Assert.assertEquals((long)0L, (long)addUMLGeneralizationSet.getRequires().size());
        } else {
            Assert.assertEquals((long)0L, (long)addRefGeneralizationInGeneralizationSet1.getRequires().size());
            Assert.assertEquals((long)0L, (long)addRefGeneralizationInGeneralizationSet2.getRequires().size());
            Assert.assertEquals((long)0L, (long)addRefGeneralizationSetInClass0.getRequires().size());
            Assert.assertEquals((long)0L, (long)addRefGeneralizationSetInClass2.getRequires().size());
            Assert.assertEquals((long)4L, (long)addGeneralizationSet.getRequires().size());
            Assert.assertTrue((boolean)addGeneralizationSet.getRequires().contains((Object)addRefGeneralizationInGeneralizationSet1));
            Assert.assertTrue((boolean)addGeneralizationSet.getRequires().contains((Object)addRefGeneralizationInGeneralizationSet2));
            Assert.assertTrue((boolean)addGeneralizationSet.getRequires().contains((Object)addRefGeneralizationSetInClass0));
            Assert.assertTrue((boolean)addGeneralizationSet.getRequires().contains((Object)addRefGeneralizationSetInClass2));
            Assert.assertEquals((long)0L, (long)addUMLGeneralizationSet.getRequires().size());
        }
        Assert.assertEquals((long)2L, (long)comparison.getEquivalences().size());
        Assert.assertNotNull((Object)addRefGeneralizationInGeneralizationSet1.getEquivalence());
        Assert.assertEquals((long)2L, (long)addRefGeneralizationInGeneralizationSet1.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)addRefGeneralizationInGeneralizationSet1.getEquivalence().getDifferences().contains((Object)addRefGeneralizationSetInClass0));
        Assert.assertNotNull((Object)addRefGeneralizationInGeneralizationSet2.getEquivalence());
        Assert.assertEquals((long)2L, (long)addRefGeneralizationInGeneralizationSet2.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)addRefGeneralizationInGeneralizationSet2.getEquivalence().getDifferences().contains((Object)addRefGeneralizationSetInClass2));
        this.testIntersections(comparison);
    }

    public static Predicate<? super Diff> removedFromReference1(String qualifiedName, String referenceName, String removedQualifiedName, EStructuralFeature featureDelegate) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.onEObject((String)qualifiedName, (EStructuralFeature)featureDelegate), EMFComparePredicates.referenceValueMatch((String)referenceName, (String)removedQualifiedName, (boolean)true)});
    }

    public static Predicate<? super Diff> removedFromReference2(String qualifiedName, String referenceName, String removedQualifiedName, EStructuralFeature featureDelegate) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.referenceValueMatch((String)referenceName, (String)removedQualifiedName, (boolean)true, (EStructuralFeature)featureDelegate)});
    }

    public static Predicate<? super Diff> addedToReference1(String qualifiedName, String referenceName, String removedQualifiedName, EStructuralFeature featureDelegate) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.onEObject((String)qualifiedName, (EStructuralFeature)featureDelegate), EMFComparePredicates.referenceValueMatch((String)referenceName, (String)removedQualifiedName, (boolean)true)});
    }

    public static Predicate<? super Diff> addedToReference2(String qualifiedName, String referenceName, String removedQualifiedName, EStructuralFeature featureDelegate) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.onEObject((String)qualifiedName), EMFComparePredicates.referenceValueMatch((String)referenceName, (String)removedQualifiedName, (boolean)true, (EStructuralFeature)featureDelegate)});
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

