/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.contentmergeviewer.util;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.IMergeRunnable;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.RedoAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.UndoAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeRunnableImpl;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.CachingDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.tests.nodes.Node;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Before;

public abstract class AbstractReverseActionTest {
    private IMerger.Registry mergerRegistry;
    private IMergeRunnable mergeRunnable;
    private ICompareEditingDomain editingDomain;

    public abstract DefaultComparisonScope getScope();

    public ICompareEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public IMerger.Registry getMergerRegistry() {
        return this.mergerRegistry;
    }

    public IMergeRunnable getMergeRunnable() {
        return this.mergeRunnable;
    }

    @Before
    public void setUp() throws IOException {
        this.mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        this.editingDomain = null;
    }

    protected EList<Node> getNodes(Resource resource) {
        EObject container = (EObject)resource.getContents().get(0);
        if (container instanceof Node) {
            return ((Node)container).getContainmentRef1();
        }
        return null;
    }

    protected void mergeDiffsRightToLeft(List<? extends Diff> differences) {
        this.mergeDiffs(differences, false);
    }

    protected void mergeDiffsLeftToRight(List<? extends Diff> differences) {
        this.mergeDiffs(differences, true);
    }

    protected void mergeDiffs(List<? extends Diff> differences, boolean leftToRight) {
        if (this.editingDomain == null) {
            this.editingDomain = EMFCompareEditingDomain.create((Notifier)this.getScope().getLeft(), (Notifier)this.getScope().getRight(), (Notifier)this.getScope().getOrigin());
        }
        this.initMergeRunnable(leftToRight);
        ICompareCopyCommand command = this.getEditingDomain().createCopyCommand(differences, leftToRight, this.getMergerRegistry(), this.getMergeRunnable());
        this.getEditingDomain().getCommandStack().execute((Command)command);
    }

    protected void initMergeRunnable(boolean leftToRight) {
        CachingDiffRelationshipComputer computer = new CachingDiffRelationshipComputer(this.getMergerRegistry());
        MergeMode mergeMode = leftToRight ? MergeMode.LEFT_TO_RIGHT : MergeMode.RIGHT_TO_LEFT;
        this.mergeRunnable = new MergeRunnableImpl(true, true, mergeMode, (IDiffRelationshipComputer)computer);
    }

    protected void undo() {
        UndoAction undoAction = new UndoAction(this.getEditingDomain());
        undoAction.run();
    }

    protected void redo() {
        RedoAction redoAction = new RedoAction(this.getEditingDomain());
        redoAction.run();
    }
}

