/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements;

import org.eclipse.emf.compare.ide.ui.tests.framework.EMFCompareTestConfiguration;
import org.eclipse.emf.compare.ide.ui.tests.framework.ResolutionStrategyID;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.GitTestSupport;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements.AbstractGitStatement;
import org.junit.runners.model.FrameworkMethod;

public class GitTestStatement
extends AbstractGitStatement {
    private final String path;

    public GitTestStatement(Object testObject, FrameworkMethod test, ResolutionStrategyID resolutionStrategy, EMFCompareTestConfiguration configuration, String path) {
        super(testObject, test, resolutionStrategy, configuration);
        this.path = this.normalizePath(path);
    }

    public void evaluate() throws Throwable {
        this.setEMFComparePreferences();
        GitTestSupport gitTestsSupport = new GitTestSupport();
        try {
            gitTestsSupport.setup();
            gitTestsSupport.createRepositoryFromPath(this.test.getMethod().getDeclaringClass(), this.path);
            Object[] parameters = this.createParameters(this.test.getMethod(), gitTestsSupport);
            this.test.invokeExplosively(this.testObject, parameters);
        }
        finally {
            this.restoreEMFComparePreferences();
            gitTestsSupport.tearDown();
        }
    }
}

