/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMergeOptionAware;
import org.eclipse.emf.compare.merge.IMerger;

public class DelegatingMerger {
    private final IMerger merger;
    private final IMergeCriterion criterion;

    public DelegatingMerger(IMerger merger, IMergeCriterion criterion) {
        this.merger = (IMerger)Preconditions.checkNotNull((Object)merger);
        this.criterion = criterion;
    }

    public void copyRightToLeft(Diff target, Monitor monitor) {
        if (this.merger instanceof IMergeOptionAware) {
            Map<Object, Object> options = ((IMergeOptionAware)((Object)this.merger)).getMergeOptions();
            Object oldCriterion = options.get("merge.criterion");
            try {
                options.put("merge.criterion", this.criterion);
                this.merger.copyRightToLeft(target, monitor);
            }
            finally {
                ((IMergeOptionAware)((Object)this.merger)).getMergeOptions().put("merge.criterion", oldCriterion);
            }
        } else {
            this.merger.copyRightToLeft(target, monitor);
        }
    }

    public void copyLeftToRight(Diff target, Monitor monitor) {
        if (this.merger instanceof IMergeOptionAware) {
            Map<Object, Object> options = ((IMergeOptionAware)((Object)this.merger)).getMergeOptions();
            Object oldCriterion = options.get("merge.criterion");
            try {
                options.put("merge.criterion", this.criterion);
                this.merger.copyLeftToRight(target, monitor);
            }
            finally {
                ((IMergeOptionAware)((Object)this.merger)).getMergeOptions().put("merge.criterion", oldCriterion);
            }
        } else {
            this.merger.copyLeftToRight(target, monitor);
        }
    }

    public IMerger getMerger() {
        return this.merger;
    }

    public IMergeCriterion getCriterion() {
        return this.criterion;
    }
}

