/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.provider.spec.CompareItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.data.nodes.addconflict.NodesAddConflictInputData;
import org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.provider.AbstractTestTreeNodeItemProviderAdapter;
import org.eclipse.emf.compare.tests.edit.data.ResourceScopeProvider;
import org.eclipse.emf.compare.tests.edit.data.ecore.a1.EcoreA1InputData;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.tree.TreePackage;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicDifferenceGroupImpl
extends AbstractTestTreeNodeItemProviderAdapter {
    private AdapterFactoryItemDelegator itemDelegator;

    @Override
    public void before() throws IOException {
        super.before();
        ArrayList factories = Lists.newArrayList();
        factories.add(new CompareItemProviderAdapterFactorySpec());
        factories.add(this.treeItemProviderAdapterFactory);
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory((Collection)factories);
        this.itemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
    }

    @Test
    public void testEcoreA1() throws IOException {
        Comparison comparison = TestBasicDifferenceGroupImpl.getComparison((ResourceScopeProvider)new EcoreA1InputData());
        ECrossReferenceAdapter crossReferenceAdapter = new ECrossReferenceAdapter(){

            protected boolean isIncluded(EReference eReference) {
                return eReference == TreePackage.Literals.TREE_NODE__DATA;
            }
        };
        BasicDifferenceGroupImpl group = new BasicDifferenceGroupImpl(comparison, Predicates.alwaysTrue(), crossReferenceAdapter);
        List roots = group.getChildren();
        Assert.assertEquals((long)2L, (long)roots.size());
        TreeNode node = (TreeNode)roots.get(0);
        this.checkText(node, "extlibrary");
        EList extlibraryChildren = node.getChildren();
        Assert.assertEquals((long)10L, (long)extlibraryChildren.size());
        node = (TreeNode)extlibraryChildren.get(0);
        this.checkText(node, "Book -> CirculatingItem");
        EList bookChildren = node.getChildren();
        Assert.assertEquals((long)3L, (long)bookChildren.size());
        node = (TreeNode)bookChildren.get(0);
        this.checkText(node, "TitledItem [eSuperTypes add]");
        Assert.assertEquals((long)0L, (long)node.getChildren().size());
        TreeNode titleNode = (TreeNode)bookChildren.get(1);
        this.checkText(titleNode, "title : EString");
        EList bookTitleChildren = titleNode.getChildren();
        Assert.assertEquals((long)2L, (long)bookTitleChildren.size());
        node = (TreeNode)bookTitleChildren.get(0);
        this.checkText(node, "title : EString [eStructuralFeatures delete]");
        Assert.assertEquals((long)0L, (long)node.getChildren().size());
        node = (TreeNode)bookTitleChildren.get(1);
        this.checkText(node, "EString [java.lang.String] [eType unset]");
        Assert.assertEquals((long)0L, (long)node.getChildren().size());
        TreeNode subtitleNode = (TreeNode)bookChildren.get(2);
        this.checkText(subtitleNode, "subtitle : EString");
        Assert.assertEquals((long)0L, (long)node.getChildren().size());
        EList bookSubtitleChildren = subtitleNode.getChildren();
        Assert.assertEquals((long)2L, (long)bookSubtitleChildren.size());
        node = (TreeNode)bookSubtitleChildren.get(0);
        this.checkText(node, "subtitle : EString [eStructuralFeatures add]");
        Assert.assertEquals((long)0L, (long)node.getChildren().size());
        node = (TreeNode)bookSubtitleChildren.get(1);
        this.checkText(node, "EString [java.lang.String] [eType set]");
        Assert.assertEquals((long)0L, (long)node.getChildren().size());
        node = (TreeNode)extlibraryChildren.get(1);
        this.checkText(node, "BookCategory");
        Assert.assertEquals((long)4L, (long)node.getChildren().size());
        TreeNode childNode = (TreeNode)node.getChildren().get(0);
        this.checkText(childNode, "Encyclopedia = 3");
        Assert.assertEquals((long)1L, (long)childNode.getChildren().size());
        this.checkText((TreeNode)childNode.getChildren().get(0), "Encyclopedia = 3 [eLiterals add]");
        childNode = (TreeNode)node.getChildren().get(1);
        this.checkText(childNode, "Dictionary = 4");
        Assert.assertEquals((long)1L, (long)childNode.getChildren().size());
        this.checkText((TreeNode)childNode.getChildren().get(0), "Dictionary = 4 [eLiterals add]");
        childNode = (TreeNode)node.getChildren().get(2);
        this.checkText(childNode, "Manga = 3");
        Assert.assertEquals((long)1L, (long)childNode.getChildren().size());
        this.checkText((TreeNode)childNode.getChildren().get(0), "Manga = 3 [eLiterals add]");
        childNode = (TreeNode)node.getChildren().get(3);
        this.checkText(childNode, "Manhwa = 5");
        Assert.assertEquals((long)1L, (long)childNode.getChildren().size());
        this.checkText((TreeNode)childNode.getChildren().get(0), "Manhwa = 5 [eLiterals add]");
        node = (TreeNode)extlibraryChildren.get(2);
        this.checkText(node, "Borrowable");
        Assert.assertEquals((long)1L, (long)node.getChildren().size());
        this.checkText((TreeNode)node.getChildren().get(0), "Borrowable [name changed]");
        node = (TreeNode)extlibraryChildren.get(3);
        this.checkText(node, "AudioVisualItem -> CirculatingItem");
        Assert.assertEquals((long)3L, (long)node.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(0);
        this.checkText(childNode, "TitledItem [eSuperTypes add]");
        Assert.assertEquals((long)0L, (long)childNode.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(1);
        this.checkText(childNode, "title : EString");
        Assert.assertEquals((long)2L, (long)childNode.getChildren().size());
        this.checkText((TreeNode)childNode.getChildren().get(0), "title : EString [eStructuralFeatures delete]");
        this.checkText((TreeNode)childNode.getChildren().get(1), "EString [java.lang.String] [eType unset]");
        childNode = (TreeNode)node.getChildren().get(2);
        this.checkText(childNode, "length : EInt");
        Assert.assertEquals((long)2L, (long)childNode.getChildren().size());
        this.checkText((TreeNode)childNode.getChildren().get(0), "length [name changed]");
        this.checkText((TreeNode)childNode.getChildren().get(1), "minutes [name changed]");
        node = (TreeNode)extlibraryChildren.get(4);
        this.checkText(node, "BookOnTape -> AudioVisualItem");
        Assert.assertEquals((long)1L, (long)node.getChildren().size());
        node = (TreeNode)node.getChildren().get(0);
        this.checkText(node, "reader : Person");
        Assert.assertEquals((long)4L, (long)node.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(0);
        this.checkText(childNode, "reader : Person [eStructuralFeatures delete]");
        Assert.assertEquals((long)0L, (long)childNode.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(1);
        this.checkText(childNode, "reader : Person [eStructuralFeatures delete]");
        Assert.assertEquals((long)0L, (long)childNode.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(2);
        this.checkText(childNode, "Person -> Addressable [eType unset]");
        Assert.assertEquals((long)0L, (long)childNode.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(3);
        this.checkText(childNode, "Person -> Addressable [eType unset]");
        Assert.assertEquals((long)0L, (long)childNode.getChildren().size());
        node = (TreeNode)extlibraryChildren.get(5);
        this.checkText(node, "Person -> Addressable");
        Assert.assertEquals((long)3L, (long)node.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(0);
        this.checkText(childNode, "fullName : EString");
        Assert.assertEquals((long)2L, (long)childNode.getChildren().size());
        TreeNode childNode2 = (TreeNode)childNode.getChildren().get(0);
        this.checkText(childNode2, "fullName : EString [eStructuralFeatures add]");
        Assert.assertEquals((long)0L, (long)childNode2.getChildren().size());
        childNode2 = (TreeNode)childNode.getChildren().get(1);
        this.checkText(childNode2, "EString [java.lang.String] [eType set]");
        Assert.assertEquals((long)0L, (long)childNode2.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(1);
        this.checkText(childNode, "firstName : EString");
        Assert.assertEquals((long)2L, (long)childNode.getChildren().size());
        childNode2 = (TreeNode)childNode.getChildren().get(0);
        this.checkText(childNode2, "firstName : EString [eStructuralFeatures delete]");
        Assert.assertEquals((long)0L, (long)childNode2.getChildren().size());
        childNode2 = (TreeNode)childNode.getChildren().get(1);
        this.checkText(childNode2, "EString [java.lang.String] [eType unset]");
        Assert.assertEquals((long)0L, (long)childNode2.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(2);
        this.checkText(childNode, "lastName : EString");
        Assert.assertEquals((long)3L, (long)childNode.getChildren().size());
        childNode2 = (TreeNode)childNode.getChildren().get(0);
        this.checkText(childNode2, "lastName : EString [eStructuralFeatures delete]");
        Assert.assertEquals((long)0L, (long)childNode2.getChildren().size());
        childNode2 = (TreeNode)childNode.getChildren().get(1);
        this.checkText(childNode2, "EString [java.lang.String] [eType unset]");
        Assert.assertEquals((long)0L, (long)childNode2.getChildren().size());
        childNode2 = (TreeNode)childNode.getChildren().get(2);
        this.checkText(childNode2, "familyName [name set]");
        Assert.assertEquals((long)0L, (long)childNode2.getChildren().size());
        node = (TreeNode)extlibraryChildren.get(6);
        this.checkText(node, "Magazine -> CirculatingItem");
        Assert.assertEquals((long)4L, (long)node.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(0);
        this.checkText(childNode, "Magazine -> CirculatingItem [eClassifiers add]");
        Assert.assertEquals((long)0L, (long)childNode.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(1);
        this.checkText(childNode, "CirculatingItem -> Item, Borrowable [eSuperTypes add]");
        Assert.assertEquals((long)0L, (long)childNode.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(2);
        this.checkText(childNode, "title : EString");
        Assert.assertEquals((long)2L, (long)childNode.getChildren().size());
        childNode2 = (TreeNode)childNode.getChildren().get(0);
        this.checkText(childNode2, "title : EString [eStructuralFeatures add]");
        Assert.assertEquals((long)0L, (long)childNode2.getChildren().size());
        childNode2 = (TreeNode)childNode.getChildren().get(1);
        this.checkText(childNode2, "EString [java.lang.String] [eType set]");
        Assert.assertEquals((long)0L, (long)childNode2.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(3);
        this.checkText(childNode, "pages : EInt");
        Assert.assertEquals((long)2L, (long)childNode.getChildren().size());
        childNode2 = (TreeNode)childNode.getChildren().get(0);
        this.checkText(childNode2, "pages : EInt [eStructuralFeatures add]");
        Assert.assertEquals((long)0L, (long)childNode2.getChildren().size());
        childNode2 = (TreeNode)childNode.getChildren().get(1);
        this.checkText(childNode2, "EInt [int] [eType set]");
        Assert.assertEquals((long)0L, (long)childNode2.getChildren().size());
        node = (TreeNode)extlibraryChildren.get(7);
        this.checkText(node, "Periodical -> Item");
        Assert.assertEquals((long)5L, (long)node.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(0);
        this.checkText(childNode, "Periodical -> Item [eClassifiers delete]");
        Assert.assertEquals((long)0L, (long)childNode.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(1);
        this.checkText(childNode, "TitledItem [eSuperTypes add]");
        Assert.assertEquals((long)0L, (long)childNode.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(2);
        this.checkText(childNode, "Item [eSuperTypes delete]");
        Assert.assertEquals((long)0L, (long)childNode.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(3);
        this.checkText(childNode, "issuesPerYear : EInt");
        Assert.assertEquals((long)2L, (long)childNode.getChildren().size());
        childNode2 = (TreeNode)childNode.getChildren().get(0);
        this.checkText(childNode2, "issuesPerYear : EInt [eStructuralFeatures delete]");
        Assert.assertEquals((long)0L, (long)childNode2.getChildren().size());
        childNode2 = (TreeNode)childNode.getChildren().get(1);
        this.checkText(childNode2, "EInt [int] [eType unset]");
        Assert.assertEquals((long)0L, (long)childNode2.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(4);
        this.checkText(childNode, "title : EString");
        Assert.assertEquals((long)4L, (long)childNode.getChildren().size());
        this.checkText((TreeNode)childNode.getChildren().get(0), "title : EString [eStructuralFeatures delete]");
        this.checkText((TreeNode)childNode.getChildren().get(1), "title : EString [eStructuralFeatures delete]");
        this.checkText((TreeNode)childNode.getChildren().get(2), "EString [java.lang.String] [eType unset]");
        this.checkText((TreeNode)childNode.getChildren().get(3), "EString [java.lang.String] [eType unset]");
        node = (TreeNode)extlibraryChildren.get(8);
        this.checkText(node, "Magazine -> Periodical");
        Assert.assertEquals((long)2L, (long)node.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(0);
        this.checkText(childNode, "Magazine -> Periodical [eClassifiers add]");
        Assert.assertEquals((long)0L, (long)childNode.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(1);
        this.checkText(childNode, "Periodical -> Item, TitledItem [eSuperTypes add]");
        Assert.assertEquals((long)0L, (long)childNode.getChildren().size());
        node = (TreeNode)extlibraryChildren.get(9);
        this.checkText(node, "TitledItem");
        Assert.assertEquals((long)2L, (long)node.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(0);
        this.checkText(childNode, "TitledItem [eClassifiers add]");
        Assert.assertEquals((long)0L, (long)childNode.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(1);
        this.checkText(childNode, "title : EString");
        Assert.assertEquals((long)2L, (long)childNode.getChildren().size());
        childNode2 = (TreeNode)childNode.getChildren().get(0);
        this.checkText(childNode2, "title : EString [eStructuralFeatures add]");
        Assert.assertEquals((long)0L, (long)childNode2.getChildren().size());
        childNode2 = (TreeNode)childNode.getChildren().get(1);
        this.checkText(childNode2, "EString [java.lang.String] [eType set]");
        Assert.assertEquals((long)0L, (long)childNode2.getChildren().size());
    }

    @Test
    public void testNodesRealAddConflict() throws IOException {
        Comparison comparison = TestBasicDifferenceGroupImpl.getComparison(new NodesAddConflictInputData());
        ECrossReferenceAdapter crossReferenceAdapter = new ECrossReferenceAdapter(){

            protected boolean isIncluded(EReference eReference) {
                return eReference == TreePackage.Literals.TREE_NODE__DATA;
            }
        };
        BasicDifferenceGroupImpl group = new BasicDifferenceGroupImpl(comparison, Predicates.alwaysTrue(), crossReferenceAdapter);
        List roots = group.getChildren();
        Assert.assertEquals((long)2L, (long)roots.size());
        TreeNode node = (TreeNode)roots.get(0);
        this.checkText(node, "Node root");
        EList nodeRootChildren = node.getChildren();
        Assert.assertEquals((long)3L, (long)nodeRootChildren.size());
        node = (TreeNode)nodeRootChildren.get(0);
        this.checkText(node, "Node A");
        EList aChildren = node.getChildren();
        Assert.assertEquals((long)1L, (long)aChildren.size());
        TreeNode nodeC1 = (TreeNode)aChildren.get(0);
        this.checkText(nodeC1, "Node C");
        Assert.assertEquals((long)4L, (long)nodeC1.getChildren().size());
        node = (TreeNode)nodeC1.getChildren().get(0);
        this.checkText(node, "Node C [containmentRef1 add]");
        node = (TreeNode)nodeC1.getChildren().get(1);
        this.checkText(node, "Node D");
        Assert.assertEquals((long)2L, (long)node.getChildren().size());
        TreeNode childNode = (TreeNode)node.getChildren().get(0);
        this.checkText(childNode, "Node D [containmentRef1 add]");
        childNode = (TreeNode)node.getChildren().get(1);
        this.checkText(childNode, "Node D [containmentRef1 add]");
        node = (TreeNode)nodeC1.getChildren().get(2);
        this.checkText(node, "Node E");
        Assert.assertEquals((long)1L, (long)node.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(0);
        this.checkText(childNode, "Node E [containmentRef1 add]");
        node = (TreeNode)nodeC1.getChildren().get(3);
        this.checkText(node, "Node F");
        Assert.assertEquals((long)1L, (long)node.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(0);
        this.checkText(childNode, "Node F [containmentRef1 add]");
        node = (TreeNode)nodeRootChildren.get(1);
        this.checkText(node, "Node B");
        Assert.assertEquals((long)1L, (long)node.getChildren().size());
        node = (TreeNode)node.getChildren().get(0);
        this.checkText(node, "Node C");
        Assert.assertEquals((long)1L, (long)node.getChildren().size());
        node = (TreeNode)node.getChildren().get(0);
        this.checkText(node, "Node C [containmentRef1 add]");
        Assert.assertEquals((long)0L, (long)node.getChildren().size());
        node = (TreeNode)nodeRootChildren.get(2);
        this.checkText(node, "Node G");
        Assert.assertEquals((long)1L, (long)node.getChildren().size());
        node = (TreeNode)node.getChildren().get(0);
        this.checkText(node, "Node H");
        Assert.assertEquals((long)1L, (long)node.getChildren().size());
        node = (TreeNode)node.getChildren().get(0);
        this.checkText(node, "Node H [containmentRef1 add]");
        Assert.assertEquals((long)0L, (long)node.getChildren().size());
        node = (TreeNode)roots.get(1);
        this.checkText(node, "left.nodes <-> right.nodes (ancestor.nodes)");
        Assert.assertEquals((long)0L, (long)node.getChildren().size());
    }

    protected void checkText(TreeNode childNode, String expected) {
        Assert.assertEquals((Object)expected, (Object)this.itemDelegator.getText((Object)childNode));
    }
}

