/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.tests.unit.AbstractGitLogicalModelTest;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jgit.api.Status;
import org.junit.Assert;
import org.junit.Test;

public class GitLogicalMergeTest
extends AbstractGitLogicalModelTest {
    private void setUp001() throws Exception {
        this.file2.delete();
        this.resource2 = null;
        EPackage root = this.createPackage(null, "P1");
        this.createClass(root, "C1");
        EClass class2 = this.createClass(root, "C2");
        this.resource1.getContents().add((Object)root);
        this.save(new Resource[]{this.resource1});
        this.repository.addAllAndCommit("initial-commit");
        this.repository.createBranch("refs/heads/master", "refs/heads/branch");
        root.getEClassifiers().remove((Object)class2);
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "master-commit", this.file1);
        this.repository.checkoutBranch("refs/heads/branch");
        this.reload(new Resource[]{this.resource1});
        EClass class1 = (EClass)this.findObject(this.resource1, "C1");
        class2 = (EClass)this.findObject(this.resource1, "C2");
        class1.getESuperTypes().add((Object)class2);
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "branch-commit", this.file1);
        this.repository.checkoutBranch("refs/heads/master");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        this.compareBothDirectionsAndCheck(this.iFile1, "refs/heads/master", "refs/heads/branch", 1, 1, 1);
    }

    private void setUp002() throws Exception {
        this.file2.delete();
        this.resource2 = null;
        EPackage root = this.createPackage(null, "P1");
        EClass class1 = this.createClass(root, "C1");
        this.createClass(root, "C2");
        this.resource1.getContents().add((Object)root);
        this.save(new Resource[]{this.resource1});
        this.repository.addAllAndCommit("initial-commit");
        this.repository.createBranch("refs/heads/master", "refs/heads/branch");
        class1.setName("C10");
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "master-commit", this.file1);
        this.repository.checkoutBranch("refs/heads/branch");
        this.reload(new Resource[]{this.resource1});
        class1 = (EClass)this.findObject(this.resource1, "C1");
        EClass class2 = (EClass)this.findObject(this.resource1, "C2");
        class1.getESuperTypes().add((Object)class2);
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "branch-commit", this.file1);
        this.repository.checkoutBranch("refs/heads/master");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        this.compareBothDirectionsAndCheck(this.iFile1, "refs/heads/master", "refs/heads/branch", 0, 1, 1);
    }

    private void setUp003() throws Exception {
        this.file2.delete();
        this.resource2 = null;
        EPackage root = this.createPackage(null, "P1");
        this.createClass(root, "C1");
        EClass class2 = this.createClass(root, "C2");
        this.resource1.getContents().add((Object)root);
        this.save(new Resource[]{this.resource1});
        this.repository.addAllAndCommit("initial-commit");
        this.repository.createBranch("refs/heads/master", "refs/heads/branch");
        root.getEClassifiers().remove((Object)class2);
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "master-commit", this.file1);
        this.repository.checkoutBranch("refs/heads/branch");
        this.reload(new Resource[]{this.resource1});
        class2 = (EClass)this.findObject(this.resource1, "C2");
        class2.getEPackage().getEClassifiers().remove((Object)class2);
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "branch-commit", this.file1);
        this.repository.checkoutBranch("refs/heads/master");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        this.compareBothDirectionsAndCheck(this.iFile1, "refs/heads/master", "refs/heads/branch", 1, 1, 1);
    }

    private void setUp004() throws Exception {
        EPackage root1 = this.createPackage(null, "P1");
        this.createClass(root1, "C1");
        EClass class2 = this.createClass(root1, "C2");
        this.resource1.getContents().add((Object)root1);
        EPackage root2 = this.createPackage(null, "P2");
        this.createClass(root2, "C3");
        this.createClass(root2, "C4");
        this.resource2.getContents().add((Object)root2);
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAllAndCommit("initial-commit");
        this.repository.createBranch("refs/heads/master", "refs/heads/branch");
        root1.getEClassifiers().remove((Object)class2);
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "master-commit", this.file1);
        this.repository.checkoutBranch("refs/heads/branch");
        this.reload(new Resource[]{this.resource1, this.resource2});
        EClass class1 = (EClass)this.findObject(this.resource1, "C1");
        class2 = (EClass)this.findObject(this.resource1, "C2");
        EClass class4 = (EClass)this.findObject(this.resource2, "C4");
        class1.getESuperTypes().add((Object)class2);
        class4.getEPackage().getEClassifiers().remove((Object)class4);
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAndCommit(this.project, "branch-commit", this.file1, this.file2);
        this.repository.checkoutBranch("refs/heads/master");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        this.compareBothDirectionsAndCheck(this.iFile1, "refs/heads/master", "refs/heads/branch", 1, 1, 1);
        this.compareBothDirectionsAndCheck(this.iFile2, "refs/heads/master", "refs/heads/branch", 0, 0, 1);
    }

    private void setUp005() throws Exception {
        EPackage root1 = this.createPackage(null, "P1");
        this.createClass(root1, "C1");
        EClass class2 = this.createClass(root1, "C2");
        this.resource1.getContents().add((Object)root1);
        EPackage root2 = this.createPackage(null, "P2");
        this.createClass(root2, "C3");
        EClass class4 = this.createClass(root2, "C4");
        this.resource2.getContents().add((Object)root2);
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAllAndCommit("initial-commit");
        this.repository.createBranch("refs/heads/master", "refs/heads/branch");
        root1.getEClassifiers().remove((Object)class2);
        root2.getEClassifiers().remove((Object)class4);
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAndCommit(this.project, "master-commit", this.file1, this.file2);
        this.repository.checkoutBranch("refs/heads/branch");
        this.reload(new Resource[]{this.resource1, this.resource2});
        EClass class1 = (EClass)this.findObject(this.resource1, "C1");
        class2 = (EClass)this.findObject(this.resource1, "C2");
        EClass class3 = (EClass)this.findObject(this.resource2, "C3");
        class4 = (EClass)this.findObject(this.resource2, "C4");
        class1.getESuperTypes().add((Object)class2);
        class3.getESuperTypes().add((Object)class4);
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAndCommit(this.project, "branch-commit", this.file1, this.file2);
        this.repository.checkoutBranch("refs/heads/master");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        this.compareBothDirectionsAndCheck(this.iFile1, "refs/heads/master", "refs/heads/branch", 1, 1, 1);
        this.compareBothDirectionsAndCheck(this.iFile2, "refs/heads/master", "refs/heads/branch", 1, 1, 1);
    }

    private void setUp006() throws Exception {
        EPackage root1 = this.createPackage(null, "P1");
        EClass class1 = this.createClass(root1, "C1");
        this.createClass(root1, "C2");
        this.resource1.getContents().add((Object)root1);
        EPackage root2 = this.createPackage(null, "P2");
        EClass class3 = this.createClass(root2, "C3");
        this.createClass(root2, "C4");
        this.resource2.getContents().add((Object)root2);
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAllAndCommit("initial-commit");
        this.repository.createBranch("refs/heads/master", "refs/heads/branch");
        class1.setName("C10");
        class3.setName("C30");
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAndCommit(this.project, "master-commit", this.file1, this.file2);
        this.repository.checkoutBranch("refs/heads/branch");
        this.reload(new Resource[]{this.resource1, this.resource2});
        class1 = (EClass)this.findObject(this.resource1, "C1");
        EClass class2 = (EClass)this.findObject(this.resource1, "C2");
        class3 = (EClass)this.findObject(this.resource2, "C3");
        EClass class4 = (EClass)this.findObject(this.resource2, "C4");
        class1.getESuperTypes().add((Object)class2);
        class3.getESuperTypes().add((Object)class4);
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAndCommit(this.project, "branch-commit", this.file1, this.file2);
        this.repository.checkoutBranch("refs/heads/master");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        this.compareBothDirectionsAndCheck(this.iFile1, "refs/heads/master", "refs/heads/branch", 0, 1, 1);
        this.compareBothDirectionsAndCheck(this.iFile2, "refs/heads/master", "refs/heads/branch", 0, 1, 1);
    }

    private void setUp007() throws Exception {
        EPackage root1 = this.createPackage(null, "P1");
        this.createClass(root1, "C1");
        this.createClass(root1, "C2");
        this.resource1.getContents().add((Object)root1);
        EPackage root2 = this.createPackage(null, "P2");
        EClass class3 = this.createClass(root2, "C3");
        this.createClass(root2, "C4");
        this.resource2.getContents().add((Object)root2);
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAllAndCommit("initial-commit");
        this.repository.createBranch("refs/heads/master", "refs/heads/branch");
        root2.getEClassifiers().remove((Object)class3);
        this.save(new Resource[]{this.resource2});
        this.repository.addAndCommit(this.project, "master-commit", this.file2);
        this.repository.checkoutBranch("refs/heads/branch");
        this.reload(new Resource[]{this.resource1, this.resource2});
        EClass class1 = (EClass)this.findObject(this.resource1, "C1");
        class3 = (EClass)this.findObject(this.resource2, "C3");
        class1.getESuperTypes().add((Object)class3);
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "branch-commit", this.file1);
        this.repository.checkoutBranch("refs/heads/master");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        this.compareBothDirectionsAndCheck(this.iFile1, "refs/heads/master", "refs/heads/branch", 1, 1, 1);
        this.compareADirectionAndCheck(this.iFile2, "refs/heads/master", "refs/heads/branch", 0, 1, 0);
        this.compareADirectionAndCheck(this.iFile2, "refs/heads/branch", "refs/heads/master", 1, 1, 1);
        this.repository.checkoutBranch("refs/heads/master");
    }

    private void setUp007_reverse() throws Exception {
        EPackage root1 = this.createPackage(null, "P1");
        EClass class1 = this.createClass(root1, "C1");
        this.createClass(root1, "C2");
        this.resource1.getContents().add((Object)root1);
        EPackage root2 = this.createPackage(null, "P2");
        this.createClass(root2, "C3");
        this.createClass(root2, "C4");
        this.resource2.getContents().add((Object)root2);
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAllAndCommit("initial-commit");
        this.repository.createBranch("refs/heads/master", "refs/heads/branch");
        root1.getEClassifiers().remove((Object)class1);
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "master-commit", this.file1);
        this.repository.checkoutBranch("refs/heads/branch");
        this.reload(new Resource[]{this.resource1, this.resource2});
        EClass class3 = (EClass)this.findObject(this.resource2, "C3");
        class1 = (EClass)this.findObject(this.resource1, "C1");
        class3.getESuperTypes().add((Object)class1);
        this.save(new Resource[]{this.resource2});
        this.repository.addAndCommit(this.project, "branch-commit", this.file2);
        this.repository.checkoutBranch("refs/heads/master");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        this.compareADirectionAndCheck(this.iFile1, "refs/heads/master", "refs/heads/branch", 0, 1, 0);
        this.compareADirectionAndCheck(this.iFile1, "refs/heads/branch", "refs/heads/master", 1, 1, 1);
        this.compareBothDirectionsAndCheck(this.iFile2, "refs/heads/master", "refs/heads/branch", 1, 1, 1);
    }

    private void setUp008() throws Exception {
        EPackage root1 = this.createPackage(null, "P1");
        EClass class1 = this.createClass(root1, "C1");
        this.createClass(root1, "C2");
        this.resource1.getContents().add((Object)root1);
        EPackage root2 = this.createPackage(null, "P2");
        EClass class3 = this.createClass(root2, "C3");
        this.createClass(root2, "C4");
        this.resource2.getContents().add((Object)root2);
        class1.getESuperTypes().add((Object)class3);
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAllAndCommit("initial-commit");
        this.repository.createBranch("refs/heads/master", "refs/heads/branch");
        class1.setName("C10");
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "master-commit", this.file1);
        this.repository.checkoutBranch("refs/heads/branch");
        this.reload(new Resource[]{this.resource1, this.resource2});
        class1 = (EClass)this.findObject(this.resource1, "C1");
        EClass class4 = (EClass)this.findObject(this.resource2, "C4");
        class1.getESuperTypes().clear();
        class1.getESuperTypes().add((Object)class4);
        class4.setName("C40");
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAndCommit(this.project, "branch-commit", this.file1, this.file2);
        this.repository.checkoutBranch("refs/heads/master");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        this.compareBothDirectionsAndCheck(this.iFile1, "refs/heads/master", "refs/heads/branch", 0, 1, 3);
        this.compareBothDirectionsAndCheck(this.iFile2, "refs/heads/master", "refs/heads/branch", 0, 1, 3);
    }

    private void setUp009() throws Exception {
        EPackage root1 = this.createPackage(null, "P1");
        EClass class1 = this.createClass(root1, "C1");
        this.createClass(root1, "C2");
        this.resource1.getContents().add((Object)root1);
        EPackage root2 = this.createPackage(null, "P2");
        EClass class3 = this.createClass(root2, "C3");
        this.createClass(root2, "C4");
        this.resource2.getContents().add((Object)root2);
        class1.getESuperTypes().add((Object)class3);
        this.save(new Resource[]{this.resource1, this.resource2});
        this.repository.addAllAndCommit("initial-commit");
        this.repository.createBranch("refs/heads/master", "refs/heads/branch");
        class1.setName("C10");
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "master-commit", this.file1);
        this.repository.checkoutBranch("refs/heads/branch");
        this.reload(new Resource[]{this.resource1, this.resource2});
        EClass class4 = (EClass)this.findObject(this.resource2, "C4");
        class4.setName("C40");
        this.save(new Resource[]{this.resource2});
        this.repository.addAndCommit(this.project, "branch-commit", this.file2);
        this.repository.checkoutBranch("refs/heads/master");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        this.compareBothDirectionsAndCheck(this.iFile1, "refs/heads/master", "refs/heads/branch", 0, 1, 1);
        this.compareBothDirectionsAndCheck(this.iFile2, "refs/heads/master", "refs/heads/branch", 0, 1, 1);
    }

    @Test
    public void merge001_text() throws Exception {
        this.setUp001();
        this.repository.mergeTextual("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file1)));
        try {
            this.reload(new Resource[]{this.resource1});
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void merge001_logical() throws Exception {
        this.setUp001();
        this.repository.mergeLogical("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file1)));
        this.reload(new Resource[]{this.resource1});
        Assert.assertTrue((boolean)this.resource1.getErrors().isEmpty());
        Assert.assertNotNull((Object)this.findObject(this.resource1, "C1"));
        Assert.assertNull((Object)this.findObject(this.resource1, "C2"));
    }

    @Test
    public void merge002_text() throws Exception {
        this.setUp002();
        this.repository.mergeTextual("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file1)));
        try {
            this.reload(new Resource[]{this.resource1});
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void merge002_logical() throws Exception {
        this.setUp002();
        this.repository.mergeLogical("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        this.reload(new Resource[]{this.resource1});
        Assert.assertTrue((boolean)this.resource1.getErrors().isEmpty());
        EPackage pack = (EPackage)this.findObject(this.resource1, "P1");
        EClass class1 = (EClass)this.findObject(this.resource1, "C10");
        EClass class2 = (EClass)this.findObject(this.resource1, "C2");
        Assert.assertNotNull((Object)pack);
        Assert.assertNotNull((Object)class1);
        Assert.assertNotNull((Object)class2);
        Assert.assertTrue((boolean)class1.getESuperTypes().contains((Object)class2));
        Assert.assertEquals((long)2L, (long)pack.getEClassifiers().size());
    }

    @Test
    public void merge003_text() throws Exception {
        this.setUp003();
        this.repository.mergeTextual("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        this.reload(new Resource[]{this.resource1});
        Assert.assertTrue((boolean)this.resource1.getErrors().isEmpty());
        EPackage pack = (EPackage)this.findObject(this.resource1, "P1");
        EClass class1 = (EClass)this.findObject(this.resource1, "C1");
        Assert.assertNotNull((Object)pack);
        Assert.assertNotNull((Object)class1);
        Assert.assertEquals((long)1L, (long)pack.getEClassifiers().size());
    }

    @Test
    public void merge003_logical() throws Exception {
        this.setUp003();
        this.repository.mergeLogical("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        this.reload(new Resource[]{this.resource1});
        Assert.assertTrue((boolean)this.resource1.getErrors().isEmpty());
        EPackage pack = (EPackage)this.findObject(this.resource1, "P1");
        EClass class1 = (EClass)this.findObject(this.resource1, "C1");
        Assert.assertNotNull((Object)pack);
        Assert.assertNotNull((Object)class1);
        Assert.assertEquals((long)1L, (long)pack.getEClassifiers().size());
    }

    @Test
    public void merge004_text() throws Exception {
        this.setUp004();
        this.repository.mergeTextual("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file1)));
        Assert.assertFalse((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file2)));
        this.unload(new Resource[]{this.resource1, this.resource2});
        try {
            this.reload(new Resource[]{this.resource1});
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reload(new Resource[]{this.resource2});
        Assert.assertTrue((boolean)this.resource2.getErrors().isEmpty());
        EPackage pack = (EPackage)this.findObject(this.resource2, "P2");
        EClass class3 = (EClass)this.findObject(this.resource2, "C3");
        Assert.assertNotNull((Object)pack);
        Assert.assertNotNull((Object)class3);
        Assert.assertEquals((long)1L, (long)pack.getEClassifiers().size());
    }

    @Test
    public void merge004_logical() throws Exception {
        this.setUp004();
        this.repository.mergeLogical("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file1)));
        Assert.assertFalse((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file2)));
        this.unload(new Resource[]{this.resource1, this.resource2});
        this.reload(new Resource[]{this.resource1});
        Assert.assertTrue((boolean)this.resource1.getErrors().isEmpty());
        Assert.assertNotNull((Object)this.findObject(this.resource1, "C1"));
        Assert.assertNull((Object)this.findObject(this.resource1, "C2"));
        this.reload(new Resource[]{this.resource2});
        Assert.assertTrue((boolean)this.resource2.getErrors().isEmpty());
        EPackage pack = (EPackage)this.findObject(this.resource2, "P2");
        EClass class3 = (EClass)this.findObject(this.resource2, "C3");
        Assert.assertNotNull((Object)pack);
        Assert.assertNotNull((Object)class3);
        Assert.assertEquals((long)1L, (long)pack.getEClassifiers().size());
    }

    @Test
    public void merge005_text() throws Exception {
        this.setUp005();
        this.repository.mergeTextual("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file1)));
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file2)));
        this.unload(new Resource[]{this.resource1, this.resource2});
        try {
            this.reload(new Resource[]{this.resource1});
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.reload(new Resource[]{this.resource2});
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void merge005_logical() throws Exception {
        this.setUp005();
        this.repository.mergeLogical("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file1)));
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file2)));
        this.unload(new Resource[]{this.resource1, this.resource2});
        this.reload(new Resource[]{this.resource1});
        Assert.assertTrue((boolean)this.resource1.getErrors().isEmpty());
        Assert.assertNotNull((Object)this.findObject(this.resource1, "C1"));
        Assert.assertNull((Object)this.findObject(this.resource1, "C2"));
        this.reload(new Resource[]{this.resource2});
        Assert.assertTrue((boolean)this.resource2.getErrors().isEmpty());
        Assert.assertNotNull((Object)this.findObject(this.resource2, "C3"));
        Assert.assertNull((Object)this.findObject(this.resource2, "C4"));
    }

    @Test
    public void merge006_text() throws Exception {
        this.setUp006();
        this.repository.mergeTextual("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file1)));
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file2)));
        this.unload(new Resource[]{this.resource1, this.resource2});
        try {
            this.reload(new Resource[]{this.resource1});
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.reload(new Resource[]{this.resource2});
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void merge006_logical() throws Exception {
        this.setUp006();
        this.repository.mergeLogical("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        this.reload(new Resource[]{this.resource1, this.resource2});
        Assert.assertTrue((boolean)this.resource1.getErrors().isEmpty());
        EPackage pack1 = (EPackage)this.findObject(this.resource1, "P1");
        EClass class1 = (EClass)this.findObject(this.resource1, "C10");
        EClass class2 = (EClass)this.findObject(this.resource1, "C2");
        Assert.assertNotNull((Object)pack1);
        Assert.assertNotNull((Object)class1);
        Assert.assertNotNull((Object)class2);
        Assert.assertTrue((boolean)class1.getESuperTypes().contains((Object)class2));
        Assert.assertEquals((long)2L, (long)pack1.getEClassifiers().size());
        Assert.assertTrue((boolean)this.resource2.getErrors().isEmpty());
        EPackage pack2 = (EPackage)this.findObject(this.resource2, "P2");
        EClass class3 = (EClass)this.findObject(this.resource2, "C30");
        EClass class4 = (EClass)this.findObject(this.resource2, "C4");
        Assert.assertNotNull((Object)pack2);
        Assert.assertNotNull((Object)class3);
        Assert.assertNotNull((Object)class4);
        Assert.assertTrue((boolean)class3.getESuperTypes().contains((Object)class4));
        Assert.assertEquals((long)2L, (long)pack2.getEClassifiers().size());
    }

    @Test
    public void merge007_text() throws Exception {
        this.setUp007();
        this.repository.mergeTextual("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        this.unload(new Resource[]{this.resource1, this.resource2});
        this.reload(new Resource[]{this.resource1});
        Assert.assertTrue((boolean)this.resource1.getErrors().isEmpty());
        EClass class1 = (EClass)this.findObject(this.resource1, "C1");
        EClass superType = (EClass)class1.getESuperTypes().get(0);
        Assert.assertTrue((boolean)superType.eIsProxy());
        Resource res2 = this.resource1.getResourceSet().getResource(this.resource2.getURI(), false);
        Assert.assertNotNull((Object)res2);
        Assert.assertSame((Object)superType, (Object)EcoreUtil.resolve((EObject)superType, (ResourceSet)this.resource1.getResourceSet()));
        this.reload(new Resource[]{this.resource2});
        EPackage pack2 = (EPackage)this.findObject(this.resource2, "P2");
        EClass class4 = (EClass)this.findObject(this.resource2, "C4");
        Assert.assertNotNull((Object)pack2);
        Assert.assertNotNull((Object)class4);
        Assert.assertEquals((long)1L, (long)pack2.getEClassifiers().size());
    }

    @Test
    public void merge007_logical() throws Exception {
        this.setUp007();
        this.repository.mergeLogical("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file1)));
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file2)));
        this.unload(new Resource[]{this.resource1, this.resource2});
        this.reload(new Resource[]{this.resource1});
        Assert.assertTrue((boolean)this.resource1.getErrors().isEmpty());
        EClass class1 = (EClass)this.findObject(this.resource1, "C1");
        Assert.assertNotNull((Object)class1);
        Assert.assertTrue((boolean)class1.getESuperTypes().isEmpty());
        Assert.assertNotNull((Object)this.findObject(this.resource1, "C2"));
        this.reload(new Resource[]{this.resource2});
        Assert.assertTrue((boolean)this.resource2.getErrors().isEmpty());
        Assert.assertNull((Object)this.findObject(this.resource2, "C3"));
        Assert.assertNotNull((Object)this.findObject(this.resource2, "C4"));
    }

    @Test
    public void merge007_reverse_text() throws Exception {
        this.setUp007_reverse();
        this.repository.mergeTextual("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        this.unload(new Resource[]{this.resource1, this.resource2});
        this.reload(new Resource[]{this.resource1});
        EPackage pack1 = (EPackage)this.findObject(this.resource1, "P1");
        EClass class2 = (EClass)this.findObject(this.resource1, "C2");
        Assert.assertNotNull((Object)pack1);
        Assert.assertNotNull((Object)class2);
        Assert.assertEquals((long)1L, (long)pack1.getEClassifiers().size());
        this.reload(new Resource[]{this.resource2});
        Assert.assertTrue((boolean)this.resource2.getErrors().isEmpty());
        EClass class3 = (EClass)this.findObject(this.resource2, "C3");
        EClass superType = (EClass)class3.getESuperTypes().get(0);
        Assert.assertTrue((boolean)superType.eIsProxy());
        Resource res1 = this.resource2.getResourceSet().getResource(this.resource1.getURI(), false);
        Assert.assertNotNull((Object)res1);
        Assert.assertSame((Object)superType, (Object)EcoreUtil.resolve((EObject)superType, (ResourceSet)this.resource2.getResourceSet()));
    }

    @Test
    public void merge007_reverse_logical() throws Exception {
        this.setUp007_reverse();
        this.repository.mergeLogical("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file1)));
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file2)));
        this.unload(new Resource[]{this.resource1, this.resource2});
        this.reload(new Resource[]{this.resource1});
        Assert.assertTrue((boolean)this.resource1.getErrors().isEmpty());
        Assert.assertNull((Object)this.findObject(this.resource1, "C1"));
        Assert.assertNotNull((Object)this.findObject(this.resource1, "C2"));
        this.reload(new Resource[]{this.resource2});
        Assert.assertTrue((boolean)this.resource2.getErrors().isEmpty());
        EClass class3 = (EClass)this.findObject(this.resource2, "C3");
        Assert.assertNotNull((Object)class3);
        Assert.assertTrue((boolean)class3.getESuperTypes().isEmpty());
        Assert.assertNotNull((Object)this.findObject(this.resource2, "C4"));
    }

    @Test
    public void merge008_text() throws Exception {
        this.setUp008();
        this.repository.mergeTextual("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().contains(this.repository.getRepoRelativePath(this.file1)));
        this.unload(new Resource[]{this.resource1, this.resource2});
        try {
            this.reload(new Resource[]{this.resource1});
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reload(new Resource[]{this.resource2});
        Assert.assertTrue((boolean)this.resource2.getErrors().isEmpty());
        EPackage pack2 = (EPackage)this.findObject(this.resource2, "P2");
        Assert.assertNotNull((Object)this.findObject(this.resource2, "C3"));
        Assert.assertNotNull((Object)this.findObject(this.resource2, "C40"));
        Assert.assertEquals((long)2L, (long)pack2.getEClassifiers().size());
    }

    @Test
    public void merge008_logical() throws Exception {
        this.setUp008();
        this.repository.mergeLogical("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        this.reload(new Resource[]{this.resource1, this.resource2});
        Assert.assertTrue((boolean)this.resource1.getErrors().isEmpty());
        EClass class1 = (EClass)this.findObject(this.resource1, "C10");
        Assert.assertNotNull((Object)class1);
        Assert.assertNotNull((Object)this.findObject(this.resource1, "C2"));
        Assert.assertTrue((boolean)this.resource2.getErrors().isEmpty());
        EClass class4 = (EClass)this.findObject(this.resource2, "C40");
        Assert.assertNotNull((Object)this.findObject(this.resource2, "C3"));
        Assert.assertNotNull((Object)class4);
        Assert.assertTrue((boolean)class1.getESuperTypes().contains((Object)class4));
        Assert.assertEquals((long)1L, (long)class1.getESuperTypes().size());
    }

    @Test
    public void merge009_text() throws Exception {
        this.setUp009();
        this.repository.mergeTextual("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        this.reload(new Resource[]{this.resource1, this.resource2});
        Assert.assertTrue((boolean)this.resource1.getErrors().isEmpty());
        EPackage pack1 = (EPackage)this.findObject(this.resource1, "P1");
        EClass class1 = (EClass)this.findObject(this.resource1, "C10");
        Assert.assertNotNull((Object)class1);
        Assert.assertNotNull((Object)this.findObject(this.resource1, "C2"));
        Assert.assertEquals((long)2L, (long)pack1.getEClassifiers().size());
        Assert.assertTrue((boolean)this.resource2.getErrors().isEmpty());
        EPackage pack2 = (EPackage)this.findObject(this.resource2, "P2");
        EClass class3 = (EClass)this.findObject(this.resource2, "C3");
        Assert.assertNotNull((Object)class3);
        Assert.assertNotNull((Object)this.findObject(this.resource2, "C40"));
        Assert.assertEquals((long)2L, (long)pack2.getEClassifiers().size());
        Assert.assertTrue((boolean)class1.getESuperTypes().contains((Object)class3));
        Assert.assertEquals((long)1L, (long)class1.getESuperTypes().size());
    }

    @Test
    public void merge009_logical() throws Exception {
        this.setUp009();
        this.repository.mergeLogical("refs/heads/branch");
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        this.reload(new Resource[]{this.resource1, this.resource2});
        Assert.assertTrue((boolean)this.resource1.getErrors().isEmpty());
        EPackage pack1 = (EPackage)this.findObject(this.resource1, "P1");
        EClass class1 = (EClass)this.findObject(this.resource1, "C10");
        Assert.assertNotNull((Object)class1);
        Assert.assertNotNull((Object)this.findObject(this.resource1, "C2"));
        Assert.assertEquals((long)2L, (long)pack1.getEClassifiers().size());
        Assert.assertTrue((boolean)this.resource2.getErrors().isEmpty());
        EPackage pack2 = (EPackage)this.findObject(this.resource2, "P2");
        EClass class3 = (EClass)this.findObject(this.resource2, "C3");
        Assert.assertNotNull((Object)class3);
        Assert.assertNotNull((Object)this.findObject(this.resource2, "C40"));
        Assert.assertEquals((long)2L, (long)pack2.getEClassifiers().size());
        Assert.assertTrue((boolean)class1.getESuperTypes().contains((Object)class3));
        Assert.assertEquals((long)1L, (long)class1.getESuperTypes().size());
    }

    private void compareADirectionAndCheck(IFile file, String source, String destination, int expectedConflicts, int diffsInSource, int diffsInDestination) throws Exception {
        this.repository.checkoutBranch(source);
        Comparison compareResult = this.compare(source, destination, file);
        Assert.assertEquals((long)expectedConflicts, (long)compareResult.getConflicts().size());
        GitLogicalMergeTest.assertDiffCount((List<Diff>)compareResult.getDifferences(), diffsInSource, diffsInDestination);
    }
}

