/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.merge.data.IndividualDiffInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class ExtensionMergeTest {
    private IndividualDiffInputData input = new IndividualDiffInputData();

    @Test
    public void testInstantiationMerger() throws IOException {
        Resource left = this.input.getAttributeMonoChangeLeft();
        Resource right = this.input.getAttributeMonoChangeRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedAttribute";
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.changedAttribute((String)"root.origin", (String)"singleValuedAttribute", (Object)"originValue", (Object)"leftValue")));
        IMerger merger = ExtensionMergeTest.getMerger(IMerger.RegistryImpl.createStandaloneInstance(), diff, AbstractMerger.class);
        merger.copyLeftToRight(diff, null);
        EObject originNode = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)originNode);
        EStructuralFeature feature = originNode.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"leftValue", (Object)originNode.eGet(feature));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    public static IMerger getMerger(IMerger.Registry registry, Diff diff, Class<? extends IMerger> expectedMerger) {
        IMerger merger = registry.getHighestRankingMerger(diff);
        Assert.assertNotNull((String)("No merger has been found for the diff: " + diff), (Object)merger);
        Assert.assertTrue((String)"The found merger is not the expexted Merger", (boolean)expectedMerger.isInstance(merger));
        return merger;
    }

    private EObject getNodeNamed(Resource res, String name) {
        TreeIterator iterator = EcoreUtil.getAllProperContents((Resource)res, (boolean)false);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            EStructuralFeature nameFeature = next.eClass().getEStructuralFeature("name");
            if (nameFeature == null || !name.equals(next.eGet(nameFeature))) continue;
            return next;
        }
        return null;
    }
}

