/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.utils;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.graph.PruningIterator;
import org.eclipse.emf.compare.internal.utils.Graph;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractGraphTest<E> {
    protected abstract E toType(String var1);

    protected abstract IGraph<E> createGraph();

    @Test
    public void testBuildSubGraph() {
        IGraph<E> graph = this.createGraph();
        graph.addChildren(this.toType("A"), (Set)ImmutableSet.of(this.toType("B"), this.toType("C"), this.toType("D")));
        graph.addChildren(this.toType("C"), (Set)ImmutableSet.of(this.toType("E")));
        graph.addChildren(this.toType("D"), (Set)ImmutableSet.of(this.toType("F")));
        Set subgraph = graph.getSubgraphContaining(this.toType("D"), (Set)ImmutableSet.of(this.toType("C")));
        Assert.assertEquals((long)4L, (long)subgraph.size());
        Assert.assertTrue((boolean)subgraph.containsAll(Lists.newArrayList((Object[])new Object[]{this.toType("A"), this.toType("B"), this.toType("D"), this.toType("F")})));
    }

    @Test
    public void testPrune() {
        IGraph<E> graph = this.createGraph();
        graph.addChildren(this.toType("A"), (Set)ImmutableSet.of(this.toType("B")));
        graph.addChildren(this.toType("B"), (Set)ImmutableSet.of(this.toType("C")));
        graph.addChildren(this.toType("C"), (Set)ImmutableSet.of(this.toType("B")));
        PruningIterator iterator = graph.breadthFirstIterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.prune();
        }
    }

    @Test
    public void testBreadthFirstIteration() {
        IGraph<E> graph = this.createGraph();
        graph.addChildren(this.toType("A"), (Set)ImmutableSet.of(this.toType("B"), this.toType("C")));
        graph.addChildren(this.toType("B"), (Set)ImmutableSet.of(this.toType("D")));
        graph.addChildren(this.toType("C"), (Set)ImmutableSet.of(this.toType("E"), this.toType("F")));
        graph.addChildren(this.toType("I"), (Set)ImmutableSet.of(this.toType("G")));
        graph.addChildren(this.toType("G"), (Set)ImmutableSet.of(this.toType("F"), this.toType("H")));
        graph.addChildren(this.toType("J"), (Set)ImmutableSet.of(this.toType("K"), this.toType("L")));
        graph.addChildren(this.toType("L"), (Set)ImmutableSet.of(this.toType("M"), this.toType("N")));
        HashSet firstThree = Sets.newHashSet((Object[])new Object[]{this.toType("A"), this.toType("I"), this.toType("J")});
        HashSet nextFive = Sets.newHashSet((Object[])new Object[]{this.toType("B"), this.toType("C"), this.toType("G"), this.toType("K"), this.toType("L")});
        HashSet finalSix = Sets.newHashSet((Object[])new Object[]{this.toType("D"), this.toType("E"), this.toType("F"), this.toType("H"), this.toType("M"), this.toType("N")});
        PruningIterator iterator = graph.breadthFirstIterator();
        Assert.assertTrue((boolean)firstThree.remove(iterator.next()));
        Assert.assertTrue((boolean)firstThree.remove(iterator.next()));
        Assert.assertTrue((boolean)firstThree.remove(iterator.next()));
        Assert.assertTrue((boolean)firstThree.isEmpty());
        Assert.assertTrue((boolean)nextFive.remove(iterator.next()));
        Assert.assertTrue((boolean)nextFive.remove(iterator.next()));
        Assert.assertTrue((boolean)nextFive.remove(iterator.next()));
        Assert.assertTrue((boolean)nextFive.remove(iterator.next()));
        Assert.assertTrue((boolean)nextFive.remove(iterator.next()));
        Assert.assertTrue((boolean)nextFive.isEmpty());
        Assert.assertTrue((boolean)finalSix.remove(iterator.next()));
        Assert.assertTrue((boolean)finalSix.remove(iterator.next()));
        Assert.assertTrue((boolean)finalSix.remove(iterator.next()));
        Assert.assertTrue((boolean)finalSix.remove(iterator.next()));
        Assert.assertTrue((boolean)finalSix.remove(iterator.next()));
        Assert.assertTrue((boolean)finalSix.remove(iterator.next()));
        Assert.assertTrue((boolean)finalSix.isEmpty());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testBreadthFirstIteration_MultipleParents() {
        IGraph<E> graph = this.createGraph();
        graph.addChildren(this.toType("A"), (Set)ImmutableSet.of(this.toType("C")));
        graph.addChildren(this.toType("B"), (Set)ImmutableSet.of(this.toType("C")));
        PruningIterator breadthFirstIterator = graph.breadthFirstIterator();
        Assert.assertTrue((boolean)breadthFirstIterator.hasNext());
        Assert.assertEquals(this.toType("A"), (Object)breadthFirstIterator.next());
        Assert.assertTrue((boolean)breadthFirstIterator.hasNext());
        Assert.assertEquals(this.toType("B"), (Object)breadthFirstIterator.next());
        breadthFirstIterator.prune();
        Assert.assertFalse((boolean)breadthFirstIterator.hasNext());
    }

    @Test
    public void testBreadthFirstIteration_MultipleParentsMultipleChildren() {
        IGraph<E> graph = this.createGraph();
        graph.addChildren(this.toType("A"), (Set)ImmutableSet.of(this.toType("C"), this.toType("D"), this.toType("E")));
        graph.addChildren(this.toType("B"), (Set)ImmutableSet.of(this.toType("C"), this.toType("D")));
        PruningIterator breadthFirstIterator = graph.breadthFirstIterator();
        Assert.assertTrue((boolean)breadthFirstIterator.hasNext());
        Assert.assertEquals(this.toType("A"), (Object)breadthFirstIterator.next());
        Assert.assertTrue((boolean)breadthFirstIterator.hasNext());
        Assert.assertEquals(this.toType("B"), (Object)breadthFirstIterator.next());
        breadthFirstIterator.prune();
        Assert.assertTrue((boolean)breadthFirstIterator.hasNext());
        Assert.assertEquals(this.toType("E"), (Object)breadthFirstIterator.next());
        Assert.assertFalse((boolean)breadthFirstIterator.hasNext());
    }

    @Test
    public void testBreadthFirstIteration_PruneMultipleLevels() {
        Graph graph = new Graph();
        graph.addChildren(this.toType("A"), (Set)ImmutableSet.of(this.toType("D"), this.toType("C")));
        graph.addChildren(this.toType("B"), (Set)ImmutableSet.of(this.toType("C")));
        graph.addChildren(this.toType("D"), (Set)ImmutableSet.of(this.toType("E")));
        graph.addChildren(this.toType("C"), (Set)ImmutableSet.of(this.toType("E")));
        PruningIterator breadthFirstIterator = graph.breadthFirstIterator();
        Assert.assertTrue((boolean)breadthFirstIterator.hasNext());
        Assert.assertEquals(this.toType("A"), (Object)breadthFirstIterator.next());
        Assert.assertTrue((boolean)breadthFirstIterator.hasNext());
        Assert.assertEquals(this.toType("B"), (Object)breadthFirstIterator.next());
        breadthFirstIterator.prune();
        Assert.assertTrue((boolean)breadthFirstIterator.hasNext());
        Assert.assertEquals(this.toType("D"), (Object)breadthFirstIterator.next());
        Assert.assertFalse((boolean)breadthFirstIterator.hasNext());
    }

    @Test
    public void testTreeIteration_1() {
        IGraph<E> graph = this.getAcyclicGraph();
        Iterator iteratorOnA = graph.depthFirstIterator(this.toType("A"));
        Assert.assertEquals(this.toType("A"), iteratorOnA.next());
        Assert.assertEquals(this.toType("B"), iteratorOnA.next());
        Assert.assertEquals(this.toType("D"), iteratorOnA.next());
        Assert.assertEquals(this.toType("C"), iteratorOnA.next());
        Assert.assertEquals(this.toType("E"), iteratorOnA.next());
        Assert.assertEquals(this.toType("F"), iteratorOnA.next());
        Assert.assertFalse((boolean)iteratorOnA.hasNext());
    }

    @Test
    public void testTreeIteration_2() {
        IGraph<E> graph = this.getAcyclicGraph();
        Iterator iteratorOnC = graph.depthFirstIterator(this.toType("C"));
        Assert.assertEquals(this.toType("C"), iteratorOnC.next());
        Assert.assertEquals(this.toType("E"), iteratorOnC.next());
        Assert.assertEquals(this.toType("F"), iteratorOnC.next());
        Assert.assertFalse((boolean)iteratorOnC.hasNext());
    }

    @Test
    public void testTreeIteration_3() {
        IGraph<E> graph = this.getAcyclicGraph();
        Iterator iteratorOnI = graph.depthFirstIterator(this.toType("I"));
        Assert.assertEquals(this.toType("I"), iteratorOnI.next());
        Assert.assertEquals(this.toType("G"), iteratorOnI.next());
        Assert.assertEquals(this.toType("F"), iteratorOnI.next());
        Assert.assertEquals(this.toType("H"), iteratorOnI.next());
        Assert.assertFalse((boolean)iteratorOnI.hasNext());
    }

    @Test
    public void testTreeIteration_4() {
        IGraph<E> graph = this.getAcyclicGraph();
        Iterator iteratorOnJ = graph.depthFirstIterator(this.toType("J"));
        Assert.assertEquals(this.toType("J"), iteratorOnJ.next());
        Assert.assertEquals(this.toType("K"), iteratorOnJ.next());
        Assert.assertEquals(this.toType("L"), iteratorOnJ.next());
        Assert.assertEquals(this.toType("M"), iteratorOnJ.next());
        Assert.assertEquals(this.toType("N"), iteratorOnJ.next());
        Assert.assertFalse((boolean)iteratorOnJ.hasNext());
    }

    @Test
    public void testDepthIterationWithCycles_1() {
        IGraph<E> graph = this.getGraphWithCycles();
        Iterator iteratorOnA = graph.depthFirstIterator(this.toType("A"));
        Assert.assertEquals(this.toType("A"), iteratorOnA.next());
        Assert.assertEquals(this.toType("B"), iteratorOnA.next());
        Assert.assertEquals(this.toType("D"), iteratorOnA.next());
        Assert.assertEquals(this.toType("E"), iteratorOnA.next());
        Assert.assertEquals(this.toType("C"), iteratorOnA.next());
        Assert.assertEquals(this.toType("F"), iteratorOnA.next());
        Assert.assertEquals(this.toType("H"), iteratorOnA.next());
        Assert.assertFalse((boolean)iteratorOnA.hasNext());
    }

    @Test
    public void testDepthIterationWithCycles_2() {
        IGraph<E> graph = this.getGraphWithCycles();
        Iterator iteratorOnC = graph.depthFirstIterator(this.toType("C"));
        Assert.assertEquals(this.toType("C"), iteratorOnC.next());
        Assert.assertEquals(this.toType("A"), iteratorOnC.next());
        Assert.assertEquals(this.toType("B"), iteratorOnC.next());
        Assert.assertEquals(this.toType("D"), iteratorOnC.next());
        Assert.assertEquals(this.toType("E"), iteratorOnC.next());
        Assert.assertEquals(this.toType("F"), iteratorOnC.next());
        Assert.assertEquals(this.toType("H"), iteratorOnC.next());
        Assert.assertFalse((boolean)iteratorOnC.hasNext());
    }

    @Test
    public void testDepthIterationWithCycles_3() {
        IGraph<E> graph = this.getGraphWithCycles();
        Iterator iteratorOnI = graph.depthFirstIterator(this.toType("I"));
        Assert.assertEquals(this.toType("I"), iteratorOnI.next());
        Assert.assertEquals(this.toType("G"), iteratorOnI.next());
        Assert.assertEquals(this.toType("F"), iteratorOnI.next());
        Assert.assertEquals(this.toType("H"), iteratorOnI.next());
        Assert.assertFalse((boolean)iteratorOnI.hasNext());
    }

    @Test
    public void testDepthIterationWithCycles_4() {
        IGraph<E> graph = this.getGraphWithCycles();
        Iterator iteratorOnJ = graph.depthFirstIterator(this.toType("J"));
        Assert.assertEquals(this.toType("J"), iteratorOnJ.next());
        Assert.assertEquals(this.toType("K"), iteratorOnJ.next());
        Assert.assertEquals(this.toType("M"), iteratorOnJ.next());
        Assert.assertEquals(this.toType("L"), iteratorOnJ.next());
        Assert.assertEquals(this.toType("N"), iteratorOnJ.next());
        Assert.assertFalse((boolean)iteratorOnJ.hasNext());
    }

    @Test
    public void testBug503035_1() {
        IGraph<E> graph = this.createGraph();
        graph.addChildren(this.toType("A"), (Set)ImmutableSet.of(this.toType("B"), this.toType("C")));
        graph.addChildren(this.toType("B"), (Set)ImmutableSet.of(this.toType("C")));
        graph.addChildren(this.toType("C"), (Set)ImmutableSet.of(this.toType("B")));
        PruningIterator it = graph.breadthFirstIterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(this.toType("A"), it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(this.toType("B"), it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(this.toType("C"), it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testBug503035_2() {
        IGraph<E> graph = this.createGraph();
        graph.addChildren(this.toType("A"), (Set)ImmutableSet.of(this.toType("B"), this.toType("C")));
        graph.addChildren(this.toType("B"), (Set)ImmutableSet.of(this.toType("D"), this.toType("C")));
        graph.addChildren(this.toType("C"), (Set)ImmutableSet.of(this.toType("B")));
        PruningIterator it = graph.breadthFirstIterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(this.toType("A"), it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(this.toType("B"), it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(this.toType("C"), it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(this.toType("D"), it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testBug503035_3() {
        IGraph<E> graph = this.createGraph();
        graph.addChildren(this.toType("A"), (Set)ImmutableSet.of(this.toType("C")));
        graph.addChildren(this.toType("B"), (Set)ImmutableSet.of(this.toType("D")));
        graph.addChildren(this.toType("C"), (Set)ImmutableSet.of(this.toType("D")));
        graph.addChildren(this.toType("D"), (Set)ImmutableSet.of(this.toType("C")));
        PruningIterator it = graph.breadthFirstIterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(this.toType("A"), it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(this.toType("B"), it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(this.toType("C"), it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(this.toType("D"), it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testBug503035_4() {
        IGraph<E> graph = this.createGraph();
        graph.addChildren(this.toType("A"), (Set)ImmutableSet.of(this.toType("B"), this.toType("C"), this.toType("D")));
        graph.addChildren(this.toType("B"), (Set)ImmutableSet.of(this.toType("D")));
        graph.addChildren(this.toType("D"), (Set)ImmutableSet.of(this.toType("B")));
        PruningIterator it = graph.breadthFirstIterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(this.toType("A"), it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(this.toType("B"), it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(this.toType("C"), it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(this.toType("D"), it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    protected IGraph<E> getAcyclicGraph() {
        IGraph<E> graph = this.createGraph();
        graph.addChildren(this.toType("A"), (Set)ImmutableSet.of(this.toType("B"), this.toType("C")));
        graph.addChildren(this.toType("B"), (Set)ImmutableSet.of(this.toType("D")));
        graph.addChildren(this.toType("C"), (Set)ImmutableSet.of(this.toType("E"), this.toType("F")));
        graph.addChildren(this.toType("I"), (Set)ImmutableSet.of(this.toType("G")));
        graph.addChildren(this.toType("G"), (Set)ImmutableSet.of(this.toType("F"), this.toType("H")));
        graph.addChildren(this.toType("J"), (Set)ImmutableSet.of(this.toType("K"), this.toType("L")));
        graph.addChildren(this.toType("L"), (Set)ImmutableSet.of(this.toType("M"), this.toType("N")));
        return graph;
    }

    protected IGraph<E> getGraphWithCycles() {
        IGraph<E> graph = this.createGraph();
        graph.addChildren(this.toType("A"), (Set)ImmutableSet.of(this.toType("B"), this.toType("C")));
        graph.addChildren(this.toType("B"), (Set)ImmutableSet.of(this.toType("D")));
        graph.addChildren(this.toType("D"), (Set)ImmutableSet.of(this.toType("E")));
        graph.addChildren(this.toType("C"), (Set)ImmutableSet.of(this.toType("A"), this.toType("E"), this.toType("F")));
        graph.addChildren(this.toType("I"), (Set)ImmutableSet.of(this.toType("G")));
        graph.addChildren(this.toType("G"), (Set)ImmutableSet.of(this.toType("F"), this.toType("H")));
        graph.addChildren(this.toType("J"), (Set)ImmutableSet.of(this.toType("K"), this.toType("L")));
        graph.addChildren(this.toType("K"), (Set)ImmutableSet.of(this.toType("M")));
        graph.addChildren(this.toType("M"), (Set)ImmutableSet.of(this.toType("L")));
        graph.addChildren(this.toType("L"), (Set)ImmutableSet.of(this.toType("M"), this.toType("N")));
        graph.addChildren(this.toType("F"), (Set)ImmutableSet.of(this.toType("H")));
        graph.addChildren(this.toType("H"), (Set)ImmutableSet.of(this.toType("F")));
        return graph;
    }
}

