/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.tests;

import java.math.BigInteger;
import junit.framework.TestCase;
import org.eclipse.emf.query.conditions.numbers.NumberCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberConditionsTest
extends TestCase {
    public void test_integers() {
        this.assertEqualTrue(10, 10);
        this.assertEqualFalse(10, 9);
        this.assertBetweenTrue(10, 10, 10);
        this.assertBetweenTrue(10, 10, 11);
        this.assertBetweenTrue(9, 10, 10);
        this.assertBetweenTrue(9, 10, 11);
        this.assertBetweenFalse(10, 9, 10);
        this.assertBetweenFalse(10, 11, 10);
        this.assertBetweenFalse(10, 9, 11);
        this.assertBetweenFalse(10, 12, 11);
    }

    public void test_doubles() {
        this.assertEqualTrue(10.0, 10.0);
        this.assertEqualFalse(10.0, 9.0);
        this.assertBetweenTrue(10.0, 10.0, 10.0);
        this.assertBetweenTrue(10.0, 10.0, 11.0);
        this.assertBetweenTrue(9.0, 10.0, 10.0);
        this.assertBetweenTrue(9.0, 10.0, 11.0);
        this.assertBetweenFalse(10.0, 9.0, 10.0);
        this.assertBetweenFalse(10.0, 11.0, 10.0);
        this.assertBetweenFalse(10.0, 9.0, 11.0);
        this.assertBetweenFalse(10.0, 12.0, 11.0);
    }

    public void test_bigIntegers() {
        BigInteger big = new BigInteger("1000000000000");
        BigInteger big2 = new BigInteger("1000000000000");
        BigInteger big3 = new BigInteger("1000000000000");
        BigInteger smaller = new BigInteger("100000000000");
        BigInteger bigger = new BigInteger("10000000000000");
        this.assertEqualTrue(big, big2);
        this.assertEqualFalse(big, smaller);
        this.assertBetweenTrue(big2, big, big3);
        this.assertBetweenTrue(big2, big, bigger);
        this.assertBetweenTrue(smaller, big, big3);
        this.assertBetweenTrue(smaller, big, bigger);
        this.assertBetweenFalse(big2, smaller, big3);
        this.assertBetweenFalse(big2, bigger, big3);
        this.assertBetweenFalse(big2, smaller, bigger);
        this.assertBetweenFalse(smaller, bigger, big3);
    }

    public void test_notEqualTo_21177() {
        this.assertNotEqualTrue(10, 11);
        this.assertNotEqualTrue(9, 10);
        this.assertNotEqualFalse(10, 10);
    }

    public void test_lessThan_21177() {
        this.assertLessThanTrue(10, 11);
        this.assertLessThanFalse(10, 10);
        this.assertLessThanFalse(11, 10);
    }

    public void test_lessOrEqual_21177() {
        this.assertLessOrEqualTrue(10, 11);
        this.assertLessOrEqualTrue(10, 10);
        this.assertLessOrEqualFalse(11, 10);
    }

    public void test_greaterThan_21177() {
        this.assertGreaterThanTrue(11, 10);
        this.assertGreaterThanFalse(10, 10);
        this.assertGreaterThanFalse(9, 10);
    }

    public void test_greaterOrEqual_21177() {
        this.assertGreaterOrEqualTrue(11, 10);
        this.assertGreaterOrEqualTrue(10, 10);
        this.assertGreaterOrEqualFalse(9, 10);
    }

    public void test_betweenWithExclusivity_21177() {
        this.assertBetweenTrue(9, true, 10, 11, true);
        this.assertBetweenTrue(10, true, 10, 11, true);
        this.assertBetweenTrue(9, true, 10, 10, true);
        this.assertBetweenTrue(10, true, 10, 10, true);
        this.assertBetweenFalse(11, true, 10, 11, true);
        this.assertBetweenFalse(11, true, 12, 11, true);
        this.assertBetweenTrue(9, false, 10, 11, false);
        this.assertBetweenFalse(10, false, 10, 11, false);
        this.assertBetweenFalse(9, false, 10, 10, false);
        this.assertBetweenFalse(10, true, 10, 10, false);
        this.assertBetweenFalse(11, false, 10, 11, false);
        this.assertBetweenFalse(11, false, 12, 11, false);
    }

    <N extends Number> void assertEqualTrue(N test, N value) {
        NumberConditionsTest.assertTrue((boolean)NumberCondition.equals(value).isSatisfied(test));
    }

    <N extends Number> void assertNotEqualTrue(N test, N value) {
        NumberConditionsTest.assertTrue((boolean)NumberCondition.notEquals(value).isSatisfied(test));
    }

    <N extends Number> void assertLessThanTrue(N test, N value) {
        NumberConditionsTest.assertTrue((boolean)NumberCondition.lessThan(value).isSatisfied(test));
    }

    <N extends Number> void assertLessOrEqualTrue(N test, N value) {
        NumberConditionsTest.assertTrue((boolean)NumberCondition.lessThanOrEquals(value).isSatisfied(test));
    }

    <N extends Number> void assertGreaterThanTrue(N test, N value) {
        NumberConditionsTest.assertTrue((boolean)NumberCondition.greaterThan(value).isSatisfied(test));
    }

    <N extends Number> void assertGreaterOrEqualTrue(N test, N value) {
        NumberConditionsTest.assertTrue((boolean)NumberCondition.greaterThanOrEquals(value).isSatisfied(test));
    }

    <N extends Number> void assertBetweenTrue(N low, N test, N high) {
        NumberConditionsTest.assertTrue((boolean)NumberCondition.between(low, high).isSatisfied(test));
    }

    <N extends Number> void assertBetweenTrue(N low, boolean lowInc, N test, N high, boolean highInc) {
        NumberConditionsTest.assertTrue((boolean)NumberCondition.between(low, (boolean)lowInc, high, (boolean)highInc).isSatisfied(test));
    }

    <N extends Number> void assertEqualFalse(N test, N value) {
        NumberConditionsTest.assertFalse((boolean)NumberCondition.equals(value).isSatisfied(test));
    }

    <N extends Number> void assertNotEqualFalse(N test, N value) {
        NumberConditionsTest.assertFalse((boolean)NumberCondition.notEquals(value).isSatisfied(test));
    }

    <N extends Number> void assertLessThanFalse(N test, N value) {
        NumberConditionsTest.assertFalse((boolean)NumberCondition.lessThan(value).isSatisfied(test));
    }

    <N extends Number> void assertLessOrEqualFalse(N test, N value) {
        NumberConditionsTest.assertFalse((boolean)NumberCondition.lessThanOrEquals(value).isSatisfied(test));
    }

    <N extends Number> void assertGreaterThanFalse(N test, N value) {
        NumberConditionsTest.assertFalse((boolean)NumberCondition.greaterThan(value).isSatisfied(test));
    }

    <N extends Number> void assertGreaterOrEqualFalse(N test, N value) {
        NumberConditionsTest.assertFalse((boolean)NumberCondition.greaterThanOrEquals(value).isSatisfied(test));
    }

    <N extends Number> void assertBetweenFalse(N low, N test, N high) {
        NumberConditionsTest.assertFalse((boolean)NumberCondition.between(low, high).isSatisfied(test));
    }

    <N extends Number> void assertBetweenFalse(N low, boolean lowInc, N test, N high, boolean highInc) {
        NumberConditionsTest.assertFalse((boolean)NumberCondition.between(low, (boolean)lowInc, high, (boolean)highInc).isSatisfied(test));
    }
}

