/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.annotations.pannotation.PrimaryKeyJoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.SecondaryTable;
import org.eclipse.emf.teneo.ecore.EModelResolver;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerAware;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.jpox.mapper.MappingContext;
import org.eclipse.emf.teneo.simpledom.Document;
import org.eclipse.emf.teneo.simpledom.DocumentHelper;
import org.eclipse.emf.teneo.simpledom.Element;

public class JPOXMappingGenerator
implements ExtensionPoint,
ExtensionManagerAware {
    protected static final Log log = LogFactory.getLog(JPOXMappingGenerator.class);
    protected static final String ORDER_COLUMN_SUFFIX = "_IDX";
    protected static final String ID_COLUMN_SUFFIX = "_ID";
    private MappingContext mappingContext;
    private String versionColumnName;
    private ExtensionManager extensionManager;

    public void setPersistenceOptions(PersistenceOptions po) {
        this.versionColumnName = po.getVersionColumnName();
    }

    public synchronized String generate(PAnnotatedModel annotatedModel) {
        this.mappingContext = (MappingContext)((Object)this.getExtensionManager().getExtension(MappingContext.class));
        this.mappingContext.setPaModel(annotatedModel);
        Document mappingDoc = new Document();
        mappingDoc.setDocType("<!DOCTYPE jdo SYSTEM \"file:/javax/jdo/jdo.dtd\">");
        Element rootElement = new Element();
        rootElement.setName("jdo");
        mappingDoc.setRoot(rootElement);
        ArrayList<ENamedElement> epackages = new ArrayList<ENamedElement>();
        for (Object element : annotatedModel.getPaEPackages()) {
            PAnnotatedEPackage aPackage = (PAnnotatedEPackage)element;
            epackages.add(aPackage.getModelElement());
        }
        EPackage[] epackagesArray = epackages.toArray(new EPackage[epackages.size()]);
        EModelResolver.instance().register(epackagesArray);
        this.mappingContext.setEpackages(epackagesArray);
        HashMap<Package, ArrayList<PAnnotatedEClass>> aClassesByPackage = new HashMap<Package, ArrayList<PAnnotatedEClass>>();
        for (Object element : annotatedModel.getPaEPackages()) {
            PAnnotatedEPackage aPackage = (PAnnotatedEPackage)element;
            log.info((Object)("Generating jdo for epackage " + aPackage.getModelElement().getName()));
            for (Object element2 : aPackage.getPaEClasses()) {
                PAnnotatedEClass aClass = (PAnnotatedEClass)element2;
                Class implClass = EModelResolver.instance().getJavaClass((EClassifier)((EClass)aClass.getModelElement()));
                if (aClass.getEntity() == null && aClass.getMappedSuperclass() == null || implClass == null) continue;
                Package implPackage = implClass.getPackage();
                ArrayList<PAnnotatedEClass> aclasses = (ArrayList<PAnnotatedEClass>)aClassesByPackage.get(implPackage);
                if (aclasses == null) {
                    aclasses = new ArrayList<PAnnotatedEClass>();
                    aClassesByPackage.put(implPackage, aclasses);
                }
                aclasses.add(aClass);
            }
        }
        for (Package implPackage : aClassesByPackage.keySet()) {
            ArrayList aclasses = (ArrayList)aClassesByPackage.get(implPackage);
            Element packElement = DocumentHelper.createElement((String)"package");
            packElement.addAttribute("name", implPackage.getName());
            rootElement.add(packElement);
            if (aclasses.size() <= 0) continue;
            Iterator aClassIt = aclasses.iterator();
            while (aClassIt.hasNext()) {
                this.processClassAnnotation(packElement, (PAnnotatedEClass)aClassIt.next());
            }
        }
        log.debug((Object)"JDO generation finished");
        return mappingDoc.emitXML();
    }

    private void processClassAnnotation(Element container, PAnnotatedEClass aClass) {
        if (aClass.getEntity() == null && aClass.getMappedSuperclass() == null && aClass.getEmbeddable() == null) {
            return;
        }
        if (aClass.getModelEClass().isInterface()) {
            log.debug((Object)(String.valueOf(aClass.getModelEClass().getName()) + " is interface, no explicit mapping"));
            return;
        }
        EClass eclass = (EClass)aClass.getModelElement();
        log.debug((Object)("Generating for eclass: " + eclass.getName()));
        if (eclass.getName().compareTo("DocumentRoot") == 0) {
            return;
        }
        Class implClass = EModelResolver.instance().getJavaClass((EClassifier)eclass);
        if (implClass == null) {
            log.warn((Object)("EClass " + eclass.getName() + " does not have a concrete representation. " + "This is not a problem for abstract eclasses"));
            return;
        }
        log.debug((Object)("Impl class: " + implClass));
        Element classElement = container.addElement("class");
        classElement.addAttribute("name", implClass.getName()).addAttribute("requires-extent", "true").addAttribute("persistence-modifier", "persistence-capable").addAttribute("detachable", "true");
        if (aClass.getEmbeddable() != null) {
            classElement.addAttribute("embedded-only", "true");
        }
        if (aClass.getIdClass() != null) {
            classElement.addAttribute("objectid-class", aClass.getIdClass().getValue());
        }
        ArrayList interfaces = new ArrayList();
        this.collectImplements(aClass, interfaces);
        for (Class iclass : interfaces) {
            Element impl = classElement.addElement("implements");
            impl.addAttribute("name", iclass.getName());
            log.debug((Object)("Added implements " + iclass.getName()));
        }
        this.mappingContext.getInheritanceMapper().map(aClass, classElement);
        if (aClass.hasVersionAnnotatedFeature()) {
            PAnnotatedEAttribute versionAttribute = null;
            for (Object element : aClass.getPaEStructuralFeatures()) {
                PAnnotatedEAttribute pae;
                PAnnotatedEStructuralFeature aStructuralFeature = (PAnnotatedEStructuralFeature)element;
                if (!(aStructuralFeature instanceof PAnnotatedEAttribute) || (pae = (PAnnotatedEAttribute)aStructuralFeature).getVersion() == null) continue;
                versionAttribute = pae;
            }
            Element version = classElement.addElement("version");
            version.addAttribute("strategy", "version-number");
            version.addAttribute("column", this.versionColumnName);
            if (versionAttribute.getColumn() != null) {
                this.mappingContext.getColumnMapper().map(versionAttribute.getColumn(), version);
            }
        } else {
            classElement.addElement("version").addAttribute("strategy", "version-number").addAttribute("column", this.versionColumnName);
        }
        if (aClass.getTable() != null) {
            this.mappingContext.getTableMapper().map(aClass.getTable(), classElement);
        }
        if (aClass.hasIdAnnotatedFeature()) {
            log.debug((Object)"Has id field");
            classElement.addAttribute("identity-type", "application");
        } else {
            log.debug((Object)"No explicit id field");
            classElement.addAttribute("identity-type", "datastore");
        }
        if (aClass.getSecondaryTables() != null && aClass.getSecondaryTables().size() > 0) {
            for (Object element : aClass.getSecondaryTables()) {
                SecondaryTable st = (SecondaryTable)element;
                Element joinElement = classElement.addElement("join");
                joinElement.addAttribute("table", st.getName());
                for (Object element2 : st.getPkJoinColumns()) {
                    PrimaryKeyJoinColumn pkjc = (PrimaryKeyJoinColumn)element2;
                    joinElement.addElement("column").addAttribute("name", pkjc.getName());
                }
            }
        }
        this.mappingContext.setCurrentAClass(aClass);
        this.mappingContext.getEClassFeatureMapper().map(aClass, classElement);
        this.mappingContext.setCurrentAClass(null);
        this.mappingContext.assertEmpty();
    }

    private void collectImplements(PAnnotatedEClass aClass, ArrayList result) {
        this.collectImplements(aClass.getModelEClass().getInstanceClass(), result);
        int i = 0;
        while (i < aClass.getModelEClass().getESuperTypes().size()) {
            EClass ec = (EClass)aClass.getModelEClass().getESuperTypes().get(i);
            PAnnotatedEClass ac = aClass.getPaModel().getPAnnotated(ec);
            if (ac != null && ac.getTransient() == null && !ec.isInterface()) {
                ArrayList inheritedInterfaces = new ArrayList();
                this.collectImplements(ec.getInstanceClass(), inheritedInterfaces);
                result.removeAll(inheritedInterfaces);
            }
            ++i;
        }
    }

    private void collectImplements(Class iclass, ArrayList result) {
        Class<?>[] interfaces;
        if (result.contains(iclass)) {
            return;
        }
        result.add(iclass);
        Class<?>[] classArray = interfaces = iclass.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> element = classArray[n2];
            this.collectImplements(element, result);
            ++n2;
        }
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }
}

