/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEModelElement;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PamodelPackage;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.mapper.BasicMapper;
import org.eclipse.emf.teneo.hibernate.mapper.EmbeddedMapper;
import org.eclipse.emf.teneo.hibernate.mapper.IdMapper;
import org.eclipse.emf.teneo.hibernate.mapper.ManyAttributeMapper;
import org.eclipse.emf.teneo.hibernate.mapper.ManyExternalReferenceMapper;
import org.eclipse.emf.teneo.hibernate.mapper.ManyToManyMapper;
import org.eclipse.emf.teneo.hibernate.mapper.ManyToOneMapper;
import org.eclipse.emf.teneo.hibernate.mapper.MappingContext;
import org.eclipse.emf.teneo.hibernate.mapper.MappingException;
import org.eclipse.emf.teneo.hibernate.mapper.OneToManyMapper;
import org.eclipse.emf.teneo.hibernate.mapper.OneToOneMapper;

public class FeatureMapper
implements ExtensionPoint {
    private static final EStructuralFeature[] PAEATTRIBUTE_DISCR_FEATURES = new EStructuralFeature[]{PamodelPackage.eINSTANCE.getPAnnotatedEModelElement_Transient(), PamodelPackage.eINSTANCE.getPAnnotatedEAttribute_Id(), PamodelPackage.eINSTANCE.getPAnnotatedEAttribute_Basic(), PamodelPackage.eINSTANCE.getPAnnotatedETypedElement_OneToMany(), PamodelPackage.eINSTANCE.getPAnnotatedEAttribute_Version()};
    private static final EStructuralFeature[] PAEREFERENCE_DISCR_FEATURES = new EStructuralFeature[]{PamodelPackage.eINSTANCE.getPAnnotatedEReference_External(), PamodelPackage.eINSTANCE.getPAnnotatedEModelElement_Transient(), PamodelPackage.eINSTANCE.getPAnnotatedETypedElement_OneToMany(), PamodelPackage.eINSTANCE.getPAnnotatedEReference_Embedded(), PamodelPackage.eINSTANCE.getPAnnotatedEReference_EmbeddedId(), PamodelPackage.eINSTANCE.getPAnnotatedEReference_ManyToMany(), PamodelPackage.eINSTANCE.getPAnnotatedEReference_ManyToOne(), PamodelPackage.eINSTANCE.getPAnnotatedEReference_OneToOne()};
    private BasicMapper basicMapper = null;
    private EmbeddedMapper embeddedMapper = null;
    private IdMapper idMapper = null;
    private ManyToManyMapper manyToManyMapper = null;
    private ManyToOneMapper manyToOneMapper = null;
    private ManyAttributeMapper manyAttributeMapper = null;
    private OneToManyMapper oneToManyMapper = null;
    private OneToOneMapper oneToOneMapper = null;
    private ManyExternalReferenceMapper manyExternalReferenceMapper;
    private MappingContext hbmContext = null;

    public static final EStructuralFeature getSwitchFeature(EObject eObject, EStructuralFeature[] features) {
        EStructuralFeature[] eStructuralFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature element = eStructuralFeatureArray[n2];
            if (eObject.eIsSet(element)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public void process(PAnnotatedEStructuralFeature paFeature) {
        this.hbmContext.setCurrentFeature(paFeature);
        if (paFeature instanceof PAnnotatedEAttribute) {
            this.processPAnnotatedEAttribute((PAnnotatedEAttribute)paFeature);
        } else {
            this.processPAnnotatedEReference((PAnnotatedEReference)paFeature);
        }
        this.hbmContext.setCurrentFeature(null);
    }

    private void processPAnnotatedEAttribute(PAnnotatedEAttribute pAnnotatedEAttribute) {
        Object discrFeature = pAnnotatedEAttribute.getAnnotations().isEmpty() ? PamodelPackage.eINSTANCE.getPAnnotatedEAttribute_Basic() : FeatureMapper.getSwitchFeature((EObject)pAnnotatedEAttribute, PAEATTRIBUTE_DISCR_FEATURES);
        if (discrFeature == null) {
            throw new MappingException("Can not map this paElement", (PAnnotatedEModelElement)pAnnotatedEAttribute);
        }
        switch (discrFeature.getFeatureID()) {
            case 1: {
                this.basicMapper.processTransient((PAnnotatedEStructuralFeature)pAnnotatedEAttribute);
                break;
            }
            case 13: {
                this.caseBasic(pAnnotatedEAttribute);
                break;
            }
            case 16: {
                this.idMapper.processIdProperty(pAnnotatedEAttribute);
                break;
            }
            case 4: {
                this.manyAttributeMapper.processManyAttribute(pAnnotatedEAttribute);
                break;
            }
            case 19: {
                this.basicMapper.processVersion(pAnnotatedEAttribute);
                break;
            }
            default: {
                throw new AssertionError((Object)"unexpected case");
            }
        }
    }

    private void processPAnnotatedEReference(PAnnotatedEReference pAnnotatedEReference) {
        Object discrFeature = pAnnotatedEReference.getAnnotations().isEmpty() ? PamodelPackage.eINSTANCE.getPAnnotatedEReference_Embedded() : FeatureMapper.getSwitchFeature((EObject)pAnnotatedEReference, PAEREFERENCE_DISCR_FEATURES);
        if (discrFeature == null) {
            throw new MappingException("Can not map this paElement", (PAnnotatedEModelElement)pAnnotatedEReference);
        }
        switch (discrFeature.getFeatureID()) {
            case 22: {
                if (pAnnotatedEReference.getModelEReference().isMany()) {
                    this.manyExternalReferenceMapper.processManyReference(pAnnotatedEReference);
                    break;
                }
                this.basicMapper.processExternalEReference(pAnnotatedEReference);
                break;
            }
            case 1: {
                this.basicMapper.processTransient((PAnnotatedEStructuralFeature)pAnnotatedEReference);
                break;
            }
            case 13: {
                this.embeddedMapper.process(pAnnotatedEReference);
                break;
            }
            case 14: {
                this.idMapper.processEmbeddedId(pAnnotatedEReference);
                break;
            }
            case 15: {
                this.manyToManyMapper.process(pAnnotatedEReference);
                break;
            }
            case 16: {
                this.manyToOneMapper.process(pAnnotatedEReference);
                break;
            }
            case 4: {
                this.oneToManyMapper.process(pAnnotatedEReference);
                break;
            }
            case 18: {
                this.oneToOneMapper.process(pAnnotatedEReference);
                break;
            }
            default: {
                throw new AssertionError((Object)"unexpected case");
            }
        }
    }

    public Object caseBasic(PAnnotatedEAttribute paAttribute) {
        if (paAttribute.getEnumerated() != null) {
            this.basicMapper.processEnum(paAttribute);
        } else if (paAttribute.getLob() != null) {
            this.basicMapper.processLob(paAttribute);
        } else if (paAttribute.getTemporal() != null) {
            this.basicMapper.processTemporal(paAttribute);
        } else {
            this.basicMapper.processBasic(paAttribute);
        }
        return Boolean.TRUE;
    }

    public Object defaultCase(EObject object) {
        throw new IllegalArgumentException("Unexpected argument " + object);
    }

    public void setBasicMapper(BasicMapper basicMapper) {
        this.basicMapper = basicMapper;
    }

    public void setEmbeddedMapper(EmbeddedMapper embeddedMapper) {
        this.embeddedMapper = embeddedMapper;
    }

    public void setIdMapper(IdMapper idMapper) {
        this.idMapper = idMapper;
    }

    public void setManyToManyMapper(ManyToManyMapper manyToManyMapper) {
        this.manyToManyMapper = manyToManyMapper;
    }

    public void setManyToOneMapper(ManyToOneMapper manyToOneMapper) {
        this.manyToOneMapper = manyToOneMapper;
    }

    public void setManyAttributeMapper(ManyAttributeMapper manyAttributeMapper) {
        this.manyAttributeMapper = manyAttributeMapper;
    }

    public void setOneToManyMapper(OneToManyMapper oneToManyMapper) {
        this.oneToManyMapper = oneToManyMapper;
    }

    public OneToManyMapper getOneToManyMapper() {
        return this.oneToManyMapper;
    }

    public void setOneToOneMapper(OneToOneMapper oneToOneMapper) {
        this.oneToOneMapper = oneToOneMapper;
    }

    public void setHbmContext(MappingContext hbmContext) {
        this.hbmContext = hbmContext;
    }

    public ManyExternalReferenceMapper getManyExternalReferenceMapper() {
        return this.manyExternalReferenceMapper;
    }

    public void setManyExternalReferenceMapper(ManyExternalReferenceMapper manyExternalReferenceMapper) {
        this.manyExternalReferenceMapper = manyExternalReferenceMapper;
    }
}

