/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.elist;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.PersistenceCapable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.DelegatingEcoreEList;
import org.eclipse.emf.teneo.EContainerRepairControl;
import org.eclipse.emf.teneo.jpox.JpoxStoreException;
import org.eclipse.emf.teneo.jpox.JpoxUtil;
import org.eclipse.emf.teneo.jpox.elist.JPOXArrayList;
import org.eclipse.emf.teneo.jpox.mapping.AnyTypeEObject;
import org.eclipse.emf.teneo.jpox.mapping.AnyTypeObject;
import org.eclipse.emf.teneo.jpox.resource.JPOXResource;
import org.eclipse.emf.teneo.mapping.elist.PersistableEList;
import org.eclipse.emf.teneo.resource.StoreResource;
import org.eclipse.emf.teneo.util.AssertUtil;
import org.eclipse.emf.teneo.util.FieldUtil;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.jpox.AbstractPersistenceManager;
import org.jpox.StateManager;
import org.jpox.sco.SCO;
import org.jpox.sco.SCOList;
import org.jpox.sco.exceptions.QueryUnownedSCOException;
import org.jpox.state.FetchPlanState;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.query.Queryable;
import org.jpox.store.query.ResultObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EListWrapper<E>
extends PersistableEList<E>
implements SCO,
Queryable,
SCOList {
    private static final long serialVersionUID = -6719775217240311479L;
    private static Log log = LogFactory.getLog(EListWrapper.class);
    private StateManager stateManager = null;
    private String elistFieldName = null;
    protected JPOXArrayList jdoDelegate = null;
    private final boolean containmentList;
    private final boolean isEObjectList;
    private final boolean isObjectList;
    private EReference eOpposite;

    public EListWrapper(StateManager ownerSM, String fieldName) {
        this(ownerSM, fieldName, new ArrayList());
    }

    public EListWrapper(StateManager ownerSM, String fieldName, List<E> list) {
        super((InternalEObject)ownerSM.getObject(), StoreUtil.getEStructuralFeature((EObject)((InternalEObject)ownerSM.getObject()), (String)fieldName), new ArrayList<E>(list));
        AssertUtil.assertTrue((String)"The delegate may not be an elistwrapper", (!(this.getDelegate() instanceof EListWrapper) ? 1 : 0) != 0);
        this.stateManager = ownerSM;
        this.containmentList = this.getEStructuralFeature() instanceof EAttribute || ((EReference)this.getEStructuralFeature()).isContainment();
        this.jdoDelegate = new JPOXArrayList(ownerSM, fieldName);
        this.elistFieldName = fieldName;
        Class elementType = this.getEStructuralFeature().getEType().getInstanceClass();
        this.isEObjectList = elementType == EObject.class;
        boolean bl = this.isObjectList = elementType == Object.class;
        if (!list.isEmpty()) {
            this.jdoDelegate.setValueFrom(list, false);
            this.jdoDelegate.setCacheLoaded(true);
            this.setIsLoaded(true);
        } else if (this.jdoDelegate.isLoaded()) {
            this.load();
        }
        this.setEOpposite();
    }

    protected EListWrapper(EListWrapper<E> copyFrom) {
        super((InternalEObject)copyFrom.getEObject(), copyFrom.getEStructuralFeature(), new ArrayList());
        this.containmentList = copyFrom.containmentList;
        this.jdoDelegate = new JPOXArrayList(copyFrom.stateManager, copyFrom.elistFieldName);
        this.isEObjectList = copyFrom.isEObjectList;
        this.isObjectList = copyFrom.isObjectList;
        log.debug((Object)("Cloned elist: " + this.getLogString()));
        this.setEOpposite();
    }

    private void setEOpposite() {
        if (!(this.getEStructuralFeature() instanceof EReference)) {
            return;
        }
        EReference eref = (EReference)this.getEStructuralFeature();
        this.eOpposite = eref.getEOpposite();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.jdoDelegate = null;
        this.stateManager = null;
        this.eOpposite = null;
        this.additionalWriteObject();
        out.defaultWriteObject();
    }

    private Object replaceForAnyType(Object obj) {
        if (this.isEObjectList) {
            return this.replaceForAnyTypeEObject(obj);
        }
        if (this.isObjectList) {
            return this.replaceForAnyTypeObject(obj);
        }
        return obj;
    }

    protected void additionalWriteObject() {
    }

    private Object replaceForAnyTypeObject(Object obj) {
        assert (this.isObjectList);
        if (this.jdoDelegate == null) {
            return obj;
        }
        if (obj instanceof AnyTypeObject) {
            return obj;
        }
        return new AnyTypeObject(this.getPM(), obj);
    }

    private Object replaceForAnyTypeEObject(Object obj) {
        assert (this.isEObjectList);
        assert (obj instanceof EObject);
        if (this.jdoDelegate == null) {
            return obj;
        }
        if (obj instanceof AnyTypeEObject) {
            return obj;
        }
        return new AnyTypeEObject(this.getPM(), (EObject)obj);
    }

    public void detach(FetchPlanState state) {
        Object[] values;
        if (this.jdoDelegate == null) {
            return;
        }
        if (!this.isLoaded()) {
            return;
        }
        this.load();
        this.jdoDelegate.detach(state);
        Object[] objectArray = values = this.toArray();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element != null && element instanceof PersistenceCapable) {
                this.stateManager.getPersistenceManager().detachInternal(element, state);
            }
            ++n2;
        }
        this.stateManager = null;
        this.jdoDelegate = null;
    }

    public Object detachCopy(FetchPlanState state) {
        Object[] values;
        final ArrayList<Object> detached = new ArrayList<Object>();
        Object[] objectArray = values = this.toArray();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == null) {
                detached.add(null);
            } else if (object instanceof PersistenceCapable) {
                detached.add(this.stateManager.getPersistenceManager().detachCopyInternal(object, state));
            } else {
                detached.add(object);
            }
            ++n2;
        }
        final EStructuralFeature feature = this.getEStructuralFeature();
        InternalEObject myOwner = (InternalEObject)this.getOwner();
        DelegatingEcoreEList elist = new DelegatingEcoreEList<E>(myOwner){

            protected List<E> delegateList() {
                return detached;
            }

            public EStructuralFeature getEStructuralFeature() {
                return feature;
            }
        };
        return elist;
    }

    public void detachSelf() {
        this.jdoDelegate = null;
        this.stateManager = null;
    }

    public void runReachability(Set reachables) {
        Object[] values;
        Object[] objectArray = values = this.toArray();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            StateManager sm;
            Object element = objectArray[n2];
            if (element != null && element instanceof PersistenceCapable && (sm = this.stateManager.getPersistenceManager().findStateManager((PersistenceCapable)element)) != null) {
                sm.runReachability(reachables);
            }
            ++n2;
        }
    }

    public Object set(int arg0, Object arg1, boolean arg2) {
        return this.jdoDelegate.set(arg0, arg1, arg2);
    }

    public boolean isInitialized() {
        return this.isLoaded();
    }

    private boolean isOwnerDetached() {
        PersistenceCapable pc = (PersistenceCapable)this.getEObject();
        return pc.jdoIsDetached();
    }

    private PersistenceManager getPM() {
        PersistenceCapable pc = (PersistenceCapable)this.getEObject();
        if (!pc.jdoIsDetached()) {
            return pc.jdoGetPersistenceManager();
        }
        throw new JpoxStoreException("This method may not be called if the elist is detached");
    }

    public Object clone() {
        return new EListWrapper<E>(this);
    }

    public void setValueFrom(Object o) {
        Collection c = (Collection)o;
        this.clear();
        this.delegate.addAll(c);
    }

    public String getFieldName() {
        return this.elistFieldName;
    }

    public Object getOwner() {
        return this.getEObject();
    }

    public synchronized void unsetOwner() {
        log.debug((Object)("Unsetting owner of elist " + this.getLogString()));
        if (this.jdoDelegate != null) {
            this.jdoDelegate = null;
            this.stateManager = null;
        }
    }

    public void makeDirty() {
        if (this.jdoDelegate != null) {
            this.jdoDelegate.makeDirty();
        }
    }

    public void makeTransient(FetchPlanState state) {
        Object[] values;
        Object[] objectArray = values = this.toArray();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element != null && element instanceof PersistenceCapable) {
                this.stateManager.getPersistenceManager().findStateManager((PersistenceCapable)element).makeTransient(state);
            }
            ++n2;
        }
        this.stateManager = null;
        this.jdoDelegate = null;
    }

    public void setValueFrom(Object arg0, boolean arg1) throws ClassCastException {
        Collection c = (Collection)arg0;
        if (arg1) {
            this.clear();
            this.addAll(c);
        } else {
            this.getDelegate().clear();
            this.getDelegate().addAll(c);
        }
    }

    public Class<?> getElementType() {
        return this.getEStructuralFeature().getEType().getInstanceClass();
    }

    public void attachCopy(Object value) {
        if (value instanceof PersistableEList && !((PersistableEList)value).isLoaded()) {
            return;
        }
        Collection c = (Collection)value;
        this.load();
        ArrayList<Object> attachedElements = new ArrayList<Object>(c.size());
        for (PersistenceCapable detachedElement : c) {
            attachedElements.add(((AbstractPersistenceManager)this.getPM()).attachCopy((Object)detachedElement, false));
        }
        log.debug((Object)("Attaching " + attachedElements.size() + " objects to elist " + this.getLogString()));
        JpoxUtil.updateListWithListElements((List)((Object)this.jdoDelegate), attachedElements);
        this.getDelegate().clear();
        this.getDelegate().addAll(this.jdoDelegate);
    }

    public synchronized ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        if (this.jdoDelegate == null) {
            throw new QueryUnownedSCOException();
        }
        return this.jdoDelegate.newResultObjectFactory(stmt, ignoreCache, resultClass, useFetchPlan);
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        if (this.jdoDelegate != null) {
            this.jdoDelegate.updateEmbeddedElement(element, fieldNumber, value);
        }
    }

    public synchronized QueryExpression newQueryStatement() {
        if (this.jdoDelegate == null) {
            throw new QueryUnownedSCOException();
        }
        return this.jdoDelegate.newQueryStatement();
    }

    public synchronized QueryExpression newQueryStatement(Class candidate_class) {
        if (this.jdoDelegate == null) {
            throw new QueryUnownedSCOException();
        }
        return this.jdoDelegate.newQueryStatement(candidate_class);
    }

    protected synchronized void doLoad() {
        boolean setLoading;
        AssertUtil.assertTrue((String)("EList " + this.getLogString() + " is already loaded"), (!this.isLoaded() ? 1 : 0) != 0);
        Resource res = this.getEObject().eResource();
        boolean bl = setLoading = res != null && res instanceof JPOXResource && !((StoreResource)res).isLoading();
        if (setLoading) {
            ((StoreResource)res).setIsLoading(true);
        }
        Object list = this.getDelegate();
        Iterator iter = this.jdoDelegate.iterator();
        while (iter.hasNext()) {
            Object child = iter.next();
            if (child instanceof AnyTypeEObject) {
                child = ((AnyTypeEObject)child).getEObject();
            } else if (child instanceof AnyTypeObject) {
                child = ((AnyTypeObject)child).getObject();
            }
            list.add(child);
        }
        Iterator it = this.getDelegate().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (this.containmentList) {
                EContainerRepairControl.repair((Object)this.getEObject(), child, (EStructuralFeature)this.getEStructuralFeature());
                continue;
            }
            if (res == null || !(res instanceof ResourceImpl) || !(child instanceof EObject) || ((EObject)child).eResource() != null) continue;
            ((StoreResource)res).addToContentOrAttach((InternalEObject)child, (EReference)this.getEStructuralFeature());
        }
        if (setLoading) {
            ((JPOXResource)res).setIsLoading(false);
        }
    }

    public boolean isPersistencyWrapped() {
        return true;
    }

    protected void didAdd(int index, E newObject) {
        if (this.jdoDelegate != null) {
            if (this.eOpposite != null && !this.eOpposite.isMany()) {
                Object oppValueOld = ((EObject)newObject).eGet((EStructuralFeature)this.eOpposite);
                this.jdoDelegate.add(index, this.replaceForAnyType(newObject));
                Object oppValueNew = ((EObject)newObject).eGet((EStructuralFeature)this.eOpposite);
                if (oppValueNew != oppValueOld) {
                    assert (this.getOwner() == oppValueNew);
                    try {
                        Field f = FieldUtil.getField(newObject.getClass(), (String)this.eOpposite.getName());
                        f.set(newObject, oppValueOld);
                    }
                    catch (Exception e) {
                        throw new JpoxStoreException("Exception while directly setting field " + this.eOpposite.getName(), e);
                    }
                }
            } else {
                this.jdoDelegate.add(index, this.replaceForAnyType(newObject));
            }
        }
        super.didAdd(index, newObject);
    }

    protected void didChange() {
        if (this.jdoDelegate != null) {
            this.jdoDelegate.makeDirty();
        }
        super.didChange();
    }

    protected void didClear(int size, Object[] oldObjects) {
        if (oldObjects == null) {
            return;
        }
        if (this.jdoDelegate != null) {
            this.jdoDelegate.clear();
        }
        if (this.containmentList && !this.isOwnerDetached()) {
            ArrayList<Object> pcList = new ArrayList<Object>();
            Object[] objectArray = oldObjects;
            int n = oldObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof PersistenceCapable) {
                    pcList.add(element);
                }
                ++n2;
            }
            this.getPM().deletePersistentAll(pcList);
        }
    }

    protected void didMove(int index, E movedObject, int oldIndex) {
        if (this.jdoDelegate != null) {
            Object obj = this.jdoDelegate.get(oldIndex);
            this.jdoDelegate.add(index, obj);
        }
        super.didMove(index, movedObject, oldIndex);
    }

    protected void didRemove(int index, E oldObject) {
        if (this.jdoDelegate != null) {
            PersistenceCapable pc;
            Object obj;
            if (this.eOpposite != null && !this.eOpposite.isMany()) {
                Object oppValueOld = ((EObject)oldObject).eGet((EStructuralFeature)this.eOpposite);
                obj = this.jdoDelegate.remove(index);
                Object oppValueNew = ((EObject)oldObject).eGet((EStructuralFeature)this.eOpposite);
                if (oppValueNew != oppValueOld) {
                    assert (this.getOwner() == oppValueNew);
                    try {
                        Field f = FieldUtil.getField(oldObject.getClass(), (String)this.eOpposite.getName());
                        f.set(oldObject, oppValueOld);
                    }
                    catch (Exception e) {
                        throw new JpoxStoreException("Exception while directly setting field " + this.eOpposite.getName(), e);
                    }
                }
            } else {
                obj = this.jdoDelegate.remove(index);
            }
            if (this.containmentList && !this.isOwnerDetached() && obj instanceof PersistenceCapable && this.owner.eResource() == null && ((pc = (PersistenceCapable)oldObject).jdoIsPersistent() || pc.jdoIsTransactional())) {
                this.getPM().deletePersistent(oldObject);
            }
        }
        super.didRemove(index, oldObject);
    }

    protected void didSet(int index, E newObject, E oldObject) {
        if (this.jdoDelegate != null) {
            PersistenceCapable pc;
            this.jdoDelegate.set(index, this.replaceForAnyType(newObject));
            if (this.containmentList && !this.isOwnerDetached() && oldObject instanceof PersistenceCapable && ((pc = (PersistenceCapable)oldObject).jdoIsPersistent() || pc.jdoIsTransactional())) {
                this.getPM().deletePersistent(oldObject);
            }
        }
        super.didSet(index, newObject, oldObject);
    }

    public void load() {
        super.load();
    }

    public void loadFieldsInFetchPlan(FetchPlanState arg0) {
        Object[] values;
        if (!this.isLoaded()) {
            return;
        }
        if (this.stateManager == null) {
            return;
        }
        Object[] objectArray = values = this.toArray();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element != null && element instanceof PersistenceCapable) {
                this.stateManager.getPersistenceManager().findStateManager((PersistenceCapable)element).loadFieldsInFetchPlan(arg0);
            }
            ++n2;
        }
    }
}

