/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.teneo.classloader.ClassLoaderResolver;
import org.eclipse.emf.teneo.classloader.StoreClassLoadException;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.hibernate.HibernateException;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ENumUserType
implements UserType,
ParameterizedType {
    private static final int[] SQL_TYPES = new int[]{12};
    protected Class<?> enumType;
    protected Method getMethod;
    private final HashMap<String, Enumerator> localCache = new HashMap();

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null && y == null) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.getClass() != y.getClass()) {
            return false;
        }
        assert (x instanceof Enumerator);
        return ((Enumerator)x).getValue() == ((Enumerator)y).getValue();
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String name = rs.getString(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        Enumerator enumValue = this.localCache.get(name);
        if (enumValue != null) {
            return enumValue;
        }
        try {
            enumValue = (Enumerator)this.getMethod.invoke(null, name.trim());
        }
        catch (Exception e) {
            throw new HbMapperException("Exception when getting enum for class: " + this.enumType.getName() + " using value: " + name, (Throwable)e);
        }
        if (enumValue == null) {
            throw new HbMapperException("The enum value " + name + " is not valid for enumerator: " + this.enumType.getName());
        }
        this.localCache.put(name, enumValue);
        return enumValue;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 12);
        } else {
            st.setString(index, ((Enumerator)value).getLiteral());
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Class<?> returnedClass() {
        return this.enumType;
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public void setParameterValues(Properties parameters) {
        String enumClassName = parameters.getProperty("enumClass");
        try {
            this.enumType = ClassLoaderResolver.classForName((String)enumClassName);
            this.getMethod = this.enumType.getMethod("get", String.class);
        }
        catch (StoreClassLoadException e) {
            throw new HbMapperException("Enum class " + enumClassName + " can not be found", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new HbMapperException("Get method not present in enum class " + enumClassName, (Throwable)e);
        }
    }
}

